/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.mgmt.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyFileHandlerCallBack;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.impl.AbstractDependencyFileHandler;
import com.oracle.cie.dependency.mgmt.impl.PomDependencyFileHandlerImpl;
import com.oracle.cie.dependency.mgmt.xml.ivy.IvyModule;
import com.oracle.cie.dependency.mgmt.xml.ivy.ObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IvyDependencyFileHandlerImpl
extends AbstractDependencyFileHandler {
    public static final String DEFAULT_MODULE_TYPE = "xml";
    private static JAXBContext contextReader;
    private static JAXBContext contextWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IvyDependencyFileHandlerImpl() throws DependencyManagementException {
        Class<PomDependencyFileHandlerImpl> clazz = PomDependencyFileHandlerImpl.class;
        synchronized (PomDependencyFileHandlerImpl.class) {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(PomDependencyFileHandlerImpl.class.getClassLoader());
                if (contextReader == null) {
                    contextReader = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
                }
                if (contextWriter == null) {
                    IvyModule ivyModule = new IvyModule();
                    contextWriter = JAXBContext.newInstance((String)ivyModule.getClass().getPackage().getName(), (ClassLoader)ivyModule.getClass().getClassLoader());
                }
            }
            catch (JAXBException e) {
                throw new DependencyManagementException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public DependencyFileType getType() {
        return DependencyFileType.ivy;
    }

    @Override
    public Module readDependenciesFile(InputStream is, DependencyFileHandlerCallBack callBack) throws IOException, DependencyManagementException {
        Module module;
        block18: {
            if (is == null) {
                throw new DependencyManagementException("The input stream provided was null.");
            }
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                docFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                docFactory.setExpandEntityReferences(false);
                docFactory.setNamespaceAware(true);
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document document = docBuilder.parse(is);
                Unmarshaller unmarshaller = contextReader.createUnmarshaller();
                Object o = unmarshaller.unmarshal((Node)document);
                if (o instanceof JAXBElement) {
                    o = ((JAXBElement)o).getValue();
                }
                if (!(o instanceof IvyModule)) {
                    throw new DependencyManagementException("Parsed object was not the expected type.  Expected " + IvyModule.class + " Actual:" + o.getClass());
                }
                IvyModule ivyModule = (IvyModule)o;
                IvyModule.Info ivyInfo = ivyModule.getInfo();
                if (ivyInfo == null) {
                    throw new DependencyManagementException("Ivy file contained no info section.");
                }
                module = DependencyManagementFactory.getInstance().getModule(ivyInfo.getOrganisation(), ivyInfo.getModule(), ivyInfo.getRevision(), DEFAULT_MODULE_TYPE);
                module.setModuleType(DEFAULT_MODULE_TYPE);
                ArrayList<Artifact> artifacts = null;
                IvyModule.Publications publications = ivyModule.getPublications();
                if (publications != null) {
                    artifacts = new ArrayList<Artifact>();
                    List<IvyModule.Publications.Artifact> ivyArtifacts = publications.getArtifact();
                    if (ivyArtifacts != null && !ivyArtifacts.isEmpty()) {
                        for (IvyModule.Publications.Artifact ivyArtifact : ivyArtifacts) {
                            String name = StringUtil.isNullOrEmpty((String)ivyArtifact.getName(), (boolean)true) ? ivyInfo.getModule() : ivyArtifact.getName();
                            String ext = ivyArtifact.getExt();
                            if (StringUtil.isNullOrEmpty((String)ext, (boolean)true)) {
                                ext = ivyArtifact.getType();
                            }
                            artifacts.add(DependencyManagementFactory.getInstance().getArtifact(ivyInfo.getOrganisation(), name, ivyInfo.getRevision(), ext));
                        }
                    }
                }
                module.setArtifacts(artifacts);
                IvyModule.Dependencies ivyDeps = ivyModule.getDependencies();
                if (ivyDeps == null) break block18;
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                List<IvyModule.Dependencies.Dependency> ivyDepsDeps = ivyDeps.getDependency();
                for (IvyModule.Dependencies.Dependency ivyDep : ivyDepsDeps) {
                    String depClassifier = this.getOtherAttribute(ivyDep.getOtherAttributes(), "classifier", null);
                    List<IvyModule.Dependencies.Dependency.Artifact> ivyArtifacts = ivyDep.getArtifact();
                    if (ivyArtifacts != null && !ivyArtifacts.isEmpty()) {
                        for (IvyModule.Dependencies.Dependency.Artifact ivyArtifact : ivyArtifacts) {
                            String artifactClassifier = this.getOtherAttribute(ivyArtifact.getOtherAttributes(), "classifier", depClassifier);
                            String ext = ivyArtifact.getExt();
                            if (StringUtil.isNullOrEmpty((String)ext, (boolean)true)) {
                                ext = ivyArtifact.getType();
                            }
                            Dependency dependency = DependencyManagementFactory.getInstance().getDependency(ivyDep.getOrg(), ivyArtifact.getName(), ivyDep.getRev(), ext);
                            if (!StringUtil.isNullOrEmpty((String)artifactClassifier, (boolean)true)) {
                                dependency.setClassifier(artifactClassifier);
                            }
                            dependencies.add(dependency);
                        }
                        continue;
                    }
                    Dependency dependency = DependencyManagementFactory.getInstance().getDependency(ivyDep.getOrg(), ivyDep.getName(), ivyDep.getRev());
                    if (!StringUtil.isNullOrEmpty((String)depClassifier, (boolean)true)) {
                        dependency.setClassifier(depClassifier);
                    }
                    dependencies.add(dependency);
                }
                module.setDependencies(dependencies);
            }
            catch (JAXBException e) {
                throw new DependencyManagementException(e);
            }
            catch (ParserConfigurationException e) {
                throw new DependencyManagementException(e);
            }
            catch (SAXException e) {
                throw new DependencyManagementException(e);
            }
        }
        return module;
    }

    @Override
    public void writeDependenciesFile(Module module, OutputStream os) throws IOException, DependencyManagementException {
        List<Dependency> dependencies;
        if (module == null) {
            throw new DependencyManagementException("The module provided was null.");
        }
        if (os == null) {
            throw new DependencyManagementException("The output stream provided was null.");
        }
        IvyModule ivyModule = new IvyModule();
        IvyModule.Info ivyInfo = new IvyModule.Info();
        ivyInfo.setOrganisation(module.getGroup());
        ivyInfo.setModule(module.getName());
        ivyInfo.setRevision(module.getVersionString());
        ivyModule.setInfo(ivyInfo);
        List<Artifact> artifacts = module.getArtifacts();
        if (artifacts != null) {
            IvyModule.Publications publications = new IvyModule.Publications();
            if (!artifacts.isEmpty()) {
                List<IvyModule.Publications.Artifact> ivyArtifacts = publications.getArtifact();
                for (Artifact artifact : artifacts) {
                    IvyModule.Publications.Artifact ivyArtifact = new IvyModule.Publications.Artifact();
                    ivyArtifact.setName(artifact.getName());
                    ivyArtifact.setType(artifact.getType());
                    ivyArtifacts.add(ivyArtifact);
                }
            }
            ivyModule.setPublications(publications);
        }
        if ((dependencies = module.getDependencies()) != null && !dependencies.isEmpty()) {
            IvyModule.Dependencies ivyDeps = new IvyModule.Dependencies();
            ivyModule.setDependencies(ivyDeps);
            List<IvyModule.Dependencies.Dependency> ivyDepsDeps = ivyDeps.getDependency();
            for (Dependency dependency : dependencies) {
                String classifier;
                IvyModule.Dependencies.Dependency ivyDep = new IvyModule.Dependencies.Dependency();
                ivyDep.setOrg(dependency.getGroup());
                ivyDep.setName(dependency.getName());
                ivyDep.setRev(dependency.getVersionString());
                String type = dependency.getType();
                if (!"jar".equals(type)) {
                    IvyModule.Dependencies.Dependency.Artifact artifact = new IvyModule.Dependencies.Dependency.Artifact();
                    artifact.setName(dependency.getName());
                    artifact.setType(type);
                    ivyDep.getArtifact().add(artifact);
                }
                if (!StringUtil.isNullOrEmpty((String)(classifier = dependency.getClassifier()))) {
                    ivyDep.getOtherAttributes().put(new QName("http://ant.apache.org/ivy/extra", "classifier", "e"), classifier);
                }
                ivyDepsDeps.add(ivyDep);
            }
        }
        try {
            Marshaller marshaller = contextWriter.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)ivyModule, os);
        }
        catch (JAXBException e) {
            throw new DependencyManagementException(e);
        }
    }

    private String getOtherAttribute(Map<QName, String> otherAttributes, String attributeName, String defaultValue) {
        if (!StringUtil.isNullOrEmpty((String)attributeName, (boolean)true) && otherAttributes != null && !otherAttributes.isEmpty()) {
            for (QName qname : otherAttributes.keySet()) {
                if (!attributeName.equals(qname.getLocalPart())) continue;
                return otherAttributes.get(qname);
            }
        }
        return defaultValue;
    }
}

