/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.mgmt.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.dependency.mgmt.GroupNameVersion;
import com.oracle.cie.dependency.mgmt.Version;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class GroupNameVersionImpl
implements GroupNameVersion {
    protected String _group;
    protected String _name;
    protected Version _version;
    protected String _type;
    protected String _classifier;

    public GroupNameVersionImpl(String group, String name, String version) {
        this(group, name, version, null);
    }

    public GroupNameVersionImpl(String group, String name, String version, String type) {
        this(group, name, version, type, null);
    }

    public GroupNameVersionImpl(String group, String name, String baseVersion, String type, String ... qualifiers) {
        this(group, name, DependencyManagementFactory.getInstance().getVersion(baseVersion, qualifiers), type);
    }

    public GroupNameVersionImpl(String group, String name, Version version) {
        this(group, name, version, null);
    }

    public GroupNameVersionImpl(String group, String name, Version version, String type) {
        this.init(group, name, version, type);
    }

    protected void init(String group, String name, Version version, String type) throws IllegalArgumentException {
        if (StringUtil.isNullOrEmpty((String)group, (boolean)true)) {
            throw new IllegalArgumentException("The group provided was null or empty {" + group + ":" + name + ":" + version + ":" + type + "}");
        }
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            throw new IllegalArgumentException("The name provided was null or empty {" + group + ":" + name + ":" + version + ":" + type + "}");
        }
        if (!StringUtil.isNullOrEmpty((String)type, (boolean)true) && type.contains(" ")) {
            throw new IllegalArgumentException("The type may not contain spaces {" + group + ":" + name + ":" + version + ":" + type + "}");
        }
        this._group = DependencyManagementHelper.convertSpaces(group);
        this._name = DependencyManagementHelper.convertSpaces(name);
        this._type = !StringUtil.isNullOrEmpty((String)type, (boolean)true) ? type : "jar";
        this.setVersion(version);
    }

    public boolean isVersionRequired() {
        return true;
    }

    @Override
    public String getGroup() {
        return this._group;
    }

    @Override
    public void setGroup(String group) {
        this._group = group;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(String version) {
        this.setVersion(DependencyManagementFactory.getInstance().getVersion(version));
    }

    @Override
    public void setVersion(Version version) {
        if (this.isVersionRequired() && version == null) {
            throw new IllegalArgumentException("The version provided was null or empty {" + this.getGroup() + ":" + this.getName() + ":" + version + ":" + this.getType() + "}");
        }
        this._version = version;
    }

    @Override
    public String getVersionString() {
        return this._version.getVersion();
    }

    @Override
    public String getBaseVersion() {
        return this._version.getBaseVersion();
    }

    @Override
    public String[] getQualifiers() {
        return this._version.getQualifiers();
    }

    @Override
    public String getQualifier(int position) {
        return this._version.getQualifier(position);
    }

    @Override
    public String getClassifier() {
        return this._classifier;
    }

    @Override
    public void setClassifier(String classifier) {
        this._classifier = classifier;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public void setType(String type) {
        this._type = type;
    }

    @Override
    public File getLocalLocation(File localRepoLocation) {
        return new File(localRepoLocation, this.getRepoPath());
    }

    @Override
    public URL getRemoteLocation(String repositoryUrl) throws MalformedURLException {
        if (repositoryUrl != null && !repositoryUrl.endsWith("/")) {
            repositoryUrl = repositoryUrl + "/";
        }
        return new URL(repositoryUrl + this.getRepoPath());
    }

    @Override
    public String getFileName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName());
        buf.append("-").append(this.getVersionString());
        if (this.getClassifier() != null) {
            buf.append("-").append(this.getClassifier());
        }
        buf.append(".").append(this.getType());
        return buf.toString();
    }

    @Override
    public String getRepoPath() {
        StringBuilder buf = new StringBuilder(this.getGroupIdNameVersionRepoPath());
        buf.append("/").append(this.getFileName());
        return buf.toString();
    }

    @Override
    public String getGroupIdNameVersionRepoPath() {
        StringBuilder buf = new StringBuilder(this.getGroupIdNameRepoPath());
        buf.append("/").append(this.getVersionString());
        return buf.toString();
    }

    @Override
    public String getGroupIdNameRepoPath() {
        StringBuilder buf = new StringBuilder(this.getGroupIdRepoPath());
        buf.append("/").append(this.getName());
        return buf.toString();
    }

    @Override
    public String getGroupIdRepoPath() {
        return this.getGroup().replace(".", "/");
    }

    @Override
    public GroupNameVersionImpl getGroupNameVersionCopy() {
        return new GroupNameVersionImpl(this.getGroup(), this.getName(), this.getVersion(), this.getType());
    }

    @Override
    public String getCoordinateString() {
        String coordinate = "";
        coordinate = coordinate + this.getGroup();
        coordinate = coordinate + ":" + this.getName();
        coordinate = coordinate + ":" + this.getVersion();
        coordinate = coordinate + ":" + this.getType();
        String classifier = this.getClassifier();
        if (!StringUtil.isNullOrEmpty((String)classifier, (boolean)true)) {
            coordinate = coordinate + ":" + classifier;
        }
        return coordinate;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("groupId[").append(this.getGroup()).append("]");
        buf.append(" artifactId[").append(this.getName()).append("]");
        buf.append(" version[").append(this.getVersionString()).append("]");
        buf.append(" type[").append(this.getType()).append("]");
        String classifier = this.getClassifier();
        if (!StringUtil.isNullOrEmpty((String)classifier, (boolean)true)) {
            buf.append(" classifier[").append(classifier).append("]");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !GroupNameVersionImpl.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        GroupNameVersionImpl artifact = (GroupNameVersionImpl)o;
        if (this._group != null ? !this._group.equals(artifact._group) : artifact._group != null) {
            return false;
        }
        if (this._name != null ? !this._name.equals(artifact._name) : artifact._name != null) {
            return false;
        }
        if (this._version != null ? !this._version.equals(artifact._version) : artifact._version != null) {
            return false;
        }
        if (this._type != null ? !this._type.equals(artifact._type) : artifact._type != null) {
            return false;
        }
        return !(this._classifier != null ? !this._classifier.equals(artifact._classifier) : artifact._classifier != null);
    }

    @Override
    public boolean equalsBase(Object o) {
        return this.equalsBase(o, false);
    }

    @Override
    public boolean equalsBase(Object o, boolean ignoreVersion) {
        if (this == o) {
            return true;
        }
        if (o == null || !GroupNameVersionImpl.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        GroupNameVersionImpl artifact = (GroupNameVersionImpl)o;
        if (this._group != null ? !this._group.equals(artifact._group) : artifact._group != null) {
            return false;
        }
        if (this._name != null ? !this._name.equals(artifact._name) : artifact._name != null) {
            return false;
        }
        if (!ignoreVersion) {
            Version thisVersion = this.getVersion();
            Version thatVersion = artifact.getVersion();
            if (thisVersion != null ? !thisVersion.equalsBase(thatVersion) : thatVersion != null) {
                return false;
            }
        }
        if (this._type != null ? !this._type.equals(artifact._type) : artifact._type != null) {
            return false;
        }
        return !(this._classifier != null ? !this._classifier.equals(artifact._classifier) : artifact._classifier != null);
    }

    public int hashCode() {
        int result = this._group != null ? this._group.hashCode() : 0;
        result = 31 * result + (this._name != null ? this._name.hashCode() : 0);
        result = 31 * result + (this._version != null ? this._version.hashCode() : 0);
        result = 31 * result + (this._type != null ? this._type.hashCode() : 0);
        result = 31 * result + (this._classifier != null ? this._classifier.hashCode() : 0);
        return result;
    }
}

