/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.mgmt.impl;

import com.oracle.cie.dependency.mgmt.DependencyFileHandler;
import com.oracle.cie.dependency.mgmt.DependencyFileHandlerCallBack;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDependencyFileHandler
implements DependencyFileHandler {
    private static final Logger _log = Logger.getLogger(AbstractDependencyFileHandler.class.getName());

    @Override
    public Module readDependenciesFile(InputStream is) throws IOException, DependencyManagementException {
        return this.readDependenciesFile(is, null);
    }

    @Override
    public Module readDependenciesFile(File file) throws IOException, DependencyManagementException {
        return this.readDependenciesFile(file, null);
    }

    @Override
    public Module readDependenciesFile(File file, DependencyFileHandlerCallBack callBack) throws IOException, DependencyManagementException {
        if (file == null) {
            throw new DependencyManagementException("The file provided was null.");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Module module = this.readDependenciesFile(is, callBack);
            return module;
        }
        catch (DependencyManagementException e) {
            _log.log(Level.SEVERE, "Failed to read dependency file " + file, e);
            throw e;
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "Failed to read dependency file " + file, e);
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Module readDependenciesFile(URL url) throws IOException, DependencyManagementException {
        return this.readDependenciesFile(url, null);
    }

    @Override
    public Module readDependenciesFile(URL url, DependencyFileHandlerCallBack callBack) throws IOException, DependencyManagementException {
        if (url == null) {
            throw new DependencyManagementException("The URL provided was null.");
        }
        InputStream is = null;
        try {
            is = url.openStream();
            Module module = this.readDependenciesFile(is, callBack);
            return module;
        }
        catch (DependencyManagementException e) {
            _log.log(Level.SEVERE, "Failed to read dependency url " + url, e);
            throw e;
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "Failed to read dependency url " + url, e);
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void writeDependenciesFile(Module module, File file) throws IOException, DependencyManagementException {
        if (file == null) {
            throw new DependencyManagementException("The file provided was null.");
        }
        OutputStream os = null;
        try {
            File parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            os = new FileOutputStream(file);
            this.writeDependenciesFile(module, os);
        }
        catch (DependencyManagementException e) {
            _log.log(Level.SEVERE, "Failed to write dependency file " + file, e);
            throw e;
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "Failed to write dependency file " + file, e);
            throw e;
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                }
                catch (IOException iOException) {}
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

