/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.engineeredsystem;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import model.bundle_xml.Subpatch;
import model.bundle_xml.SystemPatchBundleXML;
import model.patchmodel.PatchingTool;
import oracle.osysmodel.engineeredsystem.EngineeredSystemPatchValidatorAndGenerator;
import oracle.osysmodel.engineeredsystem.HashComputeFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeAutomationXml
extends HashComputeFunction {
    @Override
    protected List<String> fileList(String patchLocation, SystemPatchBundleXML bundleXml) {
        ArrayList<String> metaList = new ArrayList<String>();
        for (Subpatch subPatch : bundleXml.getSubpatches()) {
            if (subPatch.getPatchingTool() != PatchingTool.OPATCH) continue;
            String subPatchLoc = subPatch.getLocation();
            String subPatchAbsLoc = patchLocation + File.separator + subPatchLoc;
            if (EngineeredSystemPatchValidatorAndGenerator.IsSubPatchCompositePatch(subPatchAbsLoc)) {
                File compositePatchDir = new File(subPatchAbsLoc);
                if (!compositePatchDir.exists()) continue;
                for (File sp : compositePatchDir.listFiles()) {
                    if (!sp.isDirectory()) continue;
                    metaList.add(new File(sp.getAbsolutePath() + File.separator + EngineeredSystemPatchValidatorAndGenerator.ACTIONS_XML).getAbsolutePath());
                    metaList.add(new File(sp.getAbsolutePath() + File.separator + EngineeredSystemPatchValidatorAndGenerator.INVENTORY_XML).getAbsolutePath());
                }
                continue;
            }
            metaList.add(new File(patchLocation, subPatchLoc + File.separator + EngineeredSystemPatchValidatorAndGenerator.ACTIONS_XML).getAbsolutePath());
            metaList.add(new File(patchLocation, subPatchLoc + File.separator + EngineeredSystemPatchValidatorAndGenerator.INVENTORY_XML).getAbsolutePath());
        }
        metaList.add(new File(patchLocation, "automation" + File.separator + "apply_automation.xml").getAbsolutePath());
        metaList.add(new File(patchLocation, "automation" + File.separator + "rollback_automation.xml").getAbsolutePath());
        return metaList;
    }

    @Override
    protected String getHashFunction() {
        return "sha1";
    }
}

