/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.logging;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.Chmod;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.ini.DefaultOraparamIni;
import com.oracle.cie.nextgen.common.logging.LoggingException;
import com.oracle.cie.nextgen.common.logging.OUILogManager;
import com.oracle.cie.nextgen.common.utils.Bootstrap;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OUILogManagerImpl
implements OUILogManager {
    private static Logger _logger = Logger.getLogger(OUILogManagerImpl.class.getName());
    private static final String DEFAULT_PREFIX = "nextgen";
    private static final String LOG_EXTENSION = ".log";
    private static final String LOCKFILE_EXTENSION = ".lck";
    private static final String PERM_LOG_PROPERTIES = "permLog.properties";
    private static final String[] NEXTGEN_LOG_ROOTS = new String[]{"com.oracle", "com.bea", "oracle.sysman", "oracle.cluster", "oracle.ops", "oracle.xml", "oracle.i18n", "oracle.glcm"};
    private static OUILogManagerImpl _instance = null;
    private Level _level;
    private String _logDir;
    private String _timestamp;
    private String _scratchPath;
    private String _destination;
    private String _prefix;
    private File _permanentLogDirBase;

    protected OUILogManagerImpl() throws LoggingException {
        try {
            this._scratchPath = Bootstrap.initScratchLoc();
        }
        catch (IOException ioe) {
            throw new LoggingException(ioe.getLocalizedMessage());
        }
        this._logDir = System.getProperty("oracle.installer.logPath", this._scratchPath);
        if (!new File(this._logDir).isAbsolute() || OUILogManagerImpl.createDir(this._logDir) == null) {
            throw new LoggingException(NLS.getMsg("OUILogManagerImpl.invalidLogDir", this._logDir));
        }
        this._level = this.calculateLogLevel();
        this._timestamp = UtilityOps.getSessionTimeStamp();
        this._prefix = System.getProperty("oracle.installer.logPrefix");
        if (StringUtil.isNullOrEmpty((String)this._prefix)) {
            this._prefix = System.getProperty("oracle.installer.operation", DEFAULT_PREFIX);
        }
    }

    protected static synchronized OUILogManagerImpl getInstance() throws LoggingException {
        if (_instance == null) {
            _instance = new OUILogManagerImpl();
        }
        return _instance;
    }

    @Override
    public void setupLogging() {
        this.setupLogging(false, null, null, null);
    }

    @Override
    public void setupLogging(String logPrefix) {
        this.setupLogging(false, logPrefix, null, null);
    }

    @Override
    public synchronized void setupLogging(boolean exclusive, String logPrefix, String logLevel, String logDir) {
        if (this._destination != null) {
            return;
        }
        if (!StringUtil.isNullOrEmpty((String)logLevel)) {
            this._level = this.calculateLogLevel(logLevel);
        }
        if (!StringUtil.isNullOrEmpty((String)logPrefix)) {
            this._prefix = logPrefix;
        }
        if (!StringUtil.isNullOrEmpty((String)logDir)) {
            this._logDir = logDir;
        }
        this._destination = this._logDir + File.separator + OUILogManagerImpl.deriveSimpleLogName(this._prefix, this._timestamp);
        if (!LogFactory.getFactory().setupLogging(this._destination, this._level.toString(), exclusive, new String[0])) {
            _logger.finer("setupLogging was previously invoked, ignoring destination " + this._destination);
        }
    }

    @Override
    public synchronized void implicitSetupLogging() {
        if (this._destination != null) {
            return;
        }
        this._destination = this._logDir + File.separator + OUILogManagerImpl.deriveSimpleLogName(this._prefix, this._timestamp);
        String[] logRoots = this.getNextGenLogRoots();
        try {
            if (!LogFactory.getFactory().setupLogging(this._destination, this._level.toString(), false, logRoots)) {
                _logger.finer("setupLogging was previously invoked, ignoring destination " + this._destination);
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            t.printStackTrace();
        }
    }

    @Override
    public synchronized void setupLogging(String logLevel, String destination) throws LoggingException {
        if (this._destination != null) {
            _logger.warning("setupLogging was previously invoked, ignoring destination " + destination);
            return;
        }
        if (StringUtil.isNullOrEmpty((String)destination)) {
            throw new LoggingException(NLS.getMsg("OUILogManagerImpl.nullDestination", new String[0]));
        }
        File f = new File(destination);
        if (!f.isAbsolute() || f.isDirectory() || f.exists() && !f.canWrite()) {
            throw new LoggingException(NLS.getMsg("OUILogManagerImpl.invalidDestination", destination));
        }
        String logDir = f.getParent();
        if (OUILogManagerImpl.createDir(logDir) == null) {
            throw new LoggingException(NLS.getMsg("OUILogManagerImpl.invalidLogDir", logDir));
        }
        Level level = this.calculateLogLevel(logLevel);
        String[] logRoots = this.getNextGenLogRoots();
        try {
            if (!LogFactory.getFactory().setupLogging(destination, level.toString(), false, logRoots)) {
                _logger.finer("setupLogging was previously invoked, ignoring destination " + destination);
            } else {
                this._level = level;
                this._destination = destination;
                new File(this._logDir).deleteOnExit();
                this._logDir = logDir;
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            throw new LoggingException(t);
        }
    }

    @Override
    public Level getRootLoggersLevel() {
        return LogFactory.getFactory().getRootLevel();
    }

    @Override
    public void setRootLoggersLevel(Level level) {
        LogFactory.getFactory().changeGlobalLogLevel(level);
    }

    @Override
    public void populatePermLogProperties(String key, String val) {
        Properties p = new Properties();
        p.put(key, val);
        this.populatePermLogProperties(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void populatePermLogProperties(Properties props) {
        Properties newProps;
        _logger.finer("populatePermLogProperties");
        File f = new File(this._scratchPath, PERM_LOG_PROPERTIES);
        if (f.exists()) {
            newProps = this.getPermLogProperties();
            newProps.putAll((Map<?, ?>)props);
        } else {
            newProps = props;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
            newProps.store(os, null);
        }
        catch (IOException ioe) {
            _logger.finer("Caught exception " + ioe + " trying to populate " + f.getPath());
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getPermLogProperties() {
        Properties props = new Properties();
        File f = new File(this._scratchPath, PERM_LOG_PROPERTIES);
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            props.load(is);
        }
        catch (FileNotFoundException fnfe) {
            _logger.finer("File not found: " + f.getPath());
        }
        catch (IOException ioe) {
            _logger.finer("Caught exception " + ioe + " trying to load logging properties from " + f.getPath());
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception fnfe) {}
            }
        }
        return props;
    }

    @Override
    public String getLogPrefix() {
        return this._prefix;
    }

    @Override
    public File getLogPath(boolean returnPermanent) {
        File result = null;
        if (this._destination == null) {
            _logger.finer("Unable to determine log file: setupLogging has not been called");
        } else if (returnPermanent) {
            File logDir = this.getLogDir(true);
            if (logDir == null) {
                _logger.finer("Unable to determine permanent log file because permanent directory is not yet known");
            } else {
                result = new File(logDir, new File(this._destination).getName());
            }
        } else {
            result = new File(this._destination);
        }
        return result;
    }

    private void setPermanentLogDirBase(File base) {
        this._permanentLogDirBase = base;
    }

    private File getPermanentLogDirBase() {
        return this._permanentLogDirBase;
    }

    @Override
    public File getLogDir(boolean returnPermanent) {
        return this.getLogDir(returnPermanent, null);
    }

    public File getLogDir(boolean returnPermanent, String logLocationPropertyDefaultValue) {
        File result = null;
        if (returnPermanent) {
            String logLocationProp = DefaultOraparamIni.getLogLocation(logLocationPropertyDefaultValue);
            Properties props = this.getPermLogProperties();
            String val = props.getProperty(logLocationProp);
            if (StringUtil.isNullOrEmpty((String)val)) {
                _logger.finer("Value of property " + logLocationProp + " not defined in permLog.properties");
            } else if (logLocationProp.equals("CENTRAL_INVENTORY")) {
                this.setPermanentLogDirBase(new File(val));
                result = new File(val, "logs");
            } else if (logLocationProp.equals("ORACLE_HOME")) {
                this.setPermanentLogDirBase(new File(val));
                result = new File(val, LOG_DIR_ORACLE_HOME);
            } else {
                _logger.finer("Unexpected value of LOG_LOCATION property: " + logLocationProp);
            }
        } else {
            result = new File(this._logDir);
        }
        return result;
    }

    @Override
    public void copyToPermanentLocation() throws LoggingException {
        this.copyToPermanentLocation(null);
    }

    @Override
    public void copyToPermanentLocation(String logLocationPropertyDefaultValue) throws LoggingException {
        File temporaryLogDir = this.getLogDir(false);
        File permanentLogDir = this.getLogDir(true, logLocationPropertyDefaultValue);
        File permanentLogDirBase = this.getPermanentLogDirBase();
        if (temporaryLogDir == null) {
            throw new LoggingException(NLS.getMsg("OUILogManagerImpl.nullTemporaryLogDir", new String[0]));
        }
        if (permanentLogDir == null) {
            throw new LoggingException(NLS.getMsg("OUILogManagerImpl.nullPermanentLogDir", new String[0]));
        }
        if (permanentLogDirBase == null) {
            throw new LoggingException(NLS.getMsg("OUILogManagerImpl.nullPermanentLogDirBase", new String[0]));
        }
        if (!permanentLogDirBase.exists() || !permanentLogDirBase.isDirectory()) {
            throw new LoggingException(NLS.getMsg("OUILogManagerImpl.invalidPermanentLogDirBase", permanentLogDirBase.getAbsolutePath()));
        }
        if (!temporaryLogDir.equals(permanentLogDir)) {
            File[] toBeCopied = temporaryLogDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f != null && f.isFile() && f.getName().indexOf(OUILogManagerImpl.this._timestamp) != -1 && !f.getName().endsWith(OUILogManagerImpl.LOCKFILE_EXTENSION);
                }
            });
            File toDir = OUILogManagerImpl.createDir(permanentLogDir.getAbsolutePath());
            if (toDir == null) {
                throw new LoggingException(NLS.getMsg("OUILogManagerImpl.invalidPermanentLogDir", permanentLogDir.getAbsolutePath()));
            }
            try {
                for (File from : toBeCopied) {
                    String fromName = from.getName();
                    int suffix = 0;
                    File toPath = new File(toDir, fromName);
                    while (toPath.exists()) {
                        toPath = new File(toDir, fromName + "." + Integer.toString(++suffix));
                    }
                    FileCopy.copy((File)from, (File)toPath);
                    if (ComdevHelper.isWindows()) continue;
                    Chmod.chmod((String)toPath.getAbsolutePath(), (String)"0640", (boolean)false);
                }
            }
            catch (IOException ioe) {
                throw new LoggingException(NLS.getMsg("OUILogManagerImpl.copyFailed", ioe.getLocalizedMessage()));
            }
        } else {
            _logger.fine("The temporary and permanent log directories are identical, so logs are not copied");
        }
    }

    private static File createDir(String dirName) {
        if (!StringUtil.isNullOrEmpty((String)dirName)) {
            try {
                File f = new File(dirName);
                if (f.isDirectory() && f.canWrite()) {
                    return f;
                }
                if (!f.exists() && f.mkdirs() && f.canWrite()) {
                    return f;
                }
            }
            catch (Exception e) {
                _logger.finer("Unable to create directory " + dirName + ": " + e.getMessage());
            }
        }
        _logger.finer("Creating directory failed: " + dirName);
        return null;
    }

    public Level calculateLogLevel() {
        String logLevel = System.getProperty("oracle.installer.logLevel");
        return this.calculateLogLevel(logLevel);
    }

    public Level calculateLogLevel(String logLevel) {
        return this.calculateLogLevel(Boolean.getBoolean("oracle.installer.debug"), logLevel);
    }

    public Level calculateLogLevel(boolean debug, String logLevel) {
        Level result;
        if (debug) {
            result = Level.FINEST;
        } else if (StringUtil.isNullOrEmpty((String)logLevel)) {
            result = Level.INFO;
        } else {
            try {
                result = Level.parse(logLevel.trim().toUpperCase());
            }
            catch (Exception e) {
                result = Level.INFO;
            }
        }
        return result;
    }

    private static String deriveSimpleLogName(String logPrefix, String timestamp) {
        if (logPrefix == null) {
            logPrefix = DEFAULT_PREFIX;
        }
        if (timestamp == null) {
            timestamp = "";
        }
        return logPrefix + timestamp + LOG_EXTENSION;
    }

    @Override
    public String[] getNextGenLogRoots() {
        String r = System.getProperty("oracle.installer.nextgenLogRoots");
        return StringUtil.isNullOrEmpty((String)r) ? NEXTGEN_LOG_ROOTS : r.trim().split("\\s*,\\s*");
    }
}

