/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.inputs.apis.Option;
import com.oracle.cie.nextgen.common.inputs.apis.Options;
import com.oracle.cie.nextgen.common.inputs.enums.DataType;
import com.oracle.cie.nextgen.common.inputs.enums.OperationModeType;
import com.oracle.cie.nextgen.common.inputs.helpers.InputsUtil;
import com.oracle.cie.nextgen.common.inputs.impl.InputHandlerException;
import com.oracle.cie.nextgen.common.inputs.impl.OUIInputs;
import com.oracle.cie.nextgen.common.inputs.parser.OptionsParser;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.xmlns.oui.options.ContextEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OUIOptions
extends OUIInputs
implements Options {
    private Map<String, Map<String, Option>> _ouiOptions;
    private List<String> _unknownInputs;
    private String operationMode;
    private ContextEnum installContext = ContextEnum.ALL;

    public OUIOptions() {
        OptionsParser.reset();
        try {
            this._unknownInputs = new ArrayList<String>();
            this.isCaseSensitive = OptionsParser.getInstance().isCaseSensitive();
        }
        catch (InputHandlerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void configure(String optionsXml) {
        try {
            if (!StringUtil.isNullOrEmpty((String)optionsXml) && !OptionsParser.isCurrentOptionsFile(optionsXml)) {
                OptionsParser.reset();
                this._unknownInputs = new ArrayList<String>();
                OptionsParser.getInstance().configure(optionsXml);
                this.isCaseSensitive = OptionsParser.getInstance().isCaseSensitive();
            }
        }
        catch (InputHandlerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean processCommandLine(Map<String, String> cmdOptions, boolean ignoreInvalidArgs) throws InputHandlerException {
        try {
            if (cmdOptions == null) {
                cmdOptions = new HashMap<String, String>(0);
            }
            this.ignoreInvalidArgs = ignoreInvalidArgs;
            this.clearError();
            OptionsParser op = OptionsParser.getInstance();
            if (!this.isCaseSensitive) {
                this.addCaseMap(op.getOperationOptions());
            }
            this._passedInputs = new HashSet<String>(cmdOptions.keySet());
            this.setupOperation(op);
            if (!Util.isEmpty(this._invalidDistinctInputs)) {
                this.addErrorMsg(NLS.getMsg("options.mutuvally.exclusive", Util.getString(this._invalidDistinctInputs)));
            } else if (!Util.isEmpty(this._invalidDependentInputs)) {
                for (String key : this._invalidDependentInputs.keySet()) {
                    this.addErrorMsg(NLS.getMsg("options.mutuvally.dependent", key, (String)this._invalidDependentInputs.get(key)));
                }
            } else {
                this._ouiOptions = op.getOptions(this.operationMode);
                this.setToSystemProperties();
                for (String option : cmdOptions.keySet()) {
                    this.setOptionValue(option, cmdOptions.get(option), true);
                }
                this.addInvalidMsg("options.invalid", "options.value.missing", "options.invalid.value");
            }
        }
        catch (Exception e) {
            throw new InputHandlerException(e);
        }
        return Util.isEmpty(this.getErrorMessages());
    }

    private void setToSystemProperties() {
        if (Util.isEmpty(this._ouiOptions)) {
            return;
        }
        for (String prefix : this._ouiOptions.keySet()) {
            Map<String, Option> options = this._ouiOptions.get(prefix);
            for (String option : options.keySet()) {
                Object value;
                if (!this.isCaseSensitive) {
                    this.addCaseMap(option);
                }
                if ((value = options.get(option).getValue()) == null) continue;
                System.setProperty(prefix + option, value.toString());
            }
        }
    }

    private void setupOperation(OptionsParser op) throws InputHandlerException {
        Map<String, Set<String>> map;
        Set<String> operations = InputsUtil.getInterSection(op.getOperationOptions(), this.getDeclaredKeys(this._passedInputs));
        if (this._invalidDistinctInputs == null) {
            this._invalidDistinctInputs = new HashSet();
        }
        if (Util.isEmpty(operations)) {
            this.operationMode = op.getDefaultOperation();
        } else if (operations.size() == 1) {
            Iterator<String> iterator = operations.iterator();
            while (iterator.hasNext()) {
                String string;
                this.operationMode = string = iterator.next();
            }
        } else {
            this._invalidDistinctInputs.addAll(operations);
        }
        this.installContext = op.getContext(this.operationMode);
        Map<String, Set<String>> uniqueGroups = op.getUniqueGroups();
        if (!Util.isEmpty(uniqueGroups)) {
            for (String group : uniqueGroups.keySet()) {
                Set<String> options;
                Set<String> mutuvallyExclusiveOptions = uniqueGroups.get(group);
                if (!this.isCaseSensitive) {
                    this.addCaseMap(mutuvallyExclusiveOptions);
                }
                if (Util.isEmpty(options = InputsUtil.getInterSection(mutuvallyExclusiveOptions, this.getDeclaredKeys(this._passedInputs))) || options.size() <= 1) continue;
                this._invalidDistinctInputs.addAll(options);
            }
        }
        if (!Util.isEmpty(map = op.getDependentGroups())) {
            for (String group : map.keySet()) {
                Set<String> input;
                Set<String> mutuvallyDependentOptions = map.get(group);
                if (!this.isCaseSensitive) {
                    this.addCaseMap(mutuvallyDependentOptions);
                }
                if (Util.isEmpty(input = InputsUtil.getInterSection(mutuvallyDependentOptions, this.getDeclaredKeys(this._passedInputs))) || input.size() == mutuvallyDependentOptions.size()) continue;
                this._invalidDependentInputs.put(Util.getString(input), Util.getString(InputsUtil.getSubtraction(mutuvallyDependentOptions, input)));
            }
        }
    }

    private boolean setOptionValue(String option, String value) {
        return this.setOptionValue(option, value, false);
    }

    private boolean setOptionValue(String option, String value, boolean fromCommandLine) {
        Option opt = this.getOption(option);
        if (opt != null) {
            if (value == null) {
                if (DataType.BOOLEAN.equals((Object)opt.getDataType())) {
                    opt.setValue(Boolean.TRUE);
                    System.setProperty(opt.getJavaSystemPropertyName(), Boolean.TRUE.toString());
                    return true;
                }
                this._valueMissing.add(option);
            } else if (DataType.BOOLEAN.equals((Object)opt.getDataType()) && fromCommandLine) {
                this._invalidValues.add(option);
            } else {
                try {
                    opt.setValue(InputsUtil.getValueObject(value, opt.getDataType()));
                    if (!opt.validate()) {
                        this.addErrorMsg(opt.getErrorMessage());
                    }
                    System.setProperty(opt.getJavaSystemPropertyName(), value);
                    return true;
                }
                catch (Exception e) {
                    this._invalidValues.add(option);
                }
            }
        } else {
            this._invalidInputs.add(option);
            this._unknownInputs.add(option + "=" + value);
        }
        return false;
    }

    @Override
    public Map<String, Option> getValidOptions() {
        if (!Util.isEmpty(this._ouiOptions)) {
            HashMap<String, Option> options = new HashMap<String, Option>();
            for (String type : this._ouiOptions.keySet()) {
                options.putAll(this._ouiOptions.get(type));
            }
            return options;
        }
        return new HashMap<String, Option>(0);
    }

    @Override
    public Map<String, String> getHelpDetails() {
        if (Util.isEmpty(this._ouiOptions)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String prefix : this._ouiOptions.keySet()) {
            Map<String, Option> options = this._ouiOptions.get(prefix);
            for (Map.Entry<String, Option> option : options.entrySet()) {
                String help = option.getValue().getHelp();
                if (Util.isNullOrBlank(help, true)) continue;
                map.put(option.getKey(), help);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public boolean isHelpRequested() {
        return this._passedInputs != null && this.getDeclaredKeys(this._passedInputs).contains("help");
    }

    @Override
    public String getHelpOption() {
        return "help";
    }

    @Override
    public Option getOption(String option) {
        if (Util.isEmpty(this._ouiOptions)) {
            return null;
        }
        for (String prefix : this._ouiOptions.keySet()) {
            String key = InputsUtil.getOptionKey(option);
            if (!this.isCaseSensitive) {
                key = this.getDeclaredKey(key);
            }
            if (!this._ouiOptions.get(prefix).containsKey(key)) continue;
            return this._ouiOptions.get(prefix).get(key);
        }
        return null;
    }

    @Override
    public boolean setOption(String optionName, String value) {
        this.clearError();
        if (this._passedInputs == null) {
            this._passedInputs = new HashSet();
        }
        if (this.setOptionValue(InputsUtil.getOptionKey(optionName), value)) {
            this._passedInputs.add(optionName);
            return true;
        }
        this.addInvalidMsg("options.invalid", "options.value.missing", "options.invalid.value");
        return false;
    }

    @Override
    public boolean setOption(String optionName) {
        return this.setOption(optionName, TRUE);
    }

    @Override
    public boolean isPostInstallOperation() {
        return ContextEnum.POST_INSTALL.equals((Object)this.installContext);
    }

    @Override
    public boolean isOptionKey(String option) {
        if (Util.isEmpty(this._ouiOptions)) {
            return false;
        }
        return this._ouiOptions.containsKey(InputsUtil.getOptionPrefix(option));
    }

    @Override
    public OperationModeType getOperationModeType() {
        return OperationModeType.getEnum(this.operationMode);
    }

    @Override
    public String getOptionPrefix() {
        return "oracle.installer.";
    }

    public String getSRVMPrefix() {
        return "oracle.srvm.";
    }

    @Override
    public ContextEnum getInstallContext() {
        return this.installContext;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public List<String> getUnknownInputs() {
        return this._unknownInputs;
    }
}

