/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.iniMerger;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.nextgen.common.ini.IniFile;
import com.oracle.cie.nextgen.common.ini.IniParsingException;
import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.common.iniMerger.OraparamIniConflictResolver;
import com.oracle.cie.nextgen.common.utils.Bootstrap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class OraparamIniMerger {
    private static final Logger _log = Logger.getLogger(OraparamIniMerger.class.getName());
    private List<SimpleOraparamIni> _iniFiles;
    private OraparamIniConflictResolver _resolver;
    private String _mergedIniFileLocation;
    public static final String DEFAULT_MERGED_INI_FILE_NAME = "Complete_Oraparam.ini";
    private HashMap<String, Set<String>> _oracleSection = new HashMap();
    private HashMap<String, Set<String>> _genericPrereqsSection = new HashMap();
    private HashMap<String, Set<String>> _unresolvedOracleSection = new HashMap();
    private HashMap<String, Set<String>> _unresolvedGenericPrereqsSection = new HashMap();

    public OraparamIniMerger(String iniHome, List<SimpleOraparamIni> iniFiles, String mergedIniFileLocation) {
        File[] files;
        if (StringUtil.isNullOrEmpty((String)iniHome)) {
            String msg = "ini home is null or empty string";
            _log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        File f = new File(iniHome);
        if (!f.exists() || !f.isDirectory()) {
            String msg = "ini home does not exist: " + iniHome;
            _log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (iniFiles == null) {
            iniFiles = new ArrayList<SimpleOraparamIni>(4);
        }
        if (iniFiles.isEmpty() && (files = f.listFiles()) != null && files.length > 0) {
            for (File file : files) {
                if (DEFAULT_MERGED_INI_FILE_NAME.equals(file.getName()) || !file.canRead() || !file.isFile() || !file.exists()) continue;
                try {
                    iniFiles.add(new SimpleOraparamIni(file.getAbsolutePath()));
                }
                catch (IOException e) {
                    _log.warning(e.getMessage());
                }
            }
        }
        if (iniFiles.isEmpty()) {
            String msg = "list of ini files to merge is empty; ini home: " + iniHome;
            _log.warning(msg);
        }
        this._iniFiles = iniFiles;
        if (mergedIniFileLocation == null) {
            String mergedIniFileDir = iniHome;
            try {
                mergedIniFileDir = Bootstrap.initScratchLoc();
            }
            catch (Exception exception) {
                // empty catch block
            }
            mergedIniFileLocation = mergedIniFileDir + File.separator + DEFAULT_MERGED_INI_FILE_NAME;
        }
        if ((f = new File(mergedIniFileLocation)).exists()) {
            f.delete();
        }
        this._mergedIniFileLocation = mergedIniFileLocation;
        this._resolver = new OraparamIniConflictResolver();
    }

    public OraparamIniMerger(String iniHome, List<SimpleOraparamIni> iniFiles) {
        this(iniHome, iniFiles, null);
    }

    public OraparamIniMerger(String iniHome) {
        this(iniHome, null, null);
    }

    public String getFileLocation() {
        return this._mergedIniFileLocation;
    }

    public IniFile merge() {
        for (SimpleOraparamIni iniFile : this._iniFiles) {
            this.mergeSection(iniFile.getSectionMap("Oracle"), "Oracle");
            this.mergeSection(iniFile.getSectionMap("Generic Prereqs"), "Generic Prereqs");
        }
        this._resolver.resolve(this._oracleSection, "Oracle");
        this._unresolvedOracleSection = this._resolver.getUnresolvedParams();
        this._resolver.resolve(this._genericPrereqsSection, "Generic Prereqs");
        this._unresolvedGenericPrereqsSection = this._resolver.getUnresolvedParams();
        IniFile mergedIni = null;
        try {
            mergedIni = this.createMergedFile();
            mergedIni.writeFileTo(this._mergedIniFileLocation);
        }
        catch (IniParsingException e) {
            _log.throwing(OraparamIniMerger.class.getName(), "merge", e);
        }
        catch (IOException e) {
            _log.throwing(OraparamIniMerger.class.getName(), "merge", e);
        }
        return mergedIni;
    }

    private IniFile createMergedFile() throws IniParsingException {
        String line;
        String key;
        IniFile ini = new IniFile(this._mergedIniFileLocation);
        for (Map.Entry<String, Set<String>> entry : this._oracleSection.entrySet()) {
            key = entry.getKey();
            line = entry.getValue().toString();
            ini.addPair("Oracle", key, line.substring(1, line.length() - 1));
        }
        for (Map.Entry<String, Set<String>> entry : this._unresolvedOracleSection.entrySet()) {
            key = entry.getKey();
            line = entry.getValue().toString().replaceAll(", ", ",");
            ini.addPair("Oracle", "#" + key, line.substring(1, line.length() - 1));
        }
        for (Map.Entry<String, Set<String>> entry : this._genericPrereqsSection.entrySet()) {
            key = entry.getKey();
            line = entry.getValue().toString();
            ini.addPair("Generic Prereqs", key, line.substring(1, line.length() - 1));
        }
        for (Map.Entry<String, Set<String>> entry : this._unresolvedGenericPrereqsSection.entrySet()) {
            key = entry.getKey();
            line = entry.getValue().toString().replaceAll(", ", ",");
            ini.addPair("Generic Prereqs", "#" + key, line.substring(1, line.length() - 1));
        }
        return ini;
    }

    private void mergeSection(HashMap<String, String> sectionMap, String section) {
        Iterator<String> keyIterator = sectionMap.keySet().iterator();
        if (section.equals("Oracle")) {
            while (keyIterator.hasNext()) {
                Set<Object> values;
                String key = keyIterator.next();
                if (!this._oracleSection.containsKey(key)) {
                    values = new LinkedHashSet<String>();
                    values.add(sectionMap.get(key));
                    this._oracleSection.put(key, values);
                    continue;
                }
                values = this._oracleSection.get(key);
                values.add(sectionMap.get(key));
            }
        } else if (section.equals("Generic Prereqs")) {
            while (keyIterator.hasNext()) {
                Set<Object> values;
                String key = keyIterator.next();
                if (!this._genericPrereqsSection.containsKey(key)) {
                    values = new LinkedHashSet<String>();
                    values.add(sectionMap.get(key));
                    this._genericPrereqsSection.put(key, values);
                    continue;
                }
                values = this._genericPrereqsSection.get(key);
                values.add(sectionMap.get(key));
            }
        } else {
            _log.warning("This section is not being processed by the merger and it will not be added to the merged file: " + section);
        }
    }
}

