/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import com.oracle.cie.gdr.nio.CompatibleNioServiceProxy;
import com.oracle.cie.gdr.nio.FileSystemType;
import com.oracle.cie.gdr.nio.NioServiceProxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NioHelper {
    private static final Logger _log = Logger.getLogger(NioHelper.class.getName());
    private static NioServiceProxy _instance;

    public static NioServiceProxy getInstance() {
        if (_instance == null) {
            try {
                _instance = (NioServiceProxy)NioHelper.class.getClassLoader().loadClass("com.oracle.cie.gdr.nio.CommonNioServiceProxy").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Failed to load common NIO service proxy impl.", e);
                }
                _log.warning("Failed to load common NIO service proxy impl, falling back to backward compatible impl.");
                _instance = new CompatibleNioServiceProxy();
            }
        }
        return _instance;
    }

    public static void configureDefaultFileSystemHandler(FileSystemType fileSystemType) {
        NioHelper.getInstance().setFileSystemType(fileSystemType);
    }

    public static void resetDefaultFileSystemHandler() {
        NioHelper.getInstance().resetDefaultFileSystemHandler();
    }
}

