/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import com.oracle.cie.gdr.nio.FileSystemType;
import com.oracle.cie.gdr.nio.NioServiceProxy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Map;
import oracle.glcm.common.nio.NioService;
import oracle.glcm.common.nio.NioServiceFactory;

public class CommonNioServiceProxy
implements NioServiceProxy {
    private NioService _nioService;

    public CommonNioServiceProxy() {
        this.resetDefaultFileSystemHandler();
    }

    @Override
    public void resetDefaultFileSystemHandler() {
        this.setFileSystemType(null);
    }

    @Override
    public void setFileSystemType(FileSystemType fileSystemType) {
        this._nioService = NioServiceFactory.getNioService();
        oracle.glcm.common.nio.FileSystemType currentFileSystemType = this._nioService.getFileSystemType();
        if ((currentFileSystemType == null || currentFileSystemType == oracle.glcm.common.nio.FileSystemType.File) && fileSystemType != null && fileSystemType == FileSystemType.Cas) {
            this._nioService = NioServiceFactory.configureDefault((oracle.glcm.common.nio.FileSystemType)oracle.glcm.common.nio.FileSystemType.Cas);
        }
    }

    @Override
    public void newFileSystem(Path fileSystemPath) throws IOException {
        this._nioService.newFileSystem(fileSystemPath);
    }

    @Override
    public void newFileSystem(Path fileSystemPath, Map<String, Object> env) throws IOException {
        this._nioService.newFileSystem(fileSystemPath, env);
    }

    @Override
    public FileSystemType getFileSystemType() {
        oracle.glcm.common.nio.FileSystemType fileSystemType = this._nioService.getFileSystemType();
        if (fileSystemType == oracle.glcm.common.nio.FileSystemType.Cas) {
            return FileSystemType.Cas;
        }
        return null;
    }

    @Override
    public URI getURI(String pathString) throws URISyntaxException {
        return this._nioService.getURI(pathString);
    }

    @Override
    public Path getPath(File file) {
        return this._nioService.getPath(file);
    }

    @Override
    public Path getPath(String first, String ... more) {
        return this._nioService.getPath(first, more);
    }

    @Override
    public Path getPath(URI uri) {
        return this._nioService.getPath(uri);
    }

    @Override
    public FileSystem getFileSystem(Path path) {
        return this._nioService.getFileSystem(path);
    }

    @Override
    public Path getInternalPath(Path path) {
        return this._nioService.getInternalPath(path);
    }

    @Override
    public URL getURL(Path path) throws MalformedURLException {
        return this._nioService.getURL(path);
    }

    @Override
    public long copy(InputStream in, Path target, CopyOption ... options) throws IOException {
        return this._nioService.copy(in, target, options);
    }

    @Override
    public CopyOption getChecksumCopyOption(String checksum) {
        return this._nioService.getChecksumCopyOption(checksum);
    }
}

