/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.DataHandlerSpi;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.services.ClassLoaderService;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.nio.NioClassLoaderService;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.FileLocatorService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DaoHelper<T extends IDataHandlerWrapper> {
    private static final Logger _log = Logger.getLogger(DaoHelper.class.getName());
    private Class<T> _wrapperClass;
    public static final String RESOURCE_CLASSLOADER_KEY = "DaoHelper.resource.class.loader";
    private Map<ResourceBundleCacheKey, ResourceBundle> _resourceBundleCache = new HashMap<ResourceBundleCacheKey, ResourceBundle>();
    public static final String PROD_DIR = "prod";
    public static final String DEV_DIR = "dev";
    public static final String LOOKASIDE_DIR = "look-aside";
    public static final String LOOKASIDE_HOME_PROPERTY = "LOOKASIDE_HOME";
    public static final String LOOKASIDE_DIRS_PROPERTY = "LOOKASIDE_DIRS";
    protected ClassLoader _classLoader;
    public static final String GDR_SCHEMA_MODULE_PREFIX = "com.oracle.cie.xmldh";

    protected DaoHelper(Class<T> wrapperClass) {
        this(wrapperClass, null);
    }

    protected DaoHelper(Class<T> wrapperClass, ClassLoader classLoader) {
        this._wrapperClass = wrapperClass;
        this._classLoader = classLoader != null ? classLoader : DaoHelper.class.getClassLoader();
    }

    public static ClassLoader getConfiguredClassLoader() {
        return DaoHelper.getConfiguredClassLoader((Path)null);
    }

    public static ClassLoader getConfiguredClassLoader(File moduleDir) {
        return DaoHelper.getConfiguredClassLoader(NioHelper.getInstance().getPath(moduleDir));
    }

    public static ClassLoader getConfiguredClassLoader(Path moduleDir) {
        URL latestJar;
        String classLoaderKey;
        block27: {
            if (moduleDir == null || !Files.isDirectory(moduleDir, new LinkOption[0])) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("The modules directory " + moduleDir + " is not an existing directory, falling back to default gdr-schema class loader.");
                }
                moduleDir = null;
                classLoaderKey = "GDR_HELPER_DEFAULT";
            } else {
                classLoaderKey = moduleDir.toAbsolutePath().toString();
            }
            if (NioClassLoaderService.getInstance().hasClassLoader(classLoaderKey)) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Using cached class loader for " + classLoaderKey);
                }
                return NioClassLoaderService.getInstance().getClassLoader(classLoaderKey);
            }
            try {
                Class<?> clazz = Class.forName("com.oracle.cie.gdr.xml.cmn.RefType");
                if (clazz != null) {
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Found gdr-schema on current classpath, using default class loader.");
                    }
                    return NioClassLoaderService.getInstance().getClassLoader(classLoaderKey, null, clazz.getClassLoader());
                }
            }
            catch (ClassNotFoundException clazz) {
                // empty catch block
            }
            latestJar = null;
            try {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Attempting to locate com.oracle.cie.xmldh module under " + moduleDir);
                }
                List<URL> jars = NioClassLoaderService.getInstance().getModuleJars(moduleDir, GDR_SCHEMA_MODULE_PREFIX, DaoHelper.class);
                latestJar = NioClassLoaderService.getInstance().getLatestJar(jars);
                if (latestJar == null) break block27;
                try {
                    Path latestJarPath = NioHelper.getInstance().getPath(latestJar.toURI());
                    if (NioHelper.getInstance().getFileSystem(latestJarPath) != null) {
                        latestJar = NioHelper.getInstance().getURL(latestJarPath);
                    }
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Error getting location URL for " + latestJar, e);
                }
            }
            catch (MalformedURLException e) {
                _log.log(Level.WARNING, "Error getting location URL for " + moduleDir, e);
            }
        }
        if (latestJar == null) {
            Path myLoc = NioClassLoaderService.getInstance().locateClass(DaoHelper.class.getName(), DaoHelper.class.getClassLoader());
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Currently running from " + myLoc);
            }
            if (myLoc != null && !myLoc.getFileName().toString().endsWith(".jar")) {
                while (myLoc != null && !"target".equals(myLoc.getFileName().toString())) {
                    myLoc = myLoc.getParent();
                }
                if (myLoc != null) {
                    moduleDir = myLoc.resolve("schema-classes");
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Using directory " + moduleDir + " for gdr-schema classes.");
                    }
                    try {
                        latestJar = moduleDir.toUri().toURL();
                    }
                    catch (MalformedURLException e) {
                        _log.log(Level.WARNING, "Error getting location URL for " + myLoc, e);
                    }
                }
            }
        }
        if (latestJar != null) {
            ClassLoader classLoader = NioClassLoaderService.getInstance().getCachedClassLoader(latestJar.getPath());
            if (classLoader == null) {
                if (_log.isLoggable(Level.FINE)) {
                    _log.fine("Using latest gdr-schema module " + latestJar + " under " + moduleDir);
                }
                classLoader = NioClassLoaderService.getInstance().getClassLoader(classLoaderKey, new URL[]{latestJar}, DaoHelper.class.getClassLoader());
                NioClassLoaderService.getInstance().setCacheClassLoader(latestJar.getPath(), classLoader);
            }
            return classLoader;
        }
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Unable to locate gdr-schema module, using default class loader.");
        }
        return NioClassLoaderService.getInstance().getClassLoader(classLoaderKey, null, DaoHelper.class.getClassLoader());
    }

    public abstract String getNamespace();

    public abstract String getRootElement();

    public abstract String getPath();

    public DataHandlerSpi getDataHandlerProvider() {
        return DataHandlerSpi.getDataHandlerProvider((ClassLoader)this.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return this._classLoader == null ? DaoHelper.class.getClassLoader() : this._classLoader;
    }

    public IDataHandler parse(File file) throws IOException, DataHandlerException {
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Parsing file " + file);
        }
        if (file == null) {
            throw new NullPointerException("The file specified was null.");
        }
        return this.parse(NioHelper.getInstance().getPath(file));
    }

    public IDataHandler parse(Path path) throws IOException, DataHandlerException {
        IDataHandler iDataHandler;
        block11: {
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Parsing " + path);
            }
            if (path == null) {
                throw new NullPointerException("The path specified was null.");
            }
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException("The path specified did not exist " + path);
            }
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                iDataHandler = this.parse(is);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Failed to parse path " + path, e);
                }
            }
            is.close();
        }
        return iDataHandler;
    }

    public IDataHandler parse(InputStream is) throws IOException, DataHandlerException {
        return this.getDataHandlerProvider().create(this.getNamespace(), this.getRootElement(), is, this.getClassLoader());
    }

    public IDataHandler parse(ReadableByteChannel channel) throws IOException, DataHandlerException {
        return this.parse(Channels.newInputStream(channel));
    }

    public IDataHandler parse(String s) throws DataHandlerException {
        return this.getDataHandlerProvider().create(this.getNamespace(), this.getRootElement(), s, this.getClassLoader());
    }

    public IDataHandler parseJson(File file) throws IOException, DataHandlerException {
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Parsing file " + file);
        }
        if (file == null) {
            throw new NullPointerException("The file specified was null.");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("The file specified did not exist " + file);
        }
        return this.parseJson(NioHelper.getInstance().getPath(file));
    }

    public IDataHandler parseJson(Path path) throws IOException, DataHandlerException {
        IDataHandler iDataHandler;
        block11: {
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Parsing " + path);
            }
            if (path == null) {
                throw new NullPointerException("The path specified was null.");
            }
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException("The path specified did not exist " + path);
            }
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                iDataHandler = this.parseJson(is);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Failed to parse path " + path, e);
                }
            }
            is.close();
        }
        return iDataHandler;
    }

    public IDataHandler parseJson(InputStream is) throws IOException, DataHandlerException {
        return this.getDataHandlerProvider().createFromJson(this.getNamespace(), this.getRootElement(), is, this.getClassLoader());
    }

    public IDataHandler parseJson(ReadableByteChannel channel) throws IOException, DataHandlerException {
        return this.parseJson(Channels.newInputStream(channel));
    }

    public void save(T dao, File file) throws DataHandlerException {
        this.save(dao.getDataHandler(), file);
    }

    public void save(T dao, Path path) throws DataHandlerException {
        this.save(dao.getDataHandler(), path);
    }

    public void save(IDataHandler dataHandler, File file) throws DataHandlerException {
        this.save(dataHandler, NioHelper.getInstance().getPath(file));
    }

    public void save(IDataHandler dataHandler, Path path) throws DataHandlerException {
        if (path == null) {
            throw new DataHandlerException("The path provided was null.");
        }
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                _log.log(Level.WARNING, "Failed to create directory " + parent, e);
                throw new DataHandlerException("Failed to create directory " + parent, (Throwable)e);
            }
        }
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.save(dataHandler, os);
        }
        catch (DataHandlerException | IOException e) {
            _log.log(Level.WARNING, "Failed to save to path " + path, e);
            throw new DataHandlerException("Failed to save to path " + path, e);
        }
    }

    public void save(T dao, OutputStream os) throws DataHandlerException {
        this.save(dao.getDataHandler(), os);
    }

    public void save(T dao, WritableByteChannel channel) throws DataHandlerException {
        this.save(dao.getDataHandler(), channel);
    }

    public void save(IDataHandler dataHandler, OutputStream os) throws DataHandlerException {
        dataHandler.save(os);
    }

    public void save(IDataHandler dataHandler, WritableByteChannel channel) throws DataHandlerException {
        this.save(dataHandler, Channels.newOutputStream(channel));
    }

    public void save(T dao, StringBuffer sb) throws DataHandlerException {
        this.save(dao.getDataHandler(), sb);
    }

    public void save(IDataHandler dataHandler, StringBuffer sb) throws DataHandlerException {
        dataHandler.save(sb);
    }

    public void save(T dao, RandomAccessFile file) throws DataHandlerException, IOException {
        this.save(dao.getDataHandler(), file);
    }

    public void save(T dao, SeekableByteChannel channel) throws DataHandlerException, IOException {
        this.save(dao.getDataHandler(), channel);
    }

    public void save(IDataHandler dataHandler, RandomAccessFile file) throws DataHandlerException, IOException {
        StringBuffer sb = new StringBuffer();
        dataHandler.save(sb);
        file.seek(0L);
        file.write(sb.toString().getBytes());
        file.setLength(sb.length());
    }

    public void save(IDataHandler dataHandler, SeekableByteChannel channel) throws DataHandlerException, IOException {
        StringBuffer sb = new StringBuffer();
        dataHandler.save(sb);
        channel.position(0L);
        ByteBuffer byteBuffer = ByteBuffer.wrap(sb.toString().getBytes());
        int size = channel.write(byteBuffer);
        channel.truncate(size);
    }

    public void saveJson(IDataHandler dataHandler, File file) throws DataHandlerException {
        this.saveJson(dataHandler, NioHelper.getInstance().getPath(file));
    }

    public void saveJson(IDataHandler dataHandler, Path path) throws DataHandlerException {
        if (path == null) {
            throw new DataHandlerException("The path provided was null.");
        }
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DataHandlerException("Failed to create directory " + parent);
            }
        }
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.saveJson(dataHandler, os);
        }
        catch (DataHandlerException | IOException e) {
            throw new DataHandlerException("Failed to save to path " + path, e);
        }
    }

    public void saveJson(T dao, File file) throws DataHandlerException {
        this.saveJson(dao.getDataHandler(), file);
    }

    public void saveJson(T dao, Path path) throws DataHandlerException {
        this.saveJson(dao.getDataHandler(), path);
    }

    public void saveJson(T dao, WritableByteChannel channel) throws DataHandlerException {
        this.saveJson(dao.getDataHandler(), channel);
    }

    public void saveJson(IDataHandler dataHandler, OutputStream os) throws DataHandlerException {
        dataHandler.saveJson(os);
    }

    public void saveJson(IDataHandler dataHandler, WritableByteChannel channel) throws DataHandlerException {
        this.saveJson(dataHandler, Channels.newOutputStream(channel));
    }

    public void saveJson(T dao, OutputStream os) throws DataHandlerException {
        this.saveJson(dao.getDataHandler(), os);
    }

    public T getRootWrapper() {
        return this.getRootWrapper(this.getDataHandlerProvider().create(this.getNamespace(), this.getRootElement(), this.getClassLoader()));
    }

    public T getRootWrapper(File file) throws IOException, DataHandlerException {
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Creating root wrapper from file " + file);
        }
        return this.getRootWrapper(this.parse(file));
    }

    public T getRootWrapper(Path path) throws IOException, DataHandlerException {
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Creating root wrapper from path " + path);
        }
        return this.getRootWrapper(this.parse(path));
    }

    public T getRootWrapper(InputStream is) throws IOException, DataHandlerException {
        return this.getRootWrapper(this.parse(is));
    }

    public T getRootWrapper(ReadableByteChannel channel) throws IOException, DataHandlerException {
        return this.getRootWrapper(this.parse(channel));
    }

    public T getRootWrapper(String s) throws DataHandlerException {
        return this.getRootWrapper(this.parse(s));
    }

    public T getRootWrapper(RandomAccessFile file) throws IOException, DataHandlerException {
        int read;
        if (file == null) {
            IOException ex = new IOException("RandomAccessFile provided was null.");
            _log.throwing(this.getClass().getName(), "getRootWrapper", ex);
            throw ex;
        }
        StringBuilder sb = new StringBuilder();
        file.seek(0L);
        byte[] buf = new byte[1024];
        while ((read = file.read(buf)) != -1) {
            sb.append(new String(buf, 0, read));
        }
        return this.getRootWrapper(this.parse(sb.toString()));
    }

    public T getRootWrapper(SeekableByteChannel channel) throws IOException, DataHandlerException {
        int read;
        if (channel == null) {
            IOException ex = new IOException("SeekableByteChannel provided was null.");
            _log.throwing(this.getClass().getName(), "getRootWrapper", ex);
            throw ex;
        }
        Charset charset = Charset.forName("UTF-8");
        StringBuilder sb = new StringBuilder();
        ByteBuffer buf = ByteBuffer.allocate(1024);
        while ((read = channel.read(buf)) > 0) {
            buf.flip();
            sb.append(charset.decode(buf));
            buf.clear();
        }
        return this.getRootWrapper(this.parse(sb.toString()));
    }

    public T getRootWrapper(IDataHandler dataHandler) {
        try {
            Constructor<T> constructor = this._wrapperClass.getConstructor(IDataHandler.class);
            return (T)((IDataHandlerWrapper)constructor.newInstance(dataHandler));
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error creating wrapper class: " + this._wrapperClass.getName(), e);
            return null;
        }
    }

    public T getRootWrapperFromJson(File file) throws IOException, DataHandlerException {
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Creating root wrapper from file " + file);
        }
        return this.getRootWrapper(this.parseJson(file));
    }

    public T getRootWrapperFromJson(Path path) throws IOException, DataHandlerException {
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Creating root wrapper from path " + path);
        }
        return this.getRootWrapper(this.parseJson(path));
    }

    public T getRootWrapperFromJson(InputStream is) throws IOException, DataHandlerException {
        return this.getRootWrapper(this.parseJson(is));
    }

    public T getRootWrapperFromJson(ReadableByteChannel channel) throws IOException, DataHandlerException {
        return this.getRootWrapper(this.parseJson(channel));
    }

    public Class<T> getRootWrapperClass() {
        return this._wrapperClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(T wrapper) throws DataHandlerException {
        if (wrapper != null) {
            IDataHandler dataHandler = wrapper.getDataHandler();
            if (dataHandler != null) {
                if (dataHandler.validate()) return;
                DataHandlerException ex = new DataHandlerException("Validation failed for " + wrapper);
                _log.throwing(this.getClass().getName(), "validate", ex);
                throw ex;
            }
            DataHandlerException ex = new DataHandlerException("The wrapper specified for validation contained a null data handler.");
            _log.throwing(this.getClass().getName(), "validate", ex);
            throw ex;
        }
        DataHandlerException ex = new DataHandlerException("The wrapper specified for validation was null.");
        _log.throwing(this.getClass().getName(), "validate", ex);
        throw ex;
    }

    public IDataHandler create(String type) {
        return this.create(this.getNamespace(), type);
    }

    public IDataHandler create(String namespace, String type) {
        return this.getDataHandlerProvider().create(namespace, type, this.getClassLoader());
    }

    public ResourceBundle loadResourceBundle(String resourceBundleBaseName) {
        return this.loadResourceBundle(resourceBundleBaseName, (Path)null, null);
    }

    public ResourceBundle loadResourceBundle(String resourceBundleBaseName, Locale locale) {
        return this.loadResourceBundle(resourceBundleBaseName, (Path)null, locale);
    }

    public ResourceBundle loadResourceBundle(String resourceBundleBaseName, File resourceJarFile) {
        return this.loadResourceBundle(resourceBundleBaseName, resourceJarFile, null);
    }

    public ResourceBundle loadResourceBundle(String resourceBundleBaseName, Path resourceJarPath) {
        return this.loadResourceBundle(resourceBundleBaseName, resourceJarPath, null);
    }

    public ResourceBundle loadResourceBundle(String resourceBundleBaseName, File resourceLocation, Locale locale) {
        return this.loadResourceBundle(resourceBundleBaseName, NioHelper.getInstance().getPath(resourceLocation), locale);
    }

    public ResourceBundle loadResourceBundle(String resourceBundleBaseName, Path resourceLocation, Locale locale) {
        ResourceBundle resourceBundle = null;
        if (!StringUtil.isNullOrEmpty((String)resourceBundleBaseName)) {
            ResourceBundleCacheKey key;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if ((resourceBundle = this._resourceBundleCache.get(key = new ResourceBundleCacheKey(resourceBundleBaseName, locale))) == null) {
                URL url = null;
                try {
                    url = resourceLocation != null ? resourceLocation.toUri().toURL() : null;
                }
                catch (Exception e) {
                    _log.log(Level.FINEST, e.getMessage(), e);
                }
                ClassLoader classLoader = ClassLoaderService.getInstance().getClassLoader(RESOURCE_CLASSLOADER_KEY, url);
                ResourceBundle.Control control = new ResourceBundle.Control(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                        ResourceBundle bundle = super.newBundle(baseName, locale, format, loader, reload);
                        if (bundle == null) {
                            String bundleName = this.toBundleName(baseName, locale);
                            if (format.equals("java.properties")) {
                                InputStream stream;
                                final String resourceName = bundleName + ".properties";
                                final ClassLoader classLoader = loader;
                                final boolean reloadFlag = reload;
                                try {
                                    stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                                        @Override
                                        public InputStream run() throws IOException {
                                            InputStream is = null;
                                            if (reloadFlag) {
                                                URLConnection connection;
                                                URL url = classLoader.getResource(resourceName);
                                                if (url != null && (connection = url.openConnection()) != null) {
                                                    connection.setUseCaches(false);
                                                    is = connection.getInputStream();
                                                }
                                            } else {
                                                is = classLoader.getResourceAsStream(resourceName);
                                            }
                                            return is;
                                        }
                                    });
                                }
                                catch (PrivilegedActionException e) {
                                    throw (IOException)e.getException();
                                }
                                if (stream != null) {
                                    try {
                                        bundle = new PropertyResourceBundle(stream);
                                    }
                                    finally {
                                        stream.close();
                                    }
                                }
                            } else {
                                throw new IllegalArgumentException("unknown format: " + format);
                            }
                        }
                        return bundle;
                    }
                };
                try {
                    resourceBundle = ResourceBundle.getBundle(resourceBundleBaseName, locale, classLoader, control);
                }
                catch (MissingResourceException e) {
                    _log.warning(e.getMessage());
                }
                if (resourceBundle != null) {
                    this._resourceBundleCache.put(key, resourceBundle);
                }
            }
        }
        return resourceBundle;
    }

    public void clearResourceBundleCache() {
        block3: {
            this._resourceBundleCache.clear();
            ClassLoader cl = ClassLoaderService.getInstance().getCachedClassLoader(RESOURCE_CLASSLOADER_KEY);
            ClassLoaderService.getInstance().clearCachedClassLoader(RESOURCE_CLASSLOADER_KEY);
            if (cl != null) {
                try {
                    Method m = cl.getClass().getMethod("close", new Class[0]);
                    m.invoke((Object)cl, new Object[0]);
                }
                catch (Exception e) {
                    if (!_log.isLoggable(Level.FINE)) break block3;
                    _log.log(Level.FINE, "Failed to close closing resource class loader : " + e.getMessage());
                }
            }
        }
    }

    public FileLocatorService getFileLocatorService(File metaDataRoot) {
        return this.getFileLocatorService(NioHelper.getInstance().getPath(metaDataRoot));
    }

    public FileLocatorService getFileLocatorService(Path metaDataRoot) {
        FileLocatorService service = FileLocatorService.getFileLocatorService(metaDataRoot.toAbsolutePath().toString());
        if (service.isEmpty()) {
            Path prodDir = metaDataRoot.resolve(PROD_DIR);
            Path devDir = metaDataRoot.resolve(DEV_DIR);
            if (!Files.exists(prodDir, new LinkOption[0]) && !Files.exists(devDir, new LinkOption[0])) {
                _log.fine("Unable to locate \"prod\" or \"dev\" in root dir " + metaDataRoot + ", assuming root is inventory structure.");
                service.addLocation(metaDataRoot);
            } else {
                service.addLocation(prodDir);
                String lookasideSubDirs = System.getProperty(LOOKASIDE_DIRS_PROPERTY);
                if (lookasideSubDirs != null && lookasideSubDirs.trim().length() > 0) {
                    Path lookasideDir = null;
                    String lookaside = System.getProperty(LOOKASIDE_HOME_PROPERTY);
                    if (lookaside == null) {
                        lookasideDir = metaDataRoot.resolve(LOOKASIDE_DIR);
                    } else if (lookaside.trim().length() > 0) {
                        lookasideDir = NioHelper.getInstance().getPath(lookaside, new String[0]);
                    } else {
                        _log.warning("Invalid LOOKASIDE_HOME \"" + lookaside + "\" specified, look-aside will not be used.");
                    }
                    if (lookasideDir != null) {
                        String[] subDirs = lookasideSubDirs.split(",");
                        service.addLocations(lookasideDir, subDirs);
                    }
                }
                service.addLocation(devDir);
            }
        }
        return service;
    }

    class ResourceBundleCacheKey {
        String _baseName;
        Locale _locale;

        public ResourceBundleCacheKey(String baseName, Locale locale) {
            this._baseName = baseName;
            this._locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceBundleCacheKey that = (ResourceBundleCacheKey)o;
            if (this._baseName != null ? !this._baseName.equals(that._baseName) : that._baseName != null) {
                return false;
            }
            return !(this._locale != null ? !this._locale.equals(that._locale) : that._locale != null);
        }

        public int hashCode() {
            int result = this._baseName != null ? this._baseName.hashCode() : 0;
            result = 31 * result + (this._locale != null ? this._locale.hashCode() : 0);
            return result;
        }
    }
}

