/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.wizard.silent.tasks;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.Task;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.PatchActionExecutor;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.PatchPhase;
import com.oracle.glcm.patch.auto.lifecycle.Phase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;

@TaskDescription(name="patch-action")
public class PatchActionTask
extends AbstractSilentTask {
    private String _sessionKey;
    private String _phaseGoal;

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setSessionKey(String sessionKey) {
        this._sessionKey = sessionKey;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setPhaseGoal(String phaseGoal) {
        this._phaseGoal = phaseGoal;
    }

    public void execute() throws TaskExecutionException {
        Goal goal;
        String sessionKey = this._context.substitute(this._namespace, this._sessionKey);
        if (StringUtil.isNullOrEmpty((String)sessionKey, (boolean)true)) {
            throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68123", this._sessionKey));
        }
        Object o = this._context.retrieveObject(this._namespace, (Object)sessionKey);
        if (o == null || !(o instanceof MutablePatchSession)) {
            throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68124", this._sessionKey));
        }
        MutablePatchSession patchSession = (MutablePatchSession)o;
        String phaseGoal = this._context.substitute(this._namespace, this._phaseGoal);
        if (StringUtil.isNullOrEmpty((String)phaseGoal, (boolean)true)) {
            throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68125", this._phaseGoal));
        }
        String[] split = phaseGoal.split(":");
        if (split.length != 2) {
            throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68126", this._phaseGoal));
        }
        Phase phase = Phase.valueOf(split[0].trim());
        PatchPhase patchPhase = phase.getPhaseInstance();
        try {
            goal = patchPhase.getGoal(split[1].trim());
        }
        catch (OPatchAutoException e) {
            throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68127", new Object[]{this._phaseGoal, phase}), (Throwable)e);
        }
        try {
            PatchActionExecutor.execute(patchSession, goal);
        }
        catch (OPatchAutoException e) {
            throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68128", goal), (Throwable)e);
        }
    }

    public void unconfigure() {
        this._sessionKey = null;
        this._phaseGoal = null;
    }
}

