/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class OPatchAutoCheckSumGenerator {
    private static final String SHA_ALGORITHM = "SHA1";

    public static String calculateSHACheckSum(String file) throws NoSuchAlgorithmException, IOException {
        int nread;
        MessageDigest md = MessageDigest.getInstance(SHA_ALGORITHM);
        FileInputStream fis = new FileInputStream(file);
        byte[] dataBytes = new byte[1024];
        while ((nread = fis.read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        byte[] mdbytes = md.digest();
        StringBuilder sb = new StringBuilder("");
        for (byte mdbyte : mdbytes) {
            sb.append(Integer.toString((mdbyte & 0xFF) + 256, 16).substring(1));
        }
        fis.close();
        return sb.toString();
    }
}

