/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggedOutputStream
extends OutputStream {
    private static final Logger _logger = Logger.getLogger(LoggedOutputStream.class.getName());
    private static final char LINE_SEPARATOR_END = '\n';
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private StringBuffer _buffer = new StringBuffer();
    private Level _level = Level.INFO;

    @Override
    public void write(int b) throws IOException {
        String s;
        char ch = (char)b;
        this._buffer.append(ch);
        if (ch == '\n' && (s = this._buffer.toString()).contains(LINE_SEPARATOR)) {
            _logger.log(this._level, s.substring(0, s.length() - LINE_SEPARATOR.length()));
            this._buffer.setLength(0);
        }
    }
}

