/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.utils;

import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectoryCopy {
    public static final Logger _logger = Logger.getLogger(DirectoryCopy.class.getName());

    public static void copy(File from, File to) throws IOException {
        File[] fl;
        if (from == null || !from.isDirectory()) {
            throw new IllegalArgumentException("You must provide a valid directory to copy from.");
        }
        if (to == null || to.exists() && !to.isDirectory()) {
            throw new IllegalArgumentException("You must provide a valid directory to copy to.");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Directory copy: " + from.getPath() + " to " + to.getPath());
        }
        if (!to.exists()) {
            to.mkdirs();
        }
        if ((fl = from.listFiles()) != null) {
            for (int i = 0; i < fl.length; ++i) {
                if (fl[i].isDirectory()) {
                    DirectoryCopy.copy(fl[i], new File(to, fl[i].getName()));
                    continue;
                }
                Path source = Paths.get(OPatchAutoHelper.getFilePath(fl[i]), new String[0]);
                Path target = Paths.get(OPatchAutoHelper.getFilePath(new File(to, fl[i].getName())), new String[0]);
                Files.copy(source, target, StandardCopyOption.COPY_ATTRIBUTES);
            }
        }
    }
}

