/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.topology;

import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Instance;
import com.oracle.glcm.patch.auto.topology.Topology;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TopologyImpl
implements Topology {
    private File _topologyFile;
    private List<Host> _hosts = new ArrayList<Host>();

    @Override
    public File getTopologyFile() {
        return this._topologyFile;
    }

    @Override
    public void setTopologyFile(File topologyFile) {
        this._topologyFile = topologyFile;
    }

    @Override
    public Set<Host> getHosts() {
        return new LinkedHashSet<Host>(this._hosts);
    }

    @Override
    public void setHosts(Set<Host> hosts) {
        if (!this._hosts.isEmpty()) {
            this._hosts.clear();
        }
        if (hosts != null) {
            for (Host host : hosts) {
                this.addHost(host);
            }
        }
    }

    public void addHost(Host host) {
        if (host != null && !this._hosts.contains(host)) {
            this._hosts.add(host);
        }
    }

    @Override
    public Set<Home> getHomes() {
        LinkedHashSet<Home> homes = new LinkedHashSet<Home>();
        Set<Host> hosts = this.getHosts();
        if (hosts != null && !hosts.isEmpty()) {
            for (Host host : hosts) {
                homes.addAll(host.getHomes());
            }
        }
        return homes;
    }

    @Override
    public Set<Instance> getInstances() {
        LinkedHashSet<Instance> instances = new LinkedHashSet<Instance>();
        Set<Host> hosts = this.getHosts();
        if (hosts != null && !hosts.isEmpty()) {
            for (Host host : hosts) {
                instances.addAll(host.getInstances());
            }
        }
        return instances;
    }

    public String toString() {
        String s = OPatchAutoHelper.getLocalizedString("TopologyImpl.topology", new Object[0]);
        if (this.getTopologyFile() != null) {
            s = s + " " + OPatchAutoHelper.getLocalizedString("TopologyImpl.file", new Object[0]) + " " + this.getTopologyFile();
        }
        s = s + " " + OPatchAutoHelper.getLocalizedString("TopologyImpl.hosts", new Object[0]) + " " + this.getHosts();
        return s;
    }
}

