/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.report;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.report.OPatchAutoReporting;
import com.oracle.glcm.patch.auto.report.patches.PatchReporting;
import java.util.HashMap;
import java.util.Map;

public class OPatchAutoReportingManager {
    private Map<String, OPatchAutoReporting> _reportingCache = new HashMap<String, OPatchAutoReporting>();
    private static OPatchAutoReportingManager _manager = null;

    private OPatchAutoReportingManager() {
    }

    public static OPatchAutoReportingManager getInstance() {
        if (_manager == null) {
            _manager = new OPatchAutoReportingManager();
        }
        return _manager;
    }

    public OPatchAutoReporting getReportingHandler(String reportingType) throws OPatchAutoException {
        OPatchAutoReporting reportingHandler = null;
        if (this._reportingCache.containsKey(reportingType)) {
            reportingHandler = this._reportingCache.get(reportingType);
        } else if (reportingType.equalsIgnoreCase("patches")) {
            reportingHandler = new PatchReporting();
            this._reportingCache.put(reportingType, reportingHandler);
        }
        return reportingHandler;
    }

    public void setReportingHandler(String reportingType, OPatchAutoReporting handler) throws OPatchAutoException {
        if (this._reportingCache.containsKey(reportingType)) {
            throw new OPatchAutoException("OPatchAutoReporting handler is already registered for reportingType: " + reportingType, new Object[0]);
        }
        this._reportingCache.put(reportingType, handler);
    }

    public void clear() {
        this._reportingCache.clear();
    }
}

