/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.plan;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementContainer;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementSetCreatorImpl;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementType;
import com.oracle.glcm.patch.auto.plan.PatchPlanTargets;
import com.oracle.glcm.patch.auto.product.ProductSupport;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatchPlanTargetsImpl
implements PatchPlanTargets {
    private static final Logger _logger = Logger.getLogger(PatchPlanTargetsImpl.class.getName());
    private Set<PatchTarget> _patchTargets = new LinkedHashSet<PatchTarget>();
    private Set<PatchTarget> _sortedPatchTargets = new LinkedHashSet<PatchTarget>();
    private Set<String> _types;
    private ProductSupportManager _productSupportManager;
    private boolean _incremental;
    private Boolean _parallel = null;
    private PatchPlanIncrementType _incrementType = PatchPlanIncrementSetCreatorImpl.DefaultPatchPlanIncrementType.target;
    private PatchPlanTargetsIterator<PatchPlanIncrementContainer> _iterator;
    private PatchPlanIncrementContainer _currentItem;
    private boolean _consolidateSharedHomes;

    public PatchPlanTargetsImpl(Set<String> types, ProductSupportManager productSupportManager) {
        this._types = types;
        this._productSupportManager = productSupportManager;
    }

    @Override
    public Set<String> getTypes() {
        return this._types;
    }

    public ProductSupportManager getProductSupportManager() {
        return this._productSupportManager;
    }

    public void setProductSupportManager(ProductSupportManager productSupportManager) {
        this._productSupportManager = productSupportManager;
    }

    @Override
    public boolean isIncremental() {
        return this._incremental;
    }

    @Override
    public void setIncremental(boolean incremental) {
        this._incremental = incremental;
    }

    @Override
    public PatchPlanIncrementType getIncrementType() {
        return this._incrementType;
    }

    @Override
    public void setIncrementType(PatchPlanIncrementType incrementType) {
        this._incrementType = incrementType != null ? incrementType : PatchPlanIncrementSetCreatorImpl.DefaultPatchPlanIncrementType.target;
    }

    @Override
    public boolean isConsolidateSharedHomes() {
        return this._consolidateSharedHomes;
    }

    @Override
    public void setConsolidateSharedHomes(boolean consolidateSharedHomes) {
        this._consolidateSharedHomes = consolidateSharedHomes;
    }

    @Override
    public Set<PatchPlanIncrementContainer> getIncrementalSet() throws OPatchAutoException {
        if (!this._incremental) {
            throw new OPatchAutoException("68090", new Object[0]);
        }
        Set<PatchPlanIncrementContainer> containers = this.getIncrementType().getPatchPlanIncrementSetCreator().getContainers(this.getPatchTargets());
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Created [" + this.getIncrementType() + "] incremental set for types " + this.getTypes() + " with patch plan increment containers " + containers);
        }
        return new LinkedHashSet<PatchPlanIncrementContainer>(containers){

            @Override
            public Iterator<PatchPlanIncrementContainer> iterator() {
                return PatchPlanTargetsImpl.this.getIncrementalIterator(super.iterator());
            }
        };
    }

    private Iterator<PatchPlanIncrementContainer> getIncrementalIterator(Iterator<PatchPlanIncrementContainer> wrappedIterator) {
        if (this._iterator == null) {
            this._iterator = new PatchPlanTargetsIterator<PatchPlanIncrementContainer>(wrappedIterator);
        }
        return this._iterator;
    }

    @Override
    public void disposeIncrementalIterator() {
        this._iterator = null;
    }

    @Override
    public boolean isParallel(PatchSession patchSession) {
        boolean parallel = this._parallel != null ? this._parallel : patchSession != null && patchSession.isParallelExecutionEnabled();
        return parallel;
    }

    @Override
    public void setParallel(Boolean parallel) {
        this._parallel = parallel;
    }

    @Override
    public Set<PatchTarget> getPatchTargets(boolean current) {
        return this.getPatchTargets(current, null);
    }

    @Override
    public Set<PatchTarget> getPatchTargets(boolean current, Set<String> types) {
        LinkedHashSet<PatchTarget> patchTargets = new LinkedHashSet<PatchTarget>();
        if (current && this._incremental) {
            if (this._currentItem != null) {
                patchTargets.addAll(this._currentItem.getPatchTargets(types));
            }
        } else if (types != null && !types.isEmpty()) {
            for (PatchTarget patchTarget : this.getPatchTargets()) {
                if (!types.contains(patchTarget.getType())) continue;
                patchTargets.add(patchTarget);
            }
        } else {
            patchTargets.addAll(this.getPatchTargets());
        }
        if (this.isConsolidateSharedHomes()) {
            this.consolidateSharedHome(patchTargets);
        }
        return patchTargets;
    }

    public Set<PatchTarget> getPatchTargets() {
        if (this._sortedPatchTargets == null) {
            this._sortedPatchTargets = this._patchTargets;
            if (this.getProductSupportManager() != null) {
                for (ProductSupport productSupport : this.getProductSupportManager().getProductSupport()) {
                    Set<PatchTarget> sorted = productSupport.getSortedPatchTargets(this._sortedPatchTargets);
                    if (sorted == null) continue;
                    if (sorted.size() != this._patchTargets.size()) {
                        throw new IllegalStateException("The patch targets sorted set size (" + sorted.size() + ") does not match the original set's size (" + this._patchTargets.size() + ").");
                    }
                    this._sortedPatchTargets = sorted;
                }
            }
        }
        return this._sortedPatchTargets;
    }

    @Override
    public void addPatchTarget(PatchTarget patchTarget) {
        this._patchTargets.add(patchTarget);
        this._sortedPatchTargets = null;
    }

    @Override
    public void addPatchTargets(Collection<PatchTarget> patchTargets) {
        if (patchTargets != null) {
            this._patchTargets.addAll(patchTargets);
            this._sortedPatchTargets = null;
        }
    }

    @Override
    public Set<PatchTarget> getLocalPatchTargets(boolean current) throws OPatchAutoException {
        return this.getLocalPatchTargets(current, null);
    }

    @Override
    public Set<PatchTarget> getLocalPatchTargets(boolean current, Set<String> types) throws OPatchAutoException {
        LinkedHashSet<PatchTarget> localPatchTargets = new LinkedHashSet<PatchTarget>();
        Set<PatchTarget> patchTargets = this.getPatchTargets(current, types);
        if (patchTargets != null && !patchTargets.isEmpty()) {
            for (PatchTarget patchTarget : patchTargets) {
                if (patchTarget.isRemote()) continue;
                localPatchTargets.add(patchTarget);
            }
        }
        return localPatchTargets;
    }

    @Override
    public Set<PatchTarget> getRemotePatchTargets(boolean current) throws OPatchAutoException {
        return this.getRemotePatchTargets(current, null);
    }

    @Override
    public Set<PatchTarget> getRemotePatchTargets(boolean current, Set<String> types) throws OPatchAutoException {
        LinkedHashSet<PatchTarget> remotePatchTargets = new LinkedHashSet<PatchTarget>();
        Set<PatchTarget> patchTargets = this.getPatchTargets(current, types);
        if (patchTargets != null && !patchTargets.isEmpty()) {
            for (PatchTarget patchTarget : patchTargets) {
                if (!patchTarget.isRemote()) continue;
                remotePatchTargets.add(patchTarget);
            }
        }
        return remotePatchTargets;
    }

    public String toString() {
        return this.getTypes() + "->" + this.getPatchTargets(false);
    }

    private void consolidateSharedHome(Set<PatchTarget> patchTargetList) {
        if (patchTargetList != null && !patchTargetList.isEmpty()) {
            ArrayList<PatchTarget> patchtargetsTobeRemoved = new ArrayList<PatchTarget>();
            for (PatchTarget patchTarget : patchTargetList) {
                if (!patchTarget.getHome().isSharedHome()) continue;
                List<Home> sharedHomes = patchTarget.getHome().getSharedHomeList();
                if (patchtargetsTobeRemoved.contains(patchTarget)) continue;
                this.markForRemoval(patchTargetList, sharedHomes, patchtargetsTobeRemoved);
            }
            patchTargetList.removeAll(patchtargetsTobeRemoved);
        }
    }

    private void markForRemoval(Set<PatchTarget> list, List<Home> sharedHomes, List<PatchTarget> patchTargetsTobeRemoved) {
        for (PatchTarget patchtarget : list) {
            if (!patchtarget.getHome().isSharedHome() || !sharedHomes.contains(patchtarget.getHome())) continue;
            patchTargetsTobeRemoved.add(patchtarget);
        }
    }

    public class PatchPlanTargetsIterator<E extends PatchPlanIncrementContainer>
    implements Iterator<PatchPlanIncrementContainer> {
        private Iterator<E> _wrappedIterator;

        public PatchPlanTargetsIterator(Iterator<E> wrappedIterator) {
            this._wrappedIterator = wrappedIterator;
        }

        @Override
        public boolean hasNext() {
            return this._wrappedIterator.hasNext();
        }

        @Override
        public PatchPlanIncrementContainer next() {
            PatchPlanTargetsImpl.this._currentItem = (PatchPlanIncrementContainer)this._wrappedIterator.next();
            if (!this._wrappedIterator.hasNext()) {
                PatchPlanTargetsImpl.this.disposeIncrementalIterator();
            }
            return PatchPlanTargetsImpl.this._currentItem;
        }

        @Override
        public void remove() {
            this._wrappedIterator.remove();
        }
    }
}

