/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.lifecycle;

import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.lifecycle.FinalizePhase;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.OnlinePhase;
import com.oracle.glcm.patch.auto.lifecycle.PatchPhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum Phase {
    init(InitPhase.class),
    shutdown(ShutdownPhase.class),
    offline(OfflinePhase.class),
    startup(StartupPhase.class),
    online(OnlinePhase.class),
    finalize(FinalizePhase.class);

    private Class<? extends PatchPhase> _phaseClass;
    private PatchPhase _instance;

    private Phase(Class<? extends PatchPhase> phaseClass) {
        this._phaseClass = phaseClass;
    }

    public Class getPhaseClass() {
        return this._phaseClass;
    }

    public PatchPhase getPhaseInstance() {
        if (this._instance == null) {
            try {
                this._instance = this._phaseClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68086", this._phaseClass), e);
            }
        }
        return this._instance;
    }

    public boolean hasGoals() {
        Goal[] goals = this.getGoals();
        return goals != null && goals.length > 0;
    }

    public boolean hasGoal(String goal) {
        return this.getGoal(goal) != null;
    }

    public Goal getGoal(String goal) {
        if (this.hasGoals()) {
            for (Goal g : this.getPhaseInstance().getGoals()) {
                if (!g.getName().equalsIgnoreCase(goal)) continue;
                return g;
            }
        }
        return null;
    }

    public Goal[] getGoals() {
        return this.getPhaseInstance().getGoals();
    }

    public static List<Goal> getAllGoals() {
        ArrayList<Goal> goals = new ArrayList<Goal>();
        for (Phase phase : Phase.values()) {
            goals.addAll(Arrays.asList(phase.getGoals()));
        }
        return goals;
    }

    public boolean isInit() {
        return this == init;
    }

    public boolean isShutdown() {
        return this == shutdown;
    }

    public boolean isOffline() {
        return this == offline;
    }

    public boolean isStartup() {
        return this == startup;
    }

    public boolean isOnline() {
        return this == online;
    }

    public boolean isFinalize() {
        return this == finalize;
    }
}

