/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import java.util.ArrayList;
import java.util.Collection;

public enum OPatchAutoCommand {
    apply("opatchauto.apply.description", "opatchauto.apply.examples"),
    rollback("opatchauto.rollback.description", "opatchauto.rollback.examples"),
    action("opatchauto.action.description", "opatchauto.action.examples", true),
    resume("opatchauto.resume.description", "opatchauto.resume.examples"),
    version("opatchauto.version.description", "opatchauto.version.examples", false, false),
    lsphases("opatchauto.lsphases.description", "opatchauto.lsphases.examples", false, false),
    lsplans("opatchauto.lsplans.description", "opatchauto.lsplans.examples", false, false),
    report("opatchauto.report.description", "opatchauto.report.examples");

    private boolean _internal;
    private String _description;
    private boolean _hasOptions;
    private boolean _resumed = false;
    private String _example;

    private OPatchAutoCommand(String description, String example) {
        this(description, example, false);
    }

    private OPatchAutoCommand(String description, String example, boolean internal) {
        this(description, example, internal, true);
    }

    private OPatchAutoCommand(String description, String example, boolean internal, boolean hasOptions) {
        this._description = description;
        this._example = example;
        this._internal = internal;
        this._hasOptions = hasOptions;
    }

    public boolean isInternal() {
        return this._internal;
    }

    public boolean hasOptions() {
        return this._hasOptions;
    }

    public boolean isApply() {
        return this == apply;
    }

    public boolean isRollback() {
        return this == rollback;
    }

    public boolean isAction() {
        return this == action;
    }

    public boolean isVersion() {
        return this == version;
    }

    public boolean isLsPhases() {
        return this == lsphases;
    }

    public boolean isLsPlans() {
        return this == lsplans;
    }

    public boolean isResume() {
        return this == resume;
    }

    public boolean isResumed() {
        return this._resumed;
    }

    public boolean isReport() {
        return this == report;
    }

    public void setResumed(boolean resumed) {
        this._resumed = resumed;
    }

    public static Collection<OPatchAutoCommand> getExternalCommands() {
        ArrayList<OPatchAutoCommand> commands = new ArrayList<OPatchAutoCommand>();
        for (OPatchAutoCommand command : OPatchAutoCommand.values()) {
            if (command.isInternal()) continue;
            commands.add(command);
        }
        return commands;
    }

    public String getDescription() {
        String desc = OPatchAutoHelper.getLocalizedString(this._description, new Object[0]);
        return !StringUtil.isNullOrEmpty((String)desc) ? desc : this._description;
    }

    public String getExample() {
        String example = OPatchAutoHelper.getLocalizedString(this._example, new Object[0]);
        return example.equals(this._example) ? null : example;
    }
}

