/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.dao;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.dao.VersionRange;
import java.util.List;

public class DependencyRef
extends AbstractDataHandlerWrapper {
    public DependencyRef(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public List<VersionRange> getVersionRanges() {
        return this.getComplexValueWrappedList("version-range", VersionRange.class);
    }

    public void setVersionRanges(List<VersionRange> versionRanges) {
        this.setComplexValueWrappedList("version-range", versionRanges);
    }

    public String getVersion() {
        return this.getStringAttribute("version");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public boolean getColocated() {
        return this.getBooleanAttribute("colocated");
    }

    public boolean hasPomGen() {
        return this.getBooleanAttribute("pom-gen");
    }

    public void setPomGen(boolean pomGen) {
        this.setAttribute("pom-gen", pomGen);
    }

    public String getId() {
        String id = null;
        try {
            id = this.getStringAttribute("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return id;
    }

    public boolean isSetVersion() {
        return !StringUtil.isNullOrEmpty((String)this.getVersion(), (boolean)true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DependencyRef reference = (DependencyRef)((Object)o);
        String name = this.getName();
        String version = this.getVersion();
        String otherName = reference.getName();
        String otherVersion = reference.getVersion();
        return !(name == null ? otherName != null : !name.equals(otherName)) && !(version == null ? otherVersion != null : !version.equals(otherVersion));
    }

    public int hashCode() {
        String name = this.getName();
        String version = this.getVersion();
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (version != null ? version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getName() + " " + this.getVersion();
    }
}

