/*
 * Decompiled with CFR 0.152.
 */
package model.util;

import java.util.ArrayList;
import java.util.List;
import model.BaseClass;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.ACFS;
import model.db_crs.ASMCluster;
import model.db_crs.ASMInstance;
import model.db_crs.CRSCluster;
import model.db_crs.DB;
import model.db_crs.DGObserver;
import model.db_crs.HAS;
import model.db_crs.OracleListener;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import model.db_crs.RestartInstance;
import model.db_crs.SIDatabase;
import model.fafmw.ASInstance;
import model.fafmw.ApplTop;
import model.fafmw.BI;
import model.fafmw.BIApplication;
import model.fafmw.ClusteredApp;
import model.fafmw.ESS;
import model.fafmw.FMWHome;
import model.fafmw.FusionClusterApp;
import model.fafmw.FusionJ2EEApp;
import model.fafmw.FusionProduct;
import model.fafmw.FusionProductFamily;
import model.fafmw.GOPServer;
import model.fafmw.IAS_Farm;
import model.fafmw.IDM;
import model.fafmw.LDAP;
import model.fafmw.LoadBalancer;
import model.fafmw.NodeManager;
import model.fafmw.Offering;
import model.fafmw.OracleHTTPServer;
import model.fafmw.SOAComposite;
import model.fafmw.SOAInfraClusterApp;
import model.fafmw.SOAResourceBundle;
import model.fafmw.WLAdminServer;
import model.fafmw.WLCluster;
import model.fafmw.WLDomain;
import model.fafmw.WLSHome;
import model.fafmw.WLSMachine;
import model.fafmw.WLServer;
import model.fafmw.WebCenter;
import model.util.FAconfigInstance;
import model.util.ORAsysInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtilities {
    static String topPackage = "model";
    static String fileSeparator = System.getProperties().getProperty("file.separator").toString();
    static String fileName = "FAconfigInstance.xml";
    static boolean doXML = false;

    public static void main(String[] stringArray) {
        try {
            if (stringArray != null && stringArray.length > 0) {
                fileName = stringArray[0];
            }
            FAconfigInstance fAconfigInstance = ModelUtilities.testFA();
            ArrayList<Class> arrayList = new ArrayList<Class>();
            arrayList.add(OracleHome.class);
            arrayList.add(Host.class);
            arrayList.add(RACDatabase.class);
            arrayList.add(RACDBInstance.class);
            arrayList.add(SIDatabase.class);
            arrayList.add(CRSCluster.class);
            arrayList.add(HAS.class);
            arrayList.add(ACFS.class);
            arrayList.add(ASMInstance.class);
            arrayList.add(ASMCluster.class);
            arrayList.add(OracleListener.class);
            arrayList.add(RestartInstance.class);
            arrayList.add(DB.class);
            arrayList.add(DGObserver.class);
            System.out.println("\n\n**************   DB-CRS SysInstance ***************");
            ORAsysInstance oRAsysInstance = new ORAsysInstance(arrayList);
            for (Object e : oRAsysInstance.all) {
                ((BaseClass)e).getOutboundAssociations();
            }
            System.out.println("\n*****************************\n");
            arrayList = new ArrayList();
            arrayList.add(OracleHome.class);
            arrayList.add(Host.class);
            arrayList.add(DB.class);
            arrayList.add(WLServer.class);
            arrayList.add(WLSMachine.class);
            arrayList.add(NodeManager.class);
            arrayList.add(WLDomain.class);
            arrayList.add(WLCluster.class);
            arrayList.add(WLAdminServer.class);
            arrayList.add(ASInstance.class);
            arrayList.add(IAS_Farm.class);
            arrayList.add(LoadBalancer.class);
            arrayList.add(OracleHTTPServer.class);
            arrayList.add(ApplTop.class);
            arrayList.add(FMWHome.class);
            arrayList.add(WLSHome.class);
            arrayList.add(FusionProductFamily.class);
            arrayList.add(FusionProduct.class);
            arrayList.add(Offering.class);
            arrayList.add(FusionJ2EEApp.class);
            arrayList.add(FusionClusterApp.class);
            arrayList.add(SOAComposite.class);
            arrayList.add(SOAInfraClusterApp.class);
            arrayList.add(SOAResourceBundle.class);
            arrayList.add(WebCenter.class);
            arrayList.add(BI.class);
            arrayList.add(BIApplication.class);
            arrayList.add(ESS.class);
            arrayList.add(IDM.class);
            arrayList.add(LDAP.class);
            arrayList.add(GOPServer.class);
            System.out.println("\n\n**************   FA-FMW SysInstance ***************");
            oRAsysInstance = new ORAsysInstance(arrayList);
            for (Object e : oRAsysInstance.all) {
                ((BaseClass)e).getOutboundAssociations();
            }
            System.out.println("\n*****************************\n");
        }
        catch (Throwable throwable) {
            System.out.println(" Exception = " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    protected static WLDomain getDomain(String string) {
        WLDomain wLDomain = new WLDomain();
        wLDomain.setName(string);
        WLAdminServer wLAdminServer = new WLAdminServer();
        wLAdminServer.setWLDomain(wLDomain);
        wLAdminServer.setURL(string + "_ADMIN_SERVER_URL");
        wLAdminServer.setUserName(string + "_ADMIN_SERVER_USER_NAME");
        wLAdminServer.setPassword(string + "_ADMIN_SERVER_PSW");
        wLDomain.setWLAdminServer(wLAdminServer);
        return wLDomain;
    }

    protected static void setSOACompToDomain(WLDomain wLDomain, List<SOAComposite> list) {
        SOAInfraClusterApp sOAInfraClusterApp = new SOAInfraClusterApp();
        sOAInfraClusterApp.setSOAComposites(list);
        WLCluster wLCluster = new WLCluster();
        ArrayList<ClusteredApp> arrayList = new ArrayList<ClusteredApp>();
        arrayList.add(sOAInfraClusterApp);
        wLCluster.setAppClusters(arrayList);
        ArrayList<WLCluster> arrayList2 = new ArrayList<WLCluster>();
        arrayList2.add(wLCluster);
        wLDomain.setWLClusters(arrayList2);
    }

    public static FAconfigInstance testFA() {
        WLDomain wLDomain = ModelUtilities.getDomain("FIN");
        WLDomain wLDomain2 = ModelUtilities.getDomain("CRM");
        WLDomain wLDomain3 = ModelUtilities.getDomain("SCM");
        WLDomain wLDomain4 = ModelUtilities.getDomain("PRC");
        WLDomain wLDomain5 = ModelUtilities.getDomain("PRJ");
        SOAComposite sOAComposite = new SOAComposite();
        sOAComposite.setName("FIN_SOA_1");
        SOAComposite sOAComposite2 = new SOAComposite();
        sOAComposite2.setName("FIN_SOA_2");
        ArrayList<SOAComposite> arrayList = new ArrayList<SOAComposite>();
        arrayList.add(sOAComposite);
        arrayList.add(sOAComposite2);
        ModelUtilities.setSOACompToDomain(wLDomain, arrayList);
        SOAComposite sOAComposite3 = new SOAComposite();
        sOAComposite3.setName("FIN_SOA_3");
        SOAComposite sOAComposite4 = new SOAComposite();
        sOAComposite4.setName("FIN_SOA_4");
        arrayList = new ArrayList();
        arrayList.add(sOAComposite3);
        arrayList.add(sOAComposite4);
        ModelUtilities.setSOACompToDomain(wLDomain2, arrayList);
        ModelUtilities.setSOACompToDomain(wLDomain3, arrayList);
        SOAResourceBundle sOAResourceBundle = new SOAResourceBundle();
        sOAResourceBundle.setName("FIN_SRB_1");
        ArrayList<SOAResourceBundle> arrayList2 = new ArrayList<SOAResourceBundle>();
        arrayList2.add(sOAResourceBundle);
        SOAComposite sOAComposite5 = new SOAComposite();
        sOAComposite5.setName("FIN_SOA_5");
        sOAComposite5.setSOAResourceBundle(arrayList2);
        arrayList = new ArrayList();
        arrayList.add(sOAComposite5);
        ModelUtilities.setSOACompToDomain(wLDomain4, arrayList);
        SOAComposite sOAComposite6 = new SOAComposite();
        sOAComposite2.setName("FIN_SOA_6");
        SOAComposite sOAComposite7 = new SOAComposite();
        sOAComposite7.setName("FIN_SOA_7");
        SOAResourceBundle sOAResourceBundle2 = new SOAResourceBundle();
        sOAResourceBundle2.setName("FIN_SRB_2");
        arrayList2 = new ArrayList();
        arrayList2.add(sOAResourceBundle2);
        sOAComposite6.setSOAResourceBundle(arrayList2);
        sOAComposite7.setSOAResourceBundle(arrayList2);
        arrayList = new ArrayList();
        arrayList.add(sOAComposite6);
        arrayList.add(sOAComposite7);
        ModelUtilities.setSOACompToDomain(wLDomain5, arrayList);
        BI bI = new BI();
        bI.setOracle_instance("BI_ORACLE_INSTANCE");
        bI.setRoot("BI_ROOT");
        IDM iDM = new IDM();
        iDM.setURL("IDM_URL");
        iDM.setLogon("IDM_LOGON");
        iDM.setPassword("psw");
        FAconfigInstance fAconfigInstance = new FAconfigInstance();
        fAconfigInstance.addRoot(wLDomain);
        fAconfigInstance.addRoot(wLDomain2);
        fAconfigInstance.addRoot(wLDomain3);
        fAconfigInstance.addRoot(wLDomain4);
        fAconfigInstance.addRoot(wLDomain5);
        fAconfigInstance.addRoot(bI);
        fAconfigInstance.addRoot(iDM);
        fAconfigInstance.setAllClasses(new Class[]{SOAComposite.class, SOAResourceBundle.class, SOAInfraClusterApp.class, WLCluster.class, WLDomain.class, WLAdminServer.class, IDM.class, BI.class, FAconfigInstance.class});
        return fAconfigInstance;
    }

    public static void setSOACompOnDomain(WLAdminServer wLAdminServer, List<SOAComposite> list) {
        WLDomain wLDomain = new WLDomain();
        wLDomain.setName(wLAdminServer.getName());
        wLAdminServer.setWLDomain(wLDomain);
        SOAInfraClusterApp sOAInfraClusterApp = new SOAInfraClusterApp();
        sOAInfraClusterApp.setSOAComposites(list);
        WLCluster wLCluster = new WLCluster();
        ArrayList<ClusteredApp> arrayList = new ArrayList<ClusteredApp>();
        arrayList.add(sOAInfraClusterApp);
        wLCluster.setAppClusters(arrayList);
        ArrayList<WLCluster> arrayList2 = new ArrayList<WLCluster>();
        arrayList2.add(wLCluster);
        wLDomain.setWLClusters(arrayList2);
    }

    public static void generateXML(FAconfigInstance fAconfigInstance) {
    }
}

