/*
 * Decompiled with CFR 0.152.
 */
package model.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import model.BaseClass;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.exalogic.ExalogicSystem;
import model.exalogic.Rack;
import model.exalogic.RackList;
import model.exalogic.StorageHead;
import model.exalogic.StorageHeadILOM;
import model.exalogic.Workflow;
import model.exalogic.ZFSAppliance;

public class ExalogicConfigInstance
extends SystemInstance {
    static String xmlFileName = "model/xml/ZFS.xml";

    public ExalogicConfigInstance() {
        this.setTop(this.buildConfig());
    }

    protected AbstractBaseTarget buildConfig() {
        ExalogicSystem exalogicSystem = new ExalogicSystem();
        exalogicSystem.setName(" Exalogic POC system");
        exalogicSystem.setDisplayName(" Exalogic POC system");
        this.systemEntities.add(exalogicSystem);
        Rack rack = new Rack();
        rack.setName(" Rack");
        rack.setDisplayName(" Rack");
        RackList rackList = new RackList();
        rackList.getRack().add(rack);
        exalogicSystem.setRackList(rackList);
        this.systemEntities.add(rack);
        ZFSAppliance zFSAppliance = new ZFSAppliance();
        zFSAppliance.setName("ZFS");
        zFSAppliance.setDisplayName("ZFS");
        Host host = new Host();
        host.setName(" ZFS host");
        host.setHostName(" ZFS host");
        host.setDisplayName(" ZFS host display name");
        this.systemEntities.add(host);
        zFSAppliance.setHost(host);
        rack.setZFSAppliance(zFSAppliance);
        this.systemEntities.add(zFSAppliance);
        StorageHead storageHead = new StorageHead();
        storageHead.setName(" StorageHead 1");
        storageHead.setDisplayName(" StorageHead 1");
        storageHead.setIP("storage_head_1_IP");
        storageHead.setMaster(true);
        storageHead.setNumber("1");
        storageHead.setZFSAppliance(zFSAppliance);
        Host host2 = new Host();
        host2.setName(" storage head 1 host");
        host2.setHostName(" storage head 1 host");
        host2.setDisplayName(" storage head 1");
        this.systemEntities.add(host2);
        storageHead.setHost(host2);
        zFSAppliance.getStorageHeads().add(storageHead);
        this.systemEntities.add(storageHead);
        StorageHeadILOM storageHeadILOM = new StorageHeadILOM();
        storageHeadILOM.setName("ILOM 1");
        storageHeadILOM.setDisplayName("ILOM 1");
        storageHeadILOM.setHost(host2);
        this.systemEntities.add(storageHeadILOM);
        storageHead.setILOM(storageHeadILOM);
        storageHeadILOM.setIlomHost(storageHead);
        Workflow workflow = new Workflow();
        workflow.setName(" Workflow 1");
        workflow.setDisplayName(" Workflow 1");
        storageHead.getWorkflows().add(workflow);
        this.systemEntities.add(workflow);
        workflow = new Workflow();
        workflow.setName(" Workflow 2");
        workflow.setDisplayName(" Workflow 2");
        storageHead.getWorkflows().add(workflow);
        this.systemEntities.add(workflow);
        storageHead = new StorageHead();
        storageHead.setName(" StorageHead 2");
        storageHead.setDisplayName(" StorageHead 2");
        storageHead.setIP("storage_head_2_IP");
        storageHead.setMaster(false);
        storageHead.setNumber("2");
        storageHead.setZFSAppliance(zFSAppliance);
        Host host3 = new Host();
        host3.setName(" storage head 2 host");
        host3.setHostName(" storage head 2 host");
        host3.setDisplayName(" storage head 2");
        this.systemEntities.add(host3);
        storageHead.setHost(host3);
        zFSAppliance.getStorageHeads().add(storageHead);
        this.systemEntities.add(storageHead);
        storageHeadILOM = new StorageHeadILOM();
        storageHeadILOM.setName("ILOM 2");
        storageHeadILOM.setDisplayName("ILOM 2");
        storageHeadILOM.setHost(host3);
        storageHead.setILOM(storageHeadILOM);
        storageHeadILOM.setIlomHost(storageHead);
        this.systemEntities.add(storageHeadILOM);
        workflow = new Workflow();
        workflow.setName(" Workflow 3");
        workflow.setDisplayName(" Workflow 3");
        storageHead.getWorkflows().add(workflow);
        this.systemEntities.add(workflow);
        workflow = new Workflow();
        workflow.setName(" Workflow 4");
        workflow.setDisplayName(" Workflow 4");
        storageHead.getWorkflows().add(workflow);
        this.systemEntities.add(workflow);
        return exalogicSystem;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer(" top=").append(this.getTop() == null ? " top is null!" : this.getTop().print());
            for (BaseClass baseClass : this.systemEntities) {
                stringBuffer.append("\n").append(baseClass.getClass().getName()).append("\n");
                stringBuffer.append("** Attributes \n");
                for (Method method : baseClass.getRequestedAttributeGetters()) {
                    stringBuffer.append(this.stripGetSet(method.getName())).append(" = ").append(method.invoke((Object)baseClass, null)).append(" ; ");
                }
                stringBuffer.append("\n** Outbound Associations \n");
                Map<String, List<BaseClass>> map = baseClass.getOutboundAssociations();
                for (String string : map.keySet()) {
                    stringBuffer.append(string).append(" = ");
                    for (BaseClass baseClass2 : (List)map.get(string)) {
                        stringBuffer.append(baseClass2.toString()).append(" ; ");
                    }
                    stringBuffer.append("\n");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println(" Exception = " + exception.getMessage());
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    private String stripGetSet(String string) {
        if (string.startsWith("get") || string.startsWith("set")) {
            return string.substring(3);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            ExalogicConfigInstance exalogicConfigInstance = new ExalogicConfigInstance();
            System.out.println("\n**********  Serializing ZFS to  " + xmlFileName + "************");
            exalogicConfigInstance.writeFile(new File(xmlFileName));
            System.out.println("\n**********  Sample Exalogic Config ************");
            System.out.println(exalogicConfigInstance.toString());
            System.out.println("**********************************************************\n");
        }
        catch (Throwable throwable) {
            System.out.println(" Exception = " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }
}

