/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.db_crs.CRSCluster;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.db.validation.causes.NoRAC;
import oracle.oplan.db.validation.causes.NoRACinstances;
import oracle.oplan.db.validation.rules.CRSRAChomeNotShared;
import oracle.oplan.sdk.cookies.SkipTargetCookie;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingVersion;
import oracle.osysmodel.validation.causes.WrongVersion;
import oracle.osysmodel.validation.rules.BaseRule;

public class RACversionCRS
extends BaseRule {
    Logger logger = Logger.getLogger(CRSRAChomeNotShared.class.getName());

    public RACversionCRS(SystemInstance config) {
        super(config);
        this.successMessage = " CRS version is greater or equal to RAC";
    }

    public RuleResult invoke() throws ConfigValidationException {
        List racs;
        this.logger.log(Level.FINE, "Invoking rule to ensure that CRS has a greater version than the RAC DBs");
        ArrayList<Object> nullCauses = new ArrayList<Object>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = this.config.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                this.logger.log(Level.FINE, "CRSCluster does not exist.");
                nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(RACversionCRS.class, (String)"NO_CRS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            if (crsList.size() != 1) {
                this.logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                nullCauses.add((Object)new MultipleCRSObject(null, BundleUtils.getMessage(RACversionCRS.class, (String)"MULTIPLE_CRS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the CRSObject");
            this.config.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(this.config.getTop() instanceof CRSCluster)) {
            this.logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(RACversionCRS.class, (String)"TOP_NOT_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        list.add(crs);
        String verCRS = crs.getVersion();
        if (verCRS == null || verCRS.length() == 0) {
            this.logger.log(Level.FINE, "CRS Version is not set");
            nullCauses.add(new MissingVersion(list, BundleUtils.getMessage(RACversionCRS.class, (String)"MISSING_VERSION", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
        }
        if ((racs = crs.getDbRAC()) == null || racs.isEmpty()) {
            this.logger.log(Level.FINE, "The CRS does not have any RAC Databases running out of it.");
            nullCauses.add((Object)new NoRAC(list, BundleUtils.getMessage(RACversionCRS.class, (String)"NO_RAC", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
        }
        if (!nullCauses.isEmpty()) {
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDatabase> noInstances = new ArrayList<RACDatabase>();
        for (RACDatabase rac : racs) {
            if (rac.getDbInstances() != null && !rac.getDbInstances().isEmpty()) continue;
            this.logger.log(Level.FINE, "There are RAC Databases with no instances associated");
            noInstances.add(rac);
        }
        if (!noInstances.isEmpty()) {
            nullCauses.add((Object)new NoRACinstances(noInstances, BundleUtils.getMessage(RACversionCRS.class, (String)"NO_RACINSTANCE", (Object[])new Object[]{BundleUtils.makeStringOutOfList(noInstances)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDBInstance> instMissingVersion = new ArrayList<RACDBInstance>();
        ArrayList<RACDatabase> wrongVersion = new ArrayList<RACDatabase>();
        for (RACDatabase rac : racs) {
            String verRAC = null;
            if (rac.getProperty(SkipTargetCookie.class) != null) continue;
            for (RACDBInstance instance : rac.getDbInstances()) {
                String verInst = instance.getVersion();
                if (verInst == null) {
                    instMissingVersion.add(instance);
                    continue;
                }
                if (verRAC != null) continue;
                verRAC = verInst;
            }
            if (verCRS == null || verRAC == null) continue;
            String crsVersion = this.formattedVersion(verCRS);
            String racVersion = this.formattedVersion(verRAC);
            if (crsVersion.trim().compareToIgnoreCase(racVersion.trim()) >= 0) continue;
            wrongVersion.add(rac);
        }
        if (!instMissingVersion.isEmpty()) {
            nullCauses.add(new MissingVersion(instMissingVersion, BundleUtils.getMessage(RACversionCRS.class, (String)"MISSING_VERSION", (Object[])new Object[]{BundleUtils.makeStringOutOfList(instMissingVersion)})));
        }
        if (!nullCauses.isEmpty()) {
            return new RuleResult((Rule)this, (Boolean)null, nullCauses);
        }
        if (!wrongVersion.isEmpty()) {
            ArrayList<WrongVersion> failureCauses = new ArrayList<WrongVersion>();
            failureCauses.add(new WrongVersion(wrongVersion, BundleUtils.getMessage(RACversionCRS.class, (String)"RAC_VERSION_GREATER_THAN_CRS", (Object[])new Object[]{BundleUtils.makeStringOutOfList(wrongVersion)})));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this, new Boolean(true), null);
    }

    private String formattedVersion(String formattedVersion) {
        if (formattedVersion.split("\\.").length == 5) {
            formattedVersion = formattedVersion.substring(0, formattedVersion.lastIndexOf("."));
        }
        return formattedVersion;
    }
}

