/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.db_crs.CRSCluster;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.sdk.cookies.SkipTargetCookie;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingVersion;
import oracle.osysmodel.validation.causes.WrongVersion;
import oracle.osysmodel.validation.rules.BaseRule;

public class CRSversionGreater
extends BaseRule {
    Logger logger = Logger.getLogger(CRSversionGreater.class.getName());
    private String strMinCRSversion = null;
    private String minUnSupportedCrsVersion = "12.2";

    public CRSversionGreater(SystemInstance config, String strMinCRSversion) {
        super(config);
        this.strMinCRSversion = strMinCRSversion;
        this.successMessage = " CRS version is greater or equal to " + strMinCRSversion;
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to ensure that CRS version is greater than " + this.strMinCRSversion);
        ArrayList<Object> nullCauses = new ArrayList<Object>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = this.config.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                this.logger.log(Level.FINE, "CRSCluster does not exist.");
                nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(CRSversionGreater.class, (String)"NO_CRS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            if (crsList.size() != 1) {
                this.logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                nullCauses.add((Object)new MultipleCRSObject(null, BundleUtils.getMessage(CRSversionGreater.class, (String)"MULTIPLE_CRS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the CRSObject");
            this.config.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(this.config.getTop() instanceof CRSCluster)) {
            this.logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(CRSversionGreater.class, (String)"TOP_NOT_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        ArrayList<WrongVersion> failureCauses = new ArrayList<WrongVersion>();
        String verCRS = crs.getVersion();
        if (verCRS == null || verCRS.length() == 0) {
            this.logger.log(Level.FINE, "CRS object is missing the version information.");
            list.add(crs);
            nullCauses.add(new MissingVersion(list, BundleUtils.getMessage(CRSversionGreater.class, (String)"MISSING_VERSION", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        if (crs.getVersion().trim().compareToIgnoreCase(this.strMinCRSversion) >= 0) {
            if (this.config.getTop().getProperty(SkipTargetCookie.class) == null && crs.getVersion().trim().compareToIgnoreCase(this.minUnSupportedCrsVersion) >= 0) {
                this.logger.log(Level.FINE, "CRS version is not supported from oplan. For Crs Version 12.2 onwards please use OPatch auto.");
                failureCauses.add(new WrongVersion(list, BundleUtils.getMessage(CRSversionGreater.class, (String)"CRS_VERSION_HIGHER", (Object[])new Object[]{this.minUnSupportedCrsVersion, BundleUtils.makeStringOutOfList(list)})));
                return new RuleResult((Rule)this, new Boolean(false), failureCauses);
            }
            this.logger.log(Level.FINE, "CRS version is greater than the minimum required version");
            return new RuleResult((Rule)this);
        }
        this.logger.log(Level.FINE, "Current CRS version is less than the minimum version required.");
        failureCauses.add(new WrongVersion(list, BundleUtils.getMessage(CRSversionGreater.class, (String)"CRS_VERSION_NOT_SUPPORTED", (Object[])new Object[]{this.strMinCRSversion, BundleUtils.makeStringOutOfList(list)})));
        return new RuleResult((Rule)this, new Boolean(false), failureCauses);
    }
}

