/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.ValidPlatforms;
import oracle.osysmodel.validation.causes.InvalidPlatform;
import oracle.osysmodel.validation.causes.MissingHome;
import oracle.osysmodel.validation.causes.MissingPlatform;
import oracle.osysmodel.validation.causes.UnequalPlatform;
import oracle.osysmodel.validation.rules.BaseRule;

public class CRSplatformValid
extends BaseRule {
    Logger logger = Logger.getLogger(CRSplatformValid.class.getName());

    public CRSplatformValid(SystemInstance config) {
        super(config);
        this.successMessage = " All CRS homes have the same platform ARUid and this ARUid is valid";
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Ensuring that all the homes have the same platform and the ARUid is one of the recognized ARUids.");
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        list.add(crs);
        List homes = this.config.getAllHomes();
        ArrayList<Object> failureCauses = new ArrayList<Object>();
        if (homes == null || homes.isEmpty()) {
            this.logger.log(Level.FINE, " CRS " + crs + "does not have any home ");
            failureCauses.add(new MissingHome(list, BundleUtils.getMessage(CRSplatformValid.class, (String)"CRS_NO_HOME", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        String crsPlatform = null;
        ArrayList<OracleHome> missingPlatform = new ArrayList<OracleHome>();
        ArrayList<OracleHome> invalidPlatform = new ArrayList<OracleHome>();
        ArrayList<OracleHome> unequalPlatform = new ArrayList<OracleHome>();
        for (OracleHome home : homes) {
            String platform = home.getARUId();
            if (platform == null || platform.trim().length() == 0) {
                this.logger.log(Level.FINE, "ARU_ID info missing for home at path " + home.getPath());
                missingPlatform.add(home);
                continue;
            }
            if (!ValidPlatforms.isValid((String)platform)) {
                this.logger.log(Level.FINE, "ARU_ID for home at path " + home.getPath() + " is not a valid ARU_ID.");
                invalidPlatform.add(home);
                continue;
            }
            if (crsPlatform == null) {
                crsPlatform = platform.trim();
                continue;
            }
            if (crsPlatform.compareTo(platform) == 0) continue;
            this.logger.log(Level.FINE, "ARU_ID for the homes in this crs cluster are not equal. ");
            unequalPlatform.add(home);
        }
        if (!missingPlatform.isEmpty()) {
            failureCauses.add(new MissingPlatform(missingPlatform, BundleUtils.getMessage(CRSplatformValid.class, (String)"ARU_ID_NOT_SET", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingPlatform)})));
        }
        if (!invalidPlatform.isEmpty()) {
            failureCauses.add(new InvalidPlatform(invalidPlatform, BundleUtils.getMessage(CRSplatformValid.class, (String)"INVALID_PLATFORM", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingPlatform)})));
        }
        if (!unequalPlatform.isEmpty()) {
            failureCauses.add(new UnequalPlatform(unequalPlatform, BundleUtils.getMessage(CRSplatformValid.class, (String)"UNEQUAL_PLATFORM", (Object[])new Object[]{BundleUtils.makeStringOutOfList(unequalPlatform)})));
        }
        if (!failureCauses.isEmpty()) {
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

