/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.SIDatabase;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.db.validation.causes.NoSIDB;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.BaseCause;
import oracle.osysmodel.validation.causes.MissingHome;
import oracle.osysmodel.validation.causes.MissingHost;
import oracle.osysmodel.validation.causes.MissingVersion;
import oracle.osysmodel.validation.rules.BaseRule;

public class CRSSIDBsValid
extends BaseRule {
    Logger logger = Logger.getLogger(CRSSIDBsValid.class.getName());

    public CRSSIDBsValid(SystemInstance config) {
        super(config);
        this.successMessage = " CRS SIDB configuration is valid";
    }

    public RuleResult invoke() throws ConfigValidationException {
        ArrayList<BaseCause> nullCauses = new ArrayList<BaseCause>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = this.config.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                this.logger.log(Level.FINE, "CRSCluster does not exist.");
                nullCauses.add(new NoCRS(null, BundleUtils.getMessage(CRSSIDBsValid.class, (String)"NO_CRS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            if (crsList.size() != 1) {
                this.logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                nullCauses.add(new MultipleCRSObject(null, BundleUtils.getMessage(CRSSIDBsValid.class, (String)"MULTIPLE_CRS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the CRSObject");
            this.config.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(this.config.getTop() instanceof CRSCluster)) {
            this.logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            nullCauses.add(new NoCRS(null, BundleUtils.getMessage(CRSSIDBsValid.class, (String)"TOP_NOT_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        list.add(crs);
        List sidbs = crs.getDbSI();
        if (sidbs == null || sidbs.isEmpty()) {
            nullCauses.add(new NoSIDB(list));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<SIDatabase> missingVersion = new ArrayList<SIDatabase>();
        ArrayList<SIDatabase> missingHome = new ArrayList<SIDatabase>();
        ArrayList<OracleHome> missingHost = new ArrayList<OracleHome>();
        for (SIDatabase sidb : sidbs) {
            OracleHome home;
            if (sidb.getVersion() == null || sidb.getVersion().trim().length() == 0) {
                missingVersion.add(sidb);
            }
            if ((home = sidb.getRuns_from()) == null) {
                missingHome.add(sidb);
                continue;
            }
            List hosts = home.getHosts();
            if (hosts != null && !hosts.isEmpty()) continue;
            missingHost.add(home);
        }
        ArrayList<Object> failureCauses = new ArrayList<Object>();
        if (!missingVersion.isEmpty()) {
            failureCauses.add(new MissingVersion(missingVersion, BundleUtils.getMessage(CRSSIDBsValid.class, (String)"MISSING_VERSION", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingVersion)})));
        }
        if (!missingHome.isEmpty()) {
            failureCauses.add(new MissingHome(missingHome, BundleUtils.getMessage(CRSSIDBsValid.class, (String)"SIDB_MISSING_HOME", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingHome)})));
        }
        if (!missingHost.isEmpty()) {
            failureCauses.add(new MissingHost(missingHost, BundleUtils.getMessage(CRSSIDBsValid.class, (String)"MISSING_HOST", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingHost)})));
        }
        if (!failureCauses.isEmpty()) {
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

