/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.db.validation.causes.NoRAC;
import oracle.oplan.db.validation.causes.NoRACinstances;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingHome;
import oracle.osysmodel.validation.causes.MissingHost;
import oracle.osysmodel.validation.causes.SharedHomes;
import oracle.osysmodel.validation.rules.BaseRule;

public class CRSRAChomeNotShared
extends BaseRule {
    Logger logger = Logger.getLogger(CRSRAChomeNotShared.class.getName());

    public CRSRAChomeNotShared(SystemInstance config) {
        super(config);
        this.successMessage = " all RAC run from non-shared homes";
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to ensure RACHome is not shared.");
        ArrayList<Object> nullCauses = new ArrayList<Object>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = this.config.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                this.logger.log(Level.FINE, "CRSCluster does not exist.");
                nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(CRSRAChomeNotShared.class, (String)"NO_CRS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            if (crsList.size() != 1) {
                this.logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                nullCauses.add((Object)new MultipleCRSObject(null, BundleUtils.getMessage(CRSRAChomeNotShared.class, (String)"MULTIPLE_CRS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the CRSObject");
            this.config.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(this.config.getTop() instanceof CRSCluster)) {
            this.logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(CRSRAChomeNotShared.class, (String)"TOP_NOT_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        ArrayList<SharedHomes> failureCauses = new ArrayList<SharedHomes>();
        List racs = crs.getDbRAC();
        if (racs == null || racs.isEmpty()) {
            this.logger.log(Level.FINE, "The crs has no RACDatabases running out of it.");
            list.add(crs);
            nullCauses.add((Object)new NoRAC(list, BundleUtils.getMessage(CRSRAChomeNotShared.class, (String)"NO_RAC", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDatabase> noInstances = new ArrayList<RACDatabase>();
        for (RACDatabase rac : racs) {
            if (rac.getDbInstances() != null && !rac.getDbInstances().isEmpty()) continue;
            this.logger.log(Level.FINE, "There are RAC Databases with no instances associated");
            noInstances.add(rac);
        }
        if (!noInstances.isEmpty()) {
            nullCauses.add((Object)new NoRACinstances(noInstances, BundleUtils.getMessage(CRSRAChomeNotShared.class, (String)"NO_RACINSTANCE", (Object[])new Object[]{BundleUtils.makeStringOutOfList(noInstances)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDBInstance> missingHome = new ArrayList<RACDBInstance>();
        ArrayList<OracleHome> missingHost = new ArrayList<OracleHome>();
        ArrayList<OracleHome> shared = new ArrayList<OracleHome>();
        ArrayList<OracleHome> nonshared = new ArrayList<OracleHome>();
        block1: for (RACDatabase rac : racs) {
            for (RACDBInstance instance : rac.getDbInstances()) {
                OracleHome home = instance.getRuns_from();
                if (home == null) {
                    this.logger.log(Level.FINE, "Instance is missing OracleHome information it runs from.");
                    missingHome.add(instance);
                    continue block1;
                }
                List hosts = home.getHosts();
                if (hosts == null || hosts.isEmpty()) {
                    this.logger.log(Level.FINE, "RACHome is missing the host information.");
                    missingHost.add(home);
                    continue block1;
                }
                if (hosts.size() != 1) {
                    this.logger.log(Level.FINE, "Home at " + home.getPath() + " is shared.");
                    shared.add(home);
                    continue;
                }
                this.logger.log(Level.FINE, "Home at " + home.getPath() + " is not shared.");
                nonshared.add(home);
            }
        }
        if (!missingHome.isEmpty()) {
            nullCauses.add(new MissingHome(missingHome, BundleUtils.getMessage(CRSRAChomeNotShared.class, (String)"RACINSTANCE_MISSING_HOME", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingHome)})));
        }
        if (!missingHost.isEmpty()) {
            nullCauses.add(new MissingHost(missingHost, BundleUtils.getMessage(CRSRAChomeNotShared.class, (String)"MISSING_HOST", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingHost)})));
        }
        if (!nullCauses.isEmpty()) {
            return new RuleResult((Rule)this, null, nullCauses);
        }
        if (!shared.isEmpty()) {
            failureCauses.add(new SharedHomes(shared, BundleUtils.getMessage(CRSRAChomeNotShared.class, (String)"HOMES_SHARED", (Object[])new Object[]{BundleUtils.makeStringOutOfList(shared)})));
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

