/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.oplan;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import model.BaseClass;
import model.SystemInstance;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSConfigCompareHelper
extends ConfigCompareHelper {
    private final String strMinRACversion = "11.2.0.2";
    Logger logger = Logger.getLogger(CRSConfigCompareHelper.class.getName());

    protected Set<String> processSystemInstanceToSkipUnSupportedVersionTarget(SystemInstance systemInst) {
        HashSet<String> skippedHomes = new HashSet<String>();
        this.logger.info("Before Preprocess of system instance " + systemInst.getEntities().size());
        Iterator itr = systemInst.getEntities().iterator();
        while (itr.hasNext()) {
            String racVer;
            BaseClass bc = (BaseClass)itr.next();
            if (bc instanceof CRSCluster) {
                List racDBList = ((CRSCluster)bc).getDbRAC();
                Iterator itr1 = racDBList.iterator();
                while (itr1.hasNext()) {
                    RACDatabase racDB = (RACDatabase)itr1.next();
                    String racVer2 = racDB.getVersion();
                    if (racVer2 != null) {
                        if (racVer2.trim().compareToIgnoreCase("11.2.0.2") >= 0) continue;
                        itr1.remove();
                        continue;
                    }
                    Iterator itr2 = racDB.getDbInstances().iterator();
                    while (itr2.hasNext()) {
                        RACDBInstance racDBInst = (RACDBInstance)itr2.next();
                        racVer2 = racDBInst.getVersion();
                        if (racVer2 == null || racVer2.trim().compareToIgnoreCase("11.2.0.2") >= 0) continue;
                        itr2.remove();
                    }
                }
            }
            if (bc instanceof RACDatabase) {
                RACDatabase racDB = (RACDatabase)bc;
                String racVer3 = racDB.getVersion();
                if (racVer3 != null) {
                    if (racVer3.trim().compareToIgnoreCase("11.2.0.2") < 0) {
                        if (racDB.getOracleHome() != null) {
                            skippedHomes.add(racDB.getOracleHome());
                        }
                        itr.remove();
                    }
                } else {
                    for (RACDBInstance racDBInst : racDB.getDbInstances()) {
                        racVer3 = racDBInst.getVersion();
                        if (racVer3 == null || racVer3.trim().compareToIgnoreCase("11.2.0.2") >= 0) continue;
                        if (racDB.getOracleHome() != null) {
                            skippedHomes.add(racDB.getOracleHome());
                        } else if (racDBInst.getOracleHome() != null) {
                            skippedHomes.add(racDB.getOracleHome());
                        }
                        itr.remove();
                    }
                }
            }
            if (!(bc instanceof RACDBInstance) || (racVer = ((RACDBInstance)bc).getVersion()) == null || racVer.trim().compareToIgnoreCase("11.2.0.2") >= 0) continue;
            if (((RACDBInstance)bc).getOracleHome() != null) {
                skippedHomes.add(((RACDBInstance)bc).getOracleHome());
            }
            itr.remove();
        }
        Iterator itr1 = systemInst.getEntities().iterator();
        while (itr1.hasNext()) {
            BaseClass bc = (BaseClass)itr1.next();
            if (!(bc instanceof OracleHome)) continue;
            OracleHome oh = (OracleHome)bc;
            if (skippedHomes.isEmpty() || !skippedHomes.contains(oh.getPath())) continue;
            itr1.remove();
        }
        this.logger.info("After Preprocess of system instance " + systemInst.getEntities().size());
        return skippedHomes;
    }
}

