/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.driver.crs;

import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import model.BaseClass;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.BaseSWComponent;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.ASMCluster;
import model.db_crs.ASMInstance;
import model.db_crs.CRSCluster;
import model.db_crs.DB;
import model.db_crs.DBInstance;
import model.db_crs.HAS;
import model.db_crs.OracleListener;
import model.db_crs.PDB;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import oracle.oplan.db.driver.util.CRSutil;
import oracle.osysmodel.driver.sdk.emrepo.BaseEMProductDriver;
import oracle.osysmodel.driver.sdk.emrepo.EMRepoDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSEMProductDriver
extends BaseEMProductDriver {
    private static Logger logger = Logger.getLogger(CRSEMProductDriver.class.getName());
    private String logDir = "";
    protected String guid = null;
    protected CRSCluster crs = null;
    protected ASMCluster asm = null;
    protected List<HAS> allHAS = new ArrayList<HAS>();
    protected List<Host> allHosts = new ArrayList<Host>();
    protected List<OracleHome> allHomes = new ArrayList<OracleHome>();
    protected List<RACDatabase> allRAC = new ArrayList<RACDatabase>();
    protected List<SIDatabase> allSIDB = new ArrayList<SIDatabase>();
    protected Map<String, DBInstance> allDBinstances = new HashMap<String, DBInstance>();
    protected Map<RACDatabase, List<RACDBInstance>> racInstances = new HashMap<RACDatabase, List<RACDBInstance>>();
    protected Map<ASMCluster, List<ASMInstance>> asmInstances = new HashMap<ASMCluster, List<ASMInstance>>();
    public final String gihome = "crs";
    public final String dbhome = "rac";
    protected final String schema = "SYSMAN.";
    protected final String viewTargets = "MGMT_TARGETS";
    protected final String viewDataGuard = "MGMT$HA_DG_TARGET_SUMMARY";
    private static final String sqlDataVault = "SELECT /*sqlDataVault*/ csnapshot.target_guid  FROM sysman.MGMT_DB_DBNINSTANCEINFO_ECM dvstatus, sysman.MGMT$ECM_CURRENT_SNAPSHOTS csnapshot WHERE  csnapshot.ecm_snapshot_id = dvstatus.ecm_snapshot_id AND dvstatus.dv_status_code = 1 AND  csnapshot.target_guid IN (?)";
    protected final String sqlTargetTypeByGuid = "SELECT /*sqlTargetTypeByGuid*/ TARGET_TYPE FROM SYSMAN.MGMT_TARGETS WHERE TARGET_GUID = ?";
    private final String sqlStandbyListInDGWithPrimary = "SELECT /*sqlStandbyListInDGWithPrimary*/ dg.stby_list FROM SYSMAN.MGMT$HA_DG_TARGET_SUMMARY dg, SYSMAN.MGMT_TARGETS tgt WHERE dg.target_guid=tgt.target_guid AND (tgt.target_type='oracle_database' or  tgt.target_type='rac_database') AND tgt.target_name=? AND dg.role='PRIMARY'";
    private final String sqlPrimaryWithStandby = "SELECT /*sqlPrimaryWithStandby*/ dg1.prmy_db_unique_name FROM SYSMAN.MGMT$HA_DG_TARGET_SUMMARY dg1, SYSMAN.MGMT_TARGETS tgt1 WHERE dg1.target_guid=tgt1.target_guid AND (tgt1.target_type='oracle_database' or  tgt1.target_type='rac_database') AND tgt1.target_name=? AND (dg1.role='PHYSICAL STANDBY' OR dg1.role='LOGICAL STANDBY')";
    private final String sqlDatabaseInDGWithDBName = "SELECT /*sqlDatabaseInDGWithDBName*/ target_guid, using_broker, active_stby  FROM SYSMAN.MGMT$HA_DG_TARGET_SUMMARY WHERE db_unique_name=?";

    public CRSEMProductDriver(String connectionString, String user, String password) throws Exception {
        super(connectionString, user, password);
    }

    public CRSEMProductDriver(Connection connection) throws Exception {
        super(connection);
    }

    public SystemInstance buildConfigGraph(String guid) throws Exception {
        CRSutil.setupLogs();
        this.guid = guid;
        try {
            logger.info("#############  CRS cluster guid= " + guid + "  #############");
            logger.info("#############  CRS cluster guid= " + guid + "  #############");
            SystemInstance sys = this.emGeneric.getSystemInstances(this.requestObj(guid), this.requestedAssociations, this.properySetters);
            this.setDB(sys.getEntities());
            this.setPrimaryAndStandbyDB(sys.getEntities());
            this.setAndValidate(sys);
            if (this.crs != null) {
                CRSutil.printCRS(sys);
            }
            logger.info(" ****************** ");
            try {
                String name = sys != null && sys.getTop() != null ? sys.getTop().getName() : guid;
                File file = new File(name + "_config.xml");
                logger.severe("\nabsolute file location is: " + file.getAbsoluteFile());
                sys.writeFile(file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            SystemInstance systemInstance = sys;
            return systemInstance;
        }
        catch (Throwable e) {
            logger.severe(e.getMessage());
            e.printStackTrace();
            throw new Exception(" Failed to build configuration graph for CRS cluster! GUID=" + guid, e);
        }
        finally {
            this.releaseDBConnection();
        }
    }

    protected void setDB(List<BaseClass> listFetched) {
        for (BaseClass instance : listFetched) {
            DB db;
            if (instance instanceof RACDatabase) {
                RACDatabase racDB = (RACDatabase)instance;
                db = new DB();
                racDB.setDBsystemInterface(db);
                db.setRAC(racDB);
            }
            if (!(instance instanceof SIDatabase)) continue;
            SIDatabase siDB = (SIDatabase)instance;
            db = new DB();
            siDB.setDBsystemInterface(db);
            db.setSI(siDB);
        }
    }

    protected void defaultValues(AbstractBaseTarget t) {
        if (t.getDisplayName() == null) {
            t.setDisplayName(t.getName());
        }
        t.setId("ID_" + UUID.randomUUID().toString());
        if (t.getPlatform() == null) {
            t.setPlatform("linux");
        }
        if (t.getType() == null) {
            t.setType(t.getClass().getName());
        }
        if (t.getDescription() == null) {
            t.setDescription("A " + t.getType());
        }
    }

    protected void setOracleHomeType(BaseSWComponent obj) {
        HAS has;
        OracleHome home = null;
        if (obj instanceof RACDBInstance) {
            logger.info("set home type to rac for rac db instance" + obj.getName());
            RACDBInstance racInst = (RACDBInstance)obj;
            home = racInst.getRuns_from();
            if (home != null) {
                home.setHomeType("rac");
            }
        } else if (obj instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)obj;
            home = sidb.getRuns_from();
            if (home != null && !"rac".equals(home.getHomeType())) {
                logger.info("set home type to sidb for sidb " + obj.getName());
                home.setHomeType("sidb");
            }
        } else if (obj instanceof HAS && (home = (has = (HAS)obj).getRuns_from()) != null) {
            logger.info("set home type to crs for has object " + obj.getName());
            home.setHomeType("crs");
        }
    }

    protected void setOracleHomeType(SystemInstance sys) {
        for (BaseClass obj : sys.getEntities()) {
            if (!(obj instanceof BaseSWComponent)) continue;
            this.setOracleHomeType((BaseSWComponent)obj);
            OracleHome home = ((BaseSWComponent)obj).getRuns_from();
            if (home == null) continue;
            ((BaseSWComponent)obj).setPlatform(home.getARUId());
        }
    }

    protected void setAndValidate(SystemInstance sys) {
        for (BaseClass obj : sys.getEntities()) {
            List<RACDBInstance> instances;
            this.defaultValues((AbstractBaseTarget)obj);
            if (this.guid == null) continue;
            if (obj instanceof CRSCluster) {
                this.crs = (CRSCluster)obj;
                sys.setTop((AbstractBaseTarget)this.crs);
            }
            if (obj instanceof ASMCluster) {
                if (this.asm != null) {
                    logger.severe(" More than one ASM cluster! ");
                } else {
                    this.asm = (ASMCluster)obj;
                }
            }
            if (obj instanceof HAS) {
                HAS has = (HAS)obj;
                this.allHAS.add(has);
                OracleHome giHome = has.getRuns_from();
                if (giHome == null) {
                    throw new RuntimeException("Invalid configuration: failed to find GI home for HAS " + has);
                }
            }
            if (obj instanceof RACDatabase) {
                this.allRAC.add((RACDatabase)obj);
            }
            if (obj instanceof SIDatabase) {
                this.allSIDB.add((SIDatabase)obj);
            }
            if (obj instanceof DBInstance) {
                this.allDBinstances.put(obj.getGUID(), (DBInstance)obj);
            }
            if (obj instanceof OracleHome) {
                this.allHomes.add((OracleHome)obj);
            }
            if (obj instanceof Host) {
                this.allHosts.add((Host)obj);
            }
            if (obj instanceof RACDBInstance) {
                RACDatabase rac = ((RACDBInstance)obj).getDbRAC();
                instances = this.racInstances.get(rac);
                if (instances == null) {
                    instances = new ArrayList<RACDBInstance>();
                    this.racInstances.put(rac, instances);
                }
                instances.add((RACDBInstance)obj);
            }
            if (obj instanceof ASMInstance) {
                ASMCluster asm = ((ASMInstance)obj).getASMcluster();
                instances = this.asmInstances.get(asm);
                if (instances == null) {
                    instances = new ArrayList<RACDBInstance>();
                    this.asmInstances.put(asm, instances);
                }
                instances.add((RACDBInstance)((ASMInstance)obj));
            }
            if (!(obj instanceof BaseSWComponent)) continue;
            this.setOracleHomeType((BaseSWComponent)obj);
            OracleHome home = ((BaseSWComponent)obj).getRuns_from();
            if (home == null) continue;
            ((BaseSWComponent)obj).setPlatform(home.getARUId());
        }
        if (this.crs == null && this.allHAS.size() == 1) {
            sys.setTop((AbstractBaseTarget)this.allHAS.get(0));
            OracleHome giHome = this.allHAS.get(0).getRuns_from();
            giHome.setHomeType("siha");
        }
        this.setHomeAttributes();
        this.setNodeNames();
        if (this.crs != null && this.guid != null) {
            this.addDBspecifics();
            this.buildDerivedAssociations();
        } else if (this.allHAS.size() == 1) {
            this.buildHASDerivedAssociations();
        } else if (this.guid != null) {
            throw new RuntimeException("This is neither a CRS Cluster configuration nor a SIHA configuration");
        }
    }

    protected void setHomeAttributes() {
        for (OracleHome home : this.allHomes) {
            home.setCentralInvPtr(home.getInventoryLocation());
        }
    }

    protected void setNodeNames() {
        if (this.crs == null && this.allHAS.size() <= 0) {
            throw new RuntimeException("failed to find CRS cluster or HAS GUID=" + this.guid);
        }
        for (Host host : this.allHosts) {
            if (host.getName() == null || host.getName().length() == 0) {
                logger.severe(" Host name is empty!!! " + host.toString());
                break;
            }
            String name = host.getName();
            host.setNodeName(name);
            int firstDot = name.indexOf(".");
            String nameWithoutDomain = name;
            String domainName = "";
            if (firstDot > 0) {
                nameWithoutDomain = name.substring(0, firstDot);
                domainName = name.substring(firstDot + 1, name.length());
            } else if (firstDot == 0) {
                logger.severe("Invalid host name=" + name);
            }
            host.setSimpleName(nameWithoutDomain);
            host.setNodeName(nameWithoutDomain);
            host.setHostName(nameWithoutDomain);
            host.setDomainName(domainName);
        }
        if (this.crs != null) {
            this.crs.setClusterName(this.crs.getName());
        }
    }

    protected void addDBspecifics() {
        ResultSet res = null;
        try {
            StringBuffer in = null;
            for (String guid : this.allDBinstances.keySet()) {
                if (in == null) {
                    in = new StringBuffer();
                } else {
                    in.append(",");
                }
                in.append("'").append(guid).append("'");
            }
            if (in == null) {
                return;
            }
            PreparedStatement st = this.getPrepareStatement(sqlDataVault);
            String str = in.toString();
            st.setString(1, str);
            res = this.executeQuery(st, sqlDataVault, str, null, null);
            while (res.next()) {
                DBInstance db = this.allDBinstances.get(res.getString(1));
                if (db == null) continue;
                db.setDataVault("1");
            }
            this.closeResultSet(res);
        }
        catch (SQLException e) {
            System.out.println("Failed to get DB instance data" + e.getMessage());
            logger.severe("Failed to get DB instance data" + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.closeResultSet(res);
        }
    }

    protected void buildHASDerivedAssociations() {
        HAS has = this.allHAS.get(0);
        for (int i = 0; i < this.allSIDB.size(); ++i) {
            SIDatabase sidb = this.allSIDB.get(i);
            sidb.setCRS(has);
        }
    }

    protected void setPrimaryAndStandbyDB(List<BaseClass> listFetched) {
        for (BaseClass instance : listFetched) {
            List<Object> secondarys;
            String dataGuardStatus = null;
            DB db = null;
            String dbName = null;
            if (instance instanceof RACDatabase) {
                RACDatabase racDB = (RACDatabase)instance;
                dbName = racDB.getName();
                db = racDB.getDBsystemInterface();
                db.setName(dbName);
                dataGuardStatus = racDB.getDataguardStatus();
            }
            if (instance instanceof SIDatabase) {
                SIDatabase siDB = (SIDatabase)instance;
                dbName = siDB.getName();
                db = siDB.getDBsystemInterface();
                db.setName(dbName);
                dataGuardStatus = siDB.getDataguardStatus();
            }
            if (dataGuardStatus == null) continue;
            if (dataGuardStatus.equalsIgnoreCase("primary")) {
                db.setSecondary(this.fetchStandbyDBForPrimary(dbName));
                db.setPrimary(db);
                for (DB secondaryDB : db.getSecondary()) {
                    secondaryDB.setPrimary(db);
                }
                if (db.getSecondary() == null || db.getSecondary().size() == 0) continue;
                db.setUsingDataGuardBroker(((DB)db.getSecondary().get(0)).getUsingDataGuardBroker());
                continue;
            }
            if (!dataGuardStatus.toLowerCase().contains("standby")) continue;
            db.setPrimary(this.fetchPrimaryDBForStandby(dbName));
            DB primaryDB = db.getPrimary();
            if (primaryDB == null) continue;
            if (primaryDB.getSecondary() == null) {
                secondarys = new ArrayList();
                primaryDB.setSecondary(secondarys);
            }
            primaryDB.getSecondary().add(db);
            secondarys = this.fetchStandbyDBForPrimaryExcludeCurrrentStandby(primaryDB.getName(), db.getName());
            for (DB dB : secondarys) {
                primaryDB.getSecondary().add(dB);
            }
            db.setUsingDataGuardBroker(primaryDB.getUsingDataGuardBroker());
        }
    }

    protected String[] fetchStandbyDBNamesForPrimary(String dbName) {
        ResultSet res;
        String[] standbyList;
        block5: {
            standbyList = null;
            res = null;
            String sql = "SELECT /*sqlStandbyListInDGWithPrimary*/ dg.stby_list FROM SYSMAN.MGMT$HA_DG_TARGET_SUMMARY dg, SYSMAN.MGMT_TARGETS tgt WHERE dg.target_guid=tgt.target_guid AND (tgt.target_type='oracle_database' or  tgt.target_type='rac_database') AND tgt.target_name=? AND dg.role='PRIMARY'";
            PreparedStatement st = this.getPrepareStatement(sql);
            st.setString(1, dbName);
            res = this.executeQuery(st, sql, dbName, null, null);
            if (res.next()) break block5;
            String[] stringArray = standbyList;
            this.closeResultSet(res);
            return stringArray;
        }
        try {
            String standby = res.getString(1);
            logger.info("The standby database names are" + standby);
            standbyList = standby.indexOf(",") != -1 ? standby.split(",") : new String[]{standby};
        }
        catch (SQLException e) {
            try {
                logger.severe("Failed to get standby database for primary database " + dbName);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(res);
                throw throwable;
            }
        }
        this.closeResultSet(res);
        return standbyList;
    }

    protected List<DB> fetchStandbyDBForPrimary(String dbName) {
        ArrayList<DB> standbyDBs = new ArrayList<DB>();
        String[] standbyList = this.fetchStandbyDBNamesForPrimary(dbName);
        if (standbyList != null) {
            for (int i = 0; i < standbyList.length; ++i) {
                DB standbyDB = this.fecthDBInDataGuardbyDBName(standbyList[i]);
                standbyDBs.add(standbyDB);
                logger.info("Fetch standby database " + ((DB)standbyDBs.get(standbyDBs.size() - 1)).getName() + " for primary database " + dbName);
            }
        }
        return standbyDBs;
    }

    protected List<DB> fetchStandbyDBForPrimaryExcludeCurrrentStandby(String dbName, String curStandby) {
        ArrayList<DB> standbyDBs = new ArrayList<DB>();
        String[] standbyList = this.fetchStandbyDBNamesForPrimary(dbName);
        if (standbyList != null) {
            for (int i = 0; i < standbyList.length; ++i) {
                if (curStandby.equalsIgnoreCase(standbyList[i])) continue;
                DB standbyDB = this.fecthDBInDataGuardbyDBName(standbyList[i]);
                standbyDBs.add(standbyDB);
                logger.severe("Fetch standby database " + ((DB)standbyDBs.get(standbyDBs.size() - 1)).getName() + " for primary database " + dbName);
            }
        }
        return standbyDBs;
    }

    protected DB fecthDBInDataGuardbyDBName(String dbName) {
        DB dB;
        ResultSet res;
        block10: {
            res = null;
            String sql = "SELECT /*sqlDatabaseInDGWithDBName*/ target_guid, using_broker, active_stby  FROM SYSMAN.MGMT$HA_DG_TARGET_SUMMARY WHERE db_unique_name=?";
            PreparedStatement st = this.getPrepareStatement(sql);
            st.setString(1, dbName);
            res = this.executeQuery(st, sql, dbName, null, null);
            if (res.next()) break block10;
            DB dB2 = null;
            this.closeResultSet(res);
            return dB2;
        }
        try {
            SystemInstance dbSI;
            String target_guid = res.getString(1);
            DB db = new DB();
            db.setGUID(target_guid);
            String dbType = this.getDBType(target_guid);
            if (dbType.equals("rac_database")) {
                this.emGeneric = new EMRepoDriver(this.connection);
                dbSI = this.emGeneric.getSystemInstances(this.requestRACDatabase(target_guid), this.requestedAssociations, this.properySetters);
                RACDatabase racDB = (RACDatabase)this.getTargetFromSystemInstanceByGuid(target_guid, dbSI);
                racDB.setType(racDB.getClass().getName());
                db.setRAC(racDB);
                db.setName(racDB.getName());
                racDB.setDBsystemInterface(db);
                this.setOracleHomeType(dbSI);
            } else if (dbType.equals("oracle_database")) {
                this.emGeneric = new EMRepoDriver(this.connection);
                dbSI = this.emGeneric.getSystemInstances(this.requestSIDatabase(target_guid), this.requestedAssociations, this.properySetters);
                SIDatabase siDB = (SIDatabase)this.getTargetFromSystemInstanceByGuid(target_guid, dbSI);
                siDB.setType(siDB.getClass().getName());
                db.setSI(siDB);
                db.setName(siDB.getName());
                siDB.setDBsystemInterface(db);
                this.setOracleHomeType(dbSI);
            }
            String usingBroker = res.getString(2);
            if (usingBroker.equalsIgnoreCase("yes")) {
                db.setUsingDataGuardBroker(true);
            } else {
                db.setUsingDataGuardBroker(false);
            }
            dB = db;
        }
        catch (SQLException e) {
            try {
                logger.severe("Failed to get database" + dbName);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(res);
                throw throwable;
            }
        }
        this.closeResultSet(res);
        return dB;
    }

    protected AbstractBaseTarget getTargetFromSystemInstanceByGuid(String guid, SystemInstance si) {
        List entities = si.getEntities();
        for (BaseClass entity : entities) {
            if (!guid.equals(entity.getGUID())) continue;
            return (AbstractBaseTarget)entity;
        }
        throw new RuntimeException("can not found target with guid " + guid + " in specified systeminstance");
    }

    protected String getDBType(String target_guid) {
        String string;
        ResultSet res;
        block5: {
            res = null;
            String sql = "SELECT /*sqlTargetTypeByGuid*/ TARGET_TYPE FROM SYSMAN.MGMT_TARGETS WHERE TARGET_GUID = ?";
            PreparedStatement st = this.getPrepareStatement(sql);
            st.setString(1, target_guid);
            res = this.executeQuery(st, sql, target_guid, null, null);
            if (res.next()) break block5;
            String string2 = null;
            this.closeResultSet(res);
            return string2;
        }
        try {
            String target_type;
            string = target_type = res.getString(1);
        }
        catch (SQLException e) {
            try {
                logger.severe("Failed to get database type for target" + target_guid);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(res);
                throw throwable;
            }
        }
        this.closeResultSet(res);
        return string;
    }

    protected DB fetchPrimaryDBForStandby(String dbName) {
        DB dB;
        DB primaryDB = null;
        ResultSet res = null;
        try {
            String sql = "SELECT /*sqlPrimaryWithStandby*/ dg1.prmy_db_unique_name FROM SYSMAN.MGMT$HA_DG_TARGET_SUMMARY dg1, SYSMAN.MGMT_TARGETS tgt1 WHERE dg1.target_guid=tgt1.target_guid AND (tgt1.target_type='oracle_database' or  tgt1.target_type='rac_database') AND tgt1.target_name=? AND (dg1.role='PHYSICAL STANDBY' OR dg1.role='LOGICAL STANDBY')";
            PreparedStatement st = this.getPrepareStatement(sql);
            st.setString(1, dbName);
            res = this.executeQuery(st, sql, dbName, null, null);
            if (!res.next()) {
                throw new RuntimeException("Can not found primary database for current standby database " + dbName);
            }
            String primaryDBName = res.getString(1);
            primaryDB = this.fecthDBInDataGuardbyDBName(primaryDBName);
            logger.info("Fetch primary database " + primaryDBName + " for standby database " + dbName);
            dB = primaryDB;
        }
        catch (SQLException e) {
            try {
                logger.severe("Failed to get primary database of standby database " + dbName);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(res);
                throw throwable;
            }
        }
        this.closeResultSet(res);
        return dB;
    }

    protected void buildDerivedAssociations() {
        if (this.crs == null) {
            logger.severe(" Missing CRS cluster! ");
            return;
        }
        if (this.allHAS.isEmpty()) {
            logger.severe(" Has to be at least one HAS in CRS cluster! ");
        }
        this.crs.setHAS(this.allHAS);
        for (HAS has : this.allHAS) {
            has.setCluster(this.crs);
            String role = has.getNodeRole();
            if (role != null && role.trim().length() != 0) continue;
            has.setNodeRole("na");
        }
        if (this.asm == null) {
            logger.severe(" Missing ASM cluster! ");
        }
        this.crs.setASMCluster(this.asm);
        if (this.allRAC.isEmpty() && this.allSIDB.isEmpty()) {
            logger.severe(" Should be there at least one database in CRS cluster? ");
        }
        this.crs.setDbRAC(this.allRAC);
        this.crs.setDbSI(this.allSIDB);
        for (Host host : this.allHosts) {
            if (host.getDbmMember() != null && host.getDbmMember().booleanValue()) {
                this.crs.setHWtype("EXADATA");
            }
            HAS has = null;
            ArrayList<HAS> hass = new ArrayList<HAS>();
            ArrayList<DBInstance> insts = new ArrayList<DBInstance>();
            for (BaseSWComponent comp : host.getSWComponents()) {
                if (comp instanceof HAS) {
                    hass.add((HAS)comp);
                }
                if (!(comp instanceof RACDBInstance)) continue;
                insts.add((DBInstance)comp);
            }
            if (hass.size() == 0) {
                logger.severe(" There is no HAS on the host! " + host.toString());
            } else {
                has = (HAS)hass.get(0);
                if (hass.size() > 1) {
                    logger.severe(" More than one HAS on the host! " + host.toString() + " setting rac instance to HAS for only one");
                }
            }
            if (has == null) continue;
            for (DBInstance inst : insts) {
                inst.setCRS(has);
            }
            has.setDBInstance(insts);
        }
        for (RACDatabase rac : this.racInstances.keySet()) {
            rac.setDbInstances(this.racInstances.get(rac));
        }
        for (ASMCluster asm : this.asmInstances.keySet()) {
            if (asm == null) continue;
            asm.setASMinstances(this.asmInstances.get(asm));
        }
    }

    protected void propertyMapping() {
        HashMap<String, String> properyMapping = new HashMap<String, String>();
        properyMapping.put("DATAGUARDSTATUS", "setDataguardStatus");
        properyMapping.put("ORACLEHOME", "setOracleHome");
        properyMapping.put("DBNAME", "setDatabaseName");
        properyMapping.put("VERSION", "setVersion");
        properyMapping.put("SID", "setSID");
        properyMapping.put("INSTANCENAME", "setInstanceName");
        this.requestProperties(properyMapping, (BaseClass)new SIDatabase());
        properyMapping = new HashMap();
        properyMapping.put("INSTANCENAME", "setInstanceName");
        properyMapping.put("DBNAME", "setDatabaseName");
        properyMapping.put("MACHINENAME", "setMachineName");
        properyMapping.put("ORACLEHOME", "setOracleHome");
        properyMapping.put("SID", "setSID");
        properyMapping.put("SERVICENAME", "setServiceName");
        properyMapping.put("ADRBASE", "setAdrBase");
        properyMapping.put("ADRHOME", "setAdrHome");
        properyMapping.put("PORT", "setPort");
        properyMapping.put("DBVERSION", "setVersion");
        this.requestProperties(properyMapping, (BaseClass)new RACDBInstance());
        this.requestProperties(properyMapping, (BaseClass)new DBInstance());
        properyMapping = new HashMap();
        properyMapping.put("CRSVERSION", "setVersion");
        properyMapping.put("ORACLEHOME", "setOracleHome");
        this.requestProperties(properyMapping, (BaseClass)new CRSCluster());
        properyMapping = new HashMap();
        properyMapping.put("CRSVERSION", "setVersion");
        properyMapping.put("ORACLEHOME", "setOracleHome");
        properyMapping.put("NODENAME", "setNodeName");
        properyMapping.put("CLUSTERNAME", "setClusterName");
        properyMapping.put("ACTIVENODEROLE", "setNodeRole");
        this.requestProperties(properyMapping, (BaseClass)new HAS());
        properyMapping = new HashMap();
        properyMapping.put("OS", "setOS");
        properyMapping.put("PLATFORM", "setPlatform");
        properyMapping.put("VERSION", "setVersion");
        this.requestProperties(properyMapping, (BaseClass)new Host());
        properyMapping = new HashMap();
        properyMapping.put("ORACLE_BASE", "setOracleBaseLocation");
        properyMapping.put("ARU_ID", "setARUId");
        properyMapping.put("HOME_TYPE", "setHomeType");
        properyMapping.put("INSTALL_LOCATION", "setPath");
        this.requestProperties(properyMapping, (BaseClass)new OracleHome());
        properyMapping = new HashMap();
        properyMapping.put("ORACLEHOME", "setOracleHome");
        properyMapping.put("PORT", "setPort");
        properyMapping.put("MACHINE", "setMachine");
        properyMapping.put("LSNR_VERSION", "setVersion");
        this.requestProperties(properyMapping, (BaseClass)new OracleListener());
        properyMapping = new HashMap();
        properyMapping.put("ORACLEHOME", "setOracleHome");
        properyMapping.put("DBVERSION", "setVersion");
        this.requestProperties(properyMapping, (BaseClass)new ASMInstance());
        properyMapping = new HashMap();
        properyMapping.put("ORACLEHOME", "setOracleHome");
        properyMapping.put("DBNAME", "setDatabaseName");
        properyMapping.put("VERSION", "setVersion");
        properyMapping.put("DATAGUARDSTATUS", "setDataguardStatus");
        this.requestProperties(properyMapping, (BaseClass)new RACDatabase());
    }

    public AbstractBaseTarget requestRACDatabase(String guid) {
        RACDatabase rac = new RACDatabase();
        rac.setGUID(guid);
        RACDBInstance racInstance = new RACDBInstance();
        racInstance.setDbRAC(rac);
        ArrayList<PDB> pdbs = new ArrayList<PDB>();
        pdbs.add(new PDB());
        rac.setPDB(pdbs);
        ArrayList<RACDBInstance> racInsts = new ArrayList<RACDBInstance>();
        racInsts.add(racInstance);
        rac.setDbInstances(racInsts);
        SIDatabase sidb = new SIDatabase();
        sidb.setPDB(pdbs);
        OracleListener li = new OracleListener();
        ArrayList<Object> instances = new ArrayList<Object>();
        instances.add(racInstance);
        instances.add(sidb);
        instances.add(li);
        this.addRequested((BaseClass)sidb);
        this.addRequested((BaseClass)rac);
        this.addRequested((BaseClass)li);
        return rac;
    }

    public AbstractBaseTarget requestSIDatabase(String guid) {
        SIDatabase sidb = new SIDatabase();
        ArrayList<PDB> pdbs = new ArrayList<PDB>();
        pdbs.add(new PDB());
        sidb.setPDB(pdbs);
        OracleListener li = new OracleListener();
        ArrayList<Object> instances = new ArrayList<Object>();
        instances.add(sidb);
        instances.add(li);
        this.addRequested((BaseClass)sidb);
        this.addRequested((BaseClass)li);
        return sidb;
    }

    public AbstractBaseTarget requestHASObj(String guid) {
        HAS has = new HAS();
        has.setGUID(guid);
        ArrayList<ASMInstance> asmInstances = new ArrayList<ASMInstance>();
        ASMInstance asmInstance = new ASMInstance();
        asmInstances.add(asmInstance);
        has.setInstanceASM(asmInstances);
        ArrayList<SIDatabase> dbInstances = new ArrayList<SIDatabase>();
        SIDatabase sidb = new SIDatabase();
        ArrayList<PDB> pdbs = new ArrayList<PDB>();
        pdbs.add(new PDB());
        sidb.setPDB(pdbs);
        dbInstances.add(sidb);
        has.setDBInstance(dbInstances);
        Host host = new Host();
        has.setHost(host);
        ArrayList<OracleListener> lis = new ArrayList<OracleListener>();
        OracleListener li = new OracleListener();
        lis.add(li);
        has.setListeners(lis);
        ArrayList<Object> instances = new ArrayList<Object>();
        instances.add(has);
        instances.add(asmInstance);
        instances.add(sidb);
        instances.add(li);
        host.setSWComponents(instances);
        this.addRequested((BaseClass)has);
        this.addRequested((BaseClass)host);
        this.addRequested((BaseClass)asmInstance);
        this.addRequested((BaseClass)sidb);
        this.addRequested((BaseClass)li);
        return has;
    }

    public AbstractBaseTarget requestClusterObj(String guid) {
        CRSCluster crs = new CRSCluster();
        crs.setGUID(guid);
        Host host = new Host();
        ArrayList<Host> hosts = new ArrayList<Host>();
        hosts.add(host);
        crs.setNodes(hosts);
        HAS has = new HAS();
        has.setHost(host);
        ArrayList<HAS> hass = new ArrayList<HAS>();
        hass.add(has);
        crs.setHAS(hass);
        has.setCluster(crs);
        RACDBInstance racInstance = new RACDBInstance();
        RACDatabase rac = new RACDatabase();
        racInstance.setDbRAC(rac);
        ArrayList<PDB> pdbs = new ArrayList<PDB>();
        pdbs.add(new PDB());
        rac.setPDB(pdbs);
        ArrayList<RACDBInstance> racInsts = new ArrayList<RACDBInstance>();
        racInsts.add(racInstance);
        rac.setDbInstances(racInsts);
        ASMInstance asmInstance = new ASMInstance();
        ASMCluster asmCluster = new ASMCluster();
        asmInstance.setASMcluster(asmCluster);
        SIDatabase sidb = new SIDatabase();
        sidb.setPDB(pdbs);
        OracleListener li = new OracleListener();
        ArrayList<Object> instances = new ArrayList<Object>();
        instances.add(has);
        instances.add(racInstance);
        instances.add(asmInstance);
        instances.add(sidb);
        instances.add(li);
        host.setSWComponents(instances);
        this.addRequested((BaseClass)crs);
        this.addRequested((BaseClass)host);
        this.addRequested((BaseClass)has);
        this.addRequested((BaseClass)racInstance);
        this.addRequested((BaseClass)asmInstance);
        this.addRequested((BaseClass)rac);
        this.addRequested((BaseClass)asmCluster);
        this.addRequested((BaseClass)sidb);
        this.addRequested((BaseClass)li);
        return crs;
    }

    public AbstractBaseTarget requestObj(String guid) {
        String targetType = this.getTargetType(guid);
        if (targetType.equals("has")) {
            return this.requestHASObj(guid);
        }
        if (targetType.equals("cluster")) {
            return this.requestClusterObj(guid);
        }
        logger.severe("Current target type is: " + targetType + " which is not support by oplan. The target type of input target guid should be has or cluster.");
        throw new RuntimeException("Current target type is: " + targetType + " which is not support by oplan. The target type of input target guid should be has or cluster.");
    }

    protected String getTargetType(String target_guid) {
        String string;
        ResultSet res;
        block5: {
            res = null;
            String sql = "SELECT /*sqlTargetTypeByGuid*/ TARGET_TYPE FROM SYSMAN.MGMT_TARGETS WHERE TARGET_GUID = ?";
            PreparedStatement st = this.getPrepareStatement(sql);
            st.setString(1, target_guid);
            res = this.executeQuery(st, sql, target_guid, null, null);
            if (res.next()) break block5;
            String string2 = null;
            this.closeResultSet(res);
            return string2;
        }
        try {
            String target_type;
            string = target_type = res.getString(1);
        }
        catch (SQLException e) {
            try {
                logger.severe("Failed to get database type for target" + target_guid);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(res);
                throw throwable;
            }
        }
        this.closeResultSet(res);
        return string;
    }

    protected PreparedStatement getPrepareStatement(String sql) throws SQLException {
        PreparedStatement st;
        if (this.sqlToSt.get(sql) != null) {
            st = (PreparedStatement)this.sqlToSt.get(sql);
        } else {
            st = this.connection.prepareStatement(sql);
            this.sqlToSt.put(sql, st);
        }
        return st;
    }

    public static void main(String[] args) {
        ArrayList<String> guids = new ArrayList<String>();
        String clusterGuid = "320C91C0BAA49B713F342364EDCAD9CE";
        String connectionString = "slc05nwe.us.oracle.com:11120:s05nwe";
        String outDir = "/tmp";
        String user = "sysman";
        String password = "sysman";
        if (args != null && args.length > 0) {
            outDir = args[0];
            if (args.length > 1) {
                clusterGuid = args[1];
            }
            if (args.length > 2) {
                connectionString = args[2];
            }
            if (args.length > 3) {
                user = args[3];
            }
            if (args.length > 4) {
                password = args[4];
            }
        }
        if (clusterGuid != null) {
            guids.add(clusterGuid);
        }
        try {
            Iterator iterator = guids.iterator();
            while (iterator.hasNext()) {
                CRSEMProductDriver pd = new CRSEMProductDriver(connectionString, user, password);
                String guid = (String)iterator.next();
                SystemInstance sys = pd.buildConfigGraph(guid);
                String name = sys != null && sys.getTop() != null ? sys.getTop().getName() : guid;
                File file = outDir != null ? new File(outDir, name + "_config.xml") : new File(name + "_config.xml");
                sys.writeFile(file);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SystemInstance getProductSystemInstance(List<BaseClass> all, AbstractBaseTarget top) {
        return new SystemInstance(all, top);
    }
}

