/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cookies;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.common.OracleHome;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.cookies.CloneCookie;
import oracle.oplan.sdk.cookies.MakeCloneHome;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.osysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSMakeCloneHome
extends MakeCloneHome {
    final Logger logger = Logger.getLogger(CRSMakeCloneHome.class.getName());

    @Deprecated
    public CRSMakeCloneHome(ProductDriver pd, ConfigGraph cg) {
        super(pd, cg);
    }

    public CRSMakeCloneHome(ConfigGraph cg, LocalInfo localInfo) {
        super(cg, localInfo);
    }

    public List<OracleHome> getHomeClone(OracleHome oh) {
        if (this.cloneMap.containsKey(oh)) {
            return (List)this.cloneMap.get(oh);
        }
        this.logger.info("Creating clone of " + oh.getPath());
        ArrayList<OracleHome> cloneHomes = new ArrayList();
        boolean racCloneCookieExist = false;
        boolean sidbCloneCookieExist = false;
        if (oh.getHomeType().equals(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString())) {
            for (RACDatabase racDB : this.graph.getTargets(RACDatabase.class)) {
                if (!oh.getPath().equals(racDB.getOracleHome()) || racDB.getProperty(CloneCookie.class) == null) continue;
                if (((CloneCookie)racDB.getProperty(CloneCookie.class)).getClonePath() == null) {
                    throw new ProductDriverException("CloneCookie should not be set with a null clone path.");
                }
                this.addCloneHome(cloneHomes, oh, ((CloneCookie)racDB.getProperty(CloneCookie.class)).getCloneName(), ((CloneCookie)racDB.getProperty(CloneCookie.class)).getClonePath(), ((CloneCookie)racDB.getProperty(CloneCookie.class)).getCloneOracleBaseLocation());
                racCloneCookieExist = true;
            }
        } else if (oh.getHomeType().equals(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.sidb.toString())) {
            for (SIDatabase siDB : this.graph.getTargets(SIDatabase.class)) {
                if (!oh.getPath().equals(siDB.getRuns_from().getPath()) || siDB.getProperty(CloneCookie.class) == null) continue;
                if (((CloneCookie)siDB.getProperty(CloneCookie.class)).getClonePath() == null) {
                    throw new ProductDriverException("CloneCookie should not be set with a null clone path.");
                }
                this.addCloneHome(cloneHomes, oh, ((CloneCookie)siDB.getProperty(CloneCookie.class)).getCloneName(), ((CloneCookie)siDB.getProperty(CloneCookie.class)).getClonePath(), ((CloneCookie)siDB.getProperty(CloneCookie.class)).getCloneOracleBaseLocation());
                sidbCloneCookieExist = true;
            }
        }
        if (!racCloneCookieExist || !sidbCloneCookieExist) {
            cloneHomes = super.getHomeClone(oh);
        }
        this.cloneMap.put(oh, cloneHomes);
        return cloneHomes;
    }

    public String getClonePathforSIDB(SIDatabase sidb, OracleHome oh) {
        String clonePath = null;
        clonePath = sidb.getProperty(CloneCookie.class) != null ? ((CloneCookie)sidb.getProperty(CloneCookie.class)).getClonePath() : (oh.getProperty(CloneCookie.class) != null ? ((CloneCookie)oh.getProperty(CloneCookie.class)).getClonePath() : this.subCloneHomeDir(oh.getPath()));
        return clonePath;
    }

    public String getClonePathforRAC(RACDatabase racDB, OracleHome oh) {
        String clonePath = null;
        clonePath = racDB.getProperty(CloneCookie.class) != null ? ((CloneCookie)racDB.getProperty(CloneCookie.class)).getClonePath() : (oh.getProperty(CloneCookie.class) != null ? ((CloneCookie)oh.getProperty(CloneCookie.class)).getClonePath() : this.subCloneHomeDir(oh.getPath()));
        return clonePath;
    }
}

