/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.db_crs.DB;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopStartLogShipping
extends Command {
    static Logger logger = Logger.getLogger(StopStartLogShipping.class.getName());
    private final CRSCommandActionType type;
    private final Strategy strat;

    public StopStartLogShipping(ActionType automationAction, CRSCommandActionType type, Strategy strat) {
        super(automationAction);
        assert (CRSCommandActionType.StartLogShipping.equals((Object)type) || CRSCommandActionType.StopLogShipping.equals((Object)type));
        this.type = type;
        this.strat = strat;
    }

    private List<ExecutionStep.Command> getLogShippingCommand(ExecutionStep es, boolean usingBorker, AbstractBaseTarget primary) {
        String cmd;
        ArrayList<ExecutionStep.Command> executionCmds = new ArrayList<ExecutionStep.Command>();
        String dbName = null;
        OracleHome oracleHome = null;
        if (primary instanceof SIDatabase) {
            logger.info("The Primary database is SI database");
            SIDatabase siDB = (SIDatabase)primary;
            oracleHome = siDB.getRuns_from();
            dbName = siDB.getName();
        } else if (primary instanceof RACDatabase) {
            logger.info("The Primary database is RAC database");
            RACDatabase racDB = (RACDatabase)primary;
            dbName = racDB.getName();
            List racInsts = racDB.getDbInstances();
            if (racInsts != null && racInsts.size() > 0) {
                oracleHome = ((RACDBInstance)racInsts.get(0)).getRuns_from();
            }
        } else {
            logger.info("Target is not database");
        }
        String OracleSid = DBCommandUtils.getOracleSID(es, primary);
        if (usingBorker) {
            logger.info("Data guard broker is configed");
            cmd = "ORACLE_HOME=" + oracleHome.getPath() + " ORACLE_SID=" + OracleSid + " " + oracleHome.getPath() + "/bin/dgmgrl /";
            executionCmds.add(new ExecutionStep.Command(cmd));
            String dgmgrlCommand = "";
            if (CRSCommandActionType.StopLogShipping.equals((Object)this.type)) {
                dgmgrlCommand = "edit database " + dbName + " set state='LOG-TRANSPORT-OFF';";
            } else if (CRSCommandActionType.StartLogShipping.equals((Object)this.type)) {
                dgmgrlCommand = "edit database " + dbName + " set state='ONLINE';";
            }
            ExecutionStep.Command dgmgrlCmd = new ExecutionStep.Command(dgmgrlCommand, ExecutionStep.Command.CommandType.DGMGRL);
            executionCmds.add(dgmgrlCmd);
        } else {
            logger.info("Data guard broker have not been configed");
            cmd = "ORACLE_HOME=" + oracleHome.getPath() + " ORACLE_SID=" + OracleSid + " " + oracleHome.getPath() + "/bin/sqlplus / as sysdba";
            executionCmds.add(new ExecutionStep.Command(cmd));
            String sqlCommand = "";
            if (CRSCommandActionType.StopLogShipping.equals((Object)this.type)) {
                sqlCommand = "alter system set log_archive_dest_state_2=defer scope=both;";
            } else if (CRSCommandActionType.StartLogShipping.equals((Object)this.type)) {
                sqlCommand = "alter system set log_archive_dest_state_2=enable scope=both;";
            }
            ExecutionStep.Command sqlCmd = new ExecutionStep.Command(sqlCommand, ExecutionStep.Command.CommandType.SQL);
            executionCmds.add(sqlCmd);
        }
        return executionCmds;
    }

    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            List secondaryDB;
            assert (abstractBaseTarget instanceof RACDatabase);
            if (!(abstractBaseTarget instanceof RACDatabase)) {
                throw new OPlanException("StopStartlogshipping action can act only on RACDBInstance, but found: " + abstractBaseTarget.getClass().getName());
            }
            RACDatabase db = (RACDatabase)abstractBaseTarget;
            CommandContext cc = contextPopulator.populateContext(g, abstractBaseTarget);
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(cc);
            }
            if (db.getDataguardStatus() != null && db.getDataguardStatus().toLowerCase().contains("standby")) {
                logger.info("Current Database is a standby database with dataguardstatus value " + db.getDataguardStatus());
                ExecutionStep es = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)cc, null);
                DB primaryDB = db.getDBsystemInterface().getPrimary();
                if (primaryDB.getRAC() != null) {
                    es.getCommand().addAll(this.getLogShippingCommand(es, primaryDB.getUsingDataGuardBroker(), (AbstractBaseTarget)primaryDB.getRAC()));
                    es.setHost(((RACDBInstance)primaryDB.getRAC().getDbInstances().get(0)).getHost());
                    steps.add(es);
                    logger.info("Change host to host of primary database " + ((RACDBInstance)primaryDB.getRAC().getDbInstances().get(0)).getHost().getName());
                    continue;
                }
                if (primaryDB.getSI() == null) continue;
                es.getCommand().addAll(this.getLogShippingCommand(es, primaryDB.getUsingDataGuardBroker(), (AbstractBaseTarget)primaryDB.getSI()));
                es.setHost(primaryDB.getSI().getHost());
                steps.add(es);
                continue;
            }
            if (db.getDataguardStatus() == null || !db.getDataguardStatus().toLowerCase().contains("primary") || (secondaryDB = db.getDBsystemInterface().getSecondary()) == null || secondaryDB.size() <= 0) continue;
            logger.info("Current Database is a primary database with dataguardstatus value " + db.getDataguardStatus());
            ExecutionStep es = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)cc, null);
            es.getCommand().addAll(this.getLogShippingCommand(es, db.getDBsystemInterface().getUsingDataGuardBroker(), (AbstractBaseTarget)db));
            steps.add(es);
        }
        return steps;
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class type = SystemModelUtils.getClassForType((String)this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (a instanceof CommandAction && (a.getType().equals(CRSCommandActionType.StartLogShipping.toString()) || a.getType().equals(CRSCommandActionType.StopLogShipping.toString()))) {
                logger.info(" crate stop start log shipping command" + a.getType());
                return new StopStartLogShipping(a, CRSCommandActionType.valueOf(a.getType()), s);
            }
            return null;
        }
    }
}

