/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.Command;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.cmdtranslator.SqlCommandUtils;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.db.cookies.CRSMakeCloneHome;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlPatchCommand
extends oracle.oplan.sdk.cmdtranslator.Command {
    private static final String ohOption = "-oh";
    CommandAction automationAction;
    Logger logger = Logger.getLogger(SqlPatchCommand.class.getName());

    public SqlPatchCommand(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep executionStep;
            CommandContext context = contextPopulator.populateContext(g, abstractBaseTarget);
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
            }
            if ((executionStep = this.getExecutionStep(context)) == null) continue;
            steps.add(executionStep);
        }
        return steps;
    }

    private ExecutionStep getExecutionStep(CommandContext context) {
        List patches;
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget db = context.getPrimaryTarget();
        if (DBCommandUtils.shouldExecuteSqlCommand(db, patches = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType((String)CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString())), (ActionType)this.automationAction)) {
            if (DBCommandUtils.isPhysicalStandbyDatabase(db)) {
                context = DBCommandUtils.resetContextForStandbyDB(db);
                oh = (OracleHome)context.getFirstTarget(OracleHome.class);
                db = context.getPrimaryTarget();
            }
            ExecutionStep executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)context, null);
            if (this.automationAction.isActsOnClone() && DBCommandUtils.isRemoteDB(db)) {
                this.logger.info("Current step is running on remote db " + db.getDisplayName() + ". Set acts_on_clone property to null");
                executionStep.getAutomationAction().setActsOnClone(null);
            }
            ArrayList<String> cmds = new ArrayList<String>();
            StringBuilder cmd = new StringBuilder();
            String oracleSid = SqlCommandUtils.getOracleSIDForActiveInstance(executionStep, db);
            if (db instanceof SIDatabase || db instanceof RACDatabase) {
                cmd.append("ORACLE_HOME=" + oh.getPath() + " ORACLE_SID=" + oracleSid + " " + oh.getPath() + "/OPatch/datapatch");
            }
            List automationCommands = this.automationAction.getCommand();
            for (Command c : automationCommands) {
                for (String param : c.getParameter()) {
                    if (!ohOption.equalsIgnoreCase(param) || DBCommandUtils.isRemoteDB(context.getPrimaryTarget())) continue;
                    cmd.append(" ").append(ohOption).append(" ").append(this.getCloneHome(context));
                }
            }
            cmds.add(cmd.toString());
            for (String s : cmds) {
                executionStep.getCommand().add(new ExecutionStep.Command(s));
            }
            return executionStep;
        }
        return null;
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class type = SystemModelUtils.getClassForType((String)this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    private String getCloneHome(CommandContext context) {
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget db = context.getPrimaryTarget();
        String clonePath = null;
        if (db instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)db;
            clonePath = ((CRSMakeCloneHome)OPlan.getInstance().getMakeCloneHome()).getClonePathforRAC(racDB, oh);
        } else if (db instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)db;
            clonePath = ((CRSMakeCloneHome)OPlan.getInstance().getMakeCloneHome()).getClonePathforSIDB(siDB, oh);
        }
        return clonePath;
    }

    public static class Builder
    implements CommandBuilder {
        public oracle.oplan.sdk.cmdtranslator.Command getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction && (a.getType().equals(CRSCommandActionType.SqlPatch.toString()) || a.getType().equals(CRSCommandActionType.SqlPatchApply.toString()) || a.getType().equals(CRSCommandActionType.SqlPatchRollback.toString()) || a.getType().equals(CRSCommandActionType.SqlPatchSwitchback.toString()) || a.getType().equals(CRSCommandActionType.SqlPatchRestore.toString())))) {
                return null;
            }
            return new SqlPatchCommand((CommandAction)a);
        }
    }
}

