/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.patchmodel.GenericPatch;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.OpatchAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.OPatchRollbackCommand;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollbackOnlyRACDBHomeCommand
extends OPatchRollbackCommand {
    private List<String> preScript;
    private List<String> postScript;

    public RollbackOnlyRACDBHomeCommand(ActionType automationAction, Strategy s) {
        super(automationAction, s);
        this.s = s;
    }

    public List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        List<Object> steps = new ArrayList<ExecutionStep>();
        if (!DBCommandUtils.isGIPatchingRequested()) {
            for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
                this.preScript = this.createPrePostScript(g, abstractBaseTarget, "prepatch.sh");
                this.postScript = this.createPrePostScript(g, abstractBaseTarget, "postpatch.sh");
            }
            steps = super.generateExecutionSteps(g, actsOnlyOnTargets);
        }
        return steps;
    }

    private List<String> createPrePostScript(ConfigGraph g, AbstractBaseTarget t, String fileName) {
        ArrayList<String> filePath = new ArrayList<String>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        CommandContext context = contextPopulator.populateContext(g, t);
        if (this.automationAction.isActsOnClone()) {
            contextPopulator.fixCloneContext(context);
        }
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        List<GenericPatch> patches = this.getPatches(oh);
        for (GenericPatch patch : patches) {
            Logger.getLogger(RollbackOnlyRACDBHomeCommand.class.getName()).info("PatchRoot: " + patch.getPatchLocation());
            String path = patch.getPatchLocation() + "/custom/scripts/" + fileName;
            File f = new File(path);
            if (!f.exists() || f.isDirectory()) continue;
            filePath.add(path);
            Logger.getLogger(RollbackOnlyRACDBHomeCommand.class.getName()).info("path: " + path);
        }
        return filePath;
    }

    private List<GenericPatch> getPatches(OracleHome oh) {
        List patchList = !OPlan.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.valueOf(oh.getHomeType()).toString()) : CommandUtils.getPatchesByOHOwnerForEM((OracleHome)oh);
        List patches = CommandUtils.sortPatchesById((List)patchList);
        return patches;
    }

    public List<String> getShellCommands(CommandContext context) {
        StringBuilder cmd;
        ArrayList<String> cmds = new ArrayList<String>();
        List singletonList = super.getShellCommands(context);
        if (null != singletonList) {
            cmds.addAll(singletonList);
        }
        if (this.preScript != null) {
            for (String pre : this.preScript) {
                cmd = this.getPrePostScriptCommand(context, pre);
                Logger.getLogger(RollbackOnlyRACDBHomeCommand.class.getName()).info("cmd: " + cmd.toString());
                cmds.add(0, cmd.toString());
            }
        }
        if (this.postScript != null) {
            for (String post : this.postScript) {
                cmd = this.getPrePostScriptCommand(context, post);
                Logger.getLogger(RollbackOnlyRACDBHomeCommand.class.getName()).info("cmd: " + cmd.toString());
                cmds.add(cmd.toString());
            }
        }
        return cmds;
    }

    private StringBuilder getPrePostScriptCommand(CommandContext context, String scriptPath) {
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        StringBuilder cmd = new StringBuilder(scriptPath);
        cmd.append(" ");
        cmd.append("-dbhome");
        cmd.append(" ");
        cmd.append(oh.getPath());
        return cmd;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<OPatchRollbackCommand> {
        public RollbackOnlyRACDBHomeCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof OpatchAction) || !a.getType().equals("RollbackOnlyRACDBHome")) {
                return null;
            }
            RollbackOnlyRACDBHomeCommand com = new RollbackOnlyRACDBHomeCommand(a, s);
            return com;
        }
    }
}

