/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.patchmodel.CompositePatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.OPatchSingleton;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.Command;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.GenericShellCommand;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanInternalException;
import oracle.oplan.sdk.patch.PatchPackagesBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrePostScriptCommand
extends GenericShellCommand {
    private static final String ROOTPRE_SCRIPT_PATH = File.separator + "clone" + File.separator + "rootpre.sh";
    private Logger logger = Logger.getLogger(PrePostScriptCommand.class.getName());

    public PrePostScriptCommand(CommandAction automationAction) {
        super(automationAction);
    }

    protected String findScript(String script, CommandContext context) {
        List bps = OPlan.getInstance().getOPlanEnv().getPatchesBag().getBundlePatches();
        if (bps.size() == 0) {
            throw new OPlanInternalException("oplan needs at least one bundle");
        }
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        List patches = !OPlan.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString()) : CommandUtils.getPatchesByOHOwnerForEM((OracleHome)oh);
        for (GenericPatch patch : patches) {
            if (!(patch instanceof OPatchSingleton) && !(patch instanceof CompositePatch) || !patch.getPatchLocation().contains("custom/server")) continue;
            String fileSeparator = CommandUtils.getFileSeparator((OracleHome)oh);
            return patch.getPatchLocation() + fileSeparator + "custom" + fileSeparator + "scripts" + fileSeparator + script;
        }
        CRSCluster crs = (CRSCluster)OPlan.getInstance().getSystemInstance().getTargetsOfType(CRSCluster.class).get(0);
        String version = crs.getVersion();
        if (version.startsWith("12.1.0")) {
            throw new OPlanInternalException("This step is not supported for 12c. Please remove it from the automation.xmls in the patch and try again.");
        }
        throw new OPlanInternalException("Can't find custom/scripts dir in patches.");
    }

    public boolean isCommandApplicableForPatchesInContext() {
        List eps;
        PatchPackagesBag bag = OPlan.getInstance().getOPlanEnv().getPatchesBag();
        List bps = bag.getBundlePatches();
        if (bps.size() == 0 && ((eps = bag.getEngineeredSystemPatches()) == null || eps.size() == 0)) {
            this.logger.fine("There are no bundle patches or engineered system patches in the context. Hence, " + ((Object)((Object)this)).getClass().getName() + " will not return any steps.");
            return false;
        }
        return true;
    }

    protected String getSource(Command c, CommandContext context) {
        return this.findScript(c.getSource().getValue().trim(), context);
    }

    public List<String> getShellCommands(CommandContext context) {
        ArrayList<String> cmds = null;
        for (Command c : this.automationCommands) {
            StringBuilder str = new StringBuilder();
            if (c.getSource().getValue().trim().equals("rootpre.sh")) {
                OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
                if (!new File(oh.getOriginalOracleHome().getPath() + ROOTPRE_SCRIPT_PATH).exists()) continue;
                cmds = new ArrayList();
                cmds.add(oh.getPath() + ROOTPRE_SCRIPT_PATH);
                continue;
            }
            str.append(this.getSource(c, context));
            for (String arg : c.getParameter()) {
                str.append(" ").append(arg.trim());
            }
            cmds = new ArrayList<String>();
            cmds.add(this.replaceParams(str.toString(), context));
        }
        return cmds;
    }

    public static class Builder
    implements CommandBuilder {
        private Logger logger = Logger.getLogger(PrePostScriptCommand.class.getName());

        public oracle.oplan.sdk.cmdtranslator.Command getCommand(ActionType a, Strategy s) {
            this.logger.log(Level.FINEST, "In construct");
            if (!(a instanceof CommandAction) || !a.getType().equals(CRSCommandActionType.PrePostScript.toString())) {
                return null;
            }
            return new PrePostScriptCommand((CommandAction)a);
        }
    }
}

