/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.BaseClass;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.HAS;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import model.patchmodel.EngineeredSystemPatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.PatchPackage;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.cmdtranslator.commands.AllRACDatabaseHomeLifecyle;
import oracle.oplan.db.cmdtranslator.commands.AllRACOracleHomeLifeCycle;
import oracle.oplan.db.cmdtranslator.commands.DatabaseHomeLifecycle;
import oracle.oplan.db.cmdtranslator.commands.OracleHomeLifecycle;
import oracle.oplan.db.cmdtranslator.commands.OracleHomeRACOneLifecycle;
import oracle.oplan.db.cmdtranslator.commands.PatchOnlyRACDBHomeCommand;
import oracle.oplan.db.cmdtranslator.commands.PatchRACDBHomeCommand;
import oracle.oplan.db.cmdtranslator.commands.PrePostRACPatchScriptCommand;
import oracle.oplan.db.cmdtranslator.commands.PrePostScriptCommand;
import oracle.oplan.db.cmdtranslator.commands.RACDBShellCommand;
import oracle.oplan.db.cmdtranslator.commands.RACOneDBShellCommand;
import oracle.oplan.db.cmdtranslator.commands.RelinkBinary;
import oracle.oplan.db.cmdtranslator.commands.RelinkBinaryRacOn;
import oracle.oplan.db.cmdtranslator.commands.RelocateDatabaseServices;
import oracle.oplan.db.cmdtranslator.commands.RollbackOnlyRACDBHomeCommand;
import oracle.oplan.db.cmdtranslator.commands.RollbackRACDBHomeCommand;
import oracle.oplan.db.cmdtranslator.commands.RootCrsCommand;
import oracle.oplan.db.cmdtranslator.commands.SQLPatchUpgradeModeCommand;
import oracle.oplan.db.cmdtranslator.commands.SpfFilePreReqCommand;
import oracle.oplan.db.cmdtranslator.commands.SqlCommand;
import oracle.oplan.db.cmdtranslator.commands.SqlPatchCommand;
import oracle.oplan.db.cmdtranslator.commands.StopAndStartRacOneDBShellCommand;
import oracle.oplan.db.cmdtranslator.commands.StopCrsCommand;
import oracle.oplan.db.cmdtranslator.commands.StopHasCommand;
import oracle.oplan.db.cmdtranslator.commands.StopStartDbConsole;
import oracle.oplan.db.cmdtranslator.commands.StopStartLogShipping;
import oracle.oplan.db.cmdtranslator.commands.StopStartRedoApply;
import oracle.oplan.db.cmdtranslator.commands.StopStartSqlHomeCommand;
import oracle.oplan.db.cmdtranslator.commands.SwitchGI;
import oracle.oplan.db.cmdtranslator.commands.UnlockOH;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandFactory;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.CopyDBHome;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleDCLICommand;
import oracle.oplan.sdk.cookies.SkipTargetCookie;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.SystemModelUtils;

public class DBCommandFactory
extends CommandFactory {
    private final Logger logger = Logger.getLogger(DBCommandFactory.class.getName());

    public DBCommandFactory() {
        this.constructables.add(new OracleHomeLifecycle.Builder());
        this.constructables.add(new OracleHomeRACOneLifecycle.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder((CommandBuilder)new PrePostScriptCommand.Builder()));
        this.constructables.add(new RelinkBinaryRacOn.Builder());
        this.constructables.add(new RelinkBinary.Builder());
        this.constructables.add(new RootCrsCommand.Builder());
        this.constructables.add(new SqlCommand.Builder());
        this.constructables.add(new SqlPatchCommand.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder((CommandBuilder)new StopCrsCommand.Builder()));
        this.constructables.add(new StopStartDbConsole.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder((CommandBuilder)new UnlockOH.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder((CommandBuilder)new SwitchGI.Builder()));
        this.constructables.add(new StopStartLogShipping.Builder());
        this.constructables.add(new StopStartRedoApply.Builder());
        this.constructables.add(new StopHasCommand.Builder());
        this.constructables.add(new RACDBShellCommand.Builder());
        this.constructables.add(new RACOneDBShellCommand.Builder());
        this.constructables.add(new AllRACOracleHomeLifeCycle.Builder());
        this.constructables.add(new PrePostRACPatchScriptCommand.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder((CommandBuilder)new PatchOnlyRACDBHomeCommand.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder((CommandBuilder)new PatchRACDBHomeCommand.Builder()));
        this.constructables.add(new DatabaseHomeLifecycle.Builder());
        this.constructables.add(new AllRACDatabaseHomeLifecyle.Builder());
        this.constructables.add(new StopAndStartRacOneDBShellCommand.Builder());
        this.constructables.add(new SpfFilePreReqCommand.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder((CommandBuilder)new RollbackOnlyRACDBHomeCommand.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder((CommandBuilder)new RollbackRACDBHomeCommand.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder((CommandBuilder)new CopyDBHome.Builder()));
        this.constructables.add(new SQLPatchUpgradeModeCommand.Builder());
        this.constructables.add(new StopStartSqlHomeCommand.Builder());
        this.constructables.add(new RelocateDatabaseServices.Builder());
    }

    public boolean includeTargetByVersion(ConfigGraph g, AbstractBaseTarget abt, ExecutionMode exeMode) {
        String oldDBVersion;
        String version = g.getRootVertex().getVersion();
        String patchVersion = null;
        PatchPackage patch = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
        boolean isEngSystemPatch = false;
        if (patch instanceof EngineeredSystemPatch) {
            isEngSystemPatch = true;
            List subPatches = ((EngineeredSystemPatch)patch).getSubPatches();
            for (GenericPatch subPatch : subPatches) {
                if (subPatch.getVersion() == null) continue;
                patchVersion = subPatch.getVersion();
                break;
            }
        }
        if ((oldDBVersion = this.getOldDBVersionIfPatchingOnlyDB(version, patchVersion)) != null) {
            version = oldDBVersion;
        }
        if (version != null) {
            if (isEngSystemPatch) {
                if (abt instanceof CRSCluster) {
                    if (!this.formattedVersion(version).equals(this.formattedVersion(abt.getVersion()))) {
                        this.updateSkipppedTargetMap(CRSCluster.class, abt);
                        return false;
                    }
                } else if (abt instanceof HAS && !this.formattedVersion(version).equals(this.formattedVersion(abt.getVersion()))) {
                    this.updateSkipppedTargetMap(HAS.class, abt);
                    return false;
                }
            }
            if (abt instanceof RACDatabase) {
                if (!this.formattedVersion(version).equals(this.formattedVersion(abt.getVersion()))) {
                    this.updateSkipppedTargetMap(RACDatabase.class, abt);
                    return false;
                }
            } else if (abt instanceof RACDBInstance) {
                if (!this.formattedVersion(version).equals(this.formattedVersion(abt.getVersion()))) {
                    return false;
                }
            } else if (abt instanceof OracleHome) {
                return this.handleOracleHome(g, abt, version);
            }
        }
        return true;
    }

    private String getOldDBVersionIfPatchingOnlyDB(String rootVersion, String patchVersion) {
        boolean isGIOrSIHAAvailable = false;
        String oldDBVersion = null;
        HashSet<String> setOfOldDBVersion = new HashSet<String>();
        for (BaseClass bc : OPlan.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            SIDatabase sidb;
            RACDatabase racDB;
            if (bc instanceof OracleHome) {
                OracleHome oh = (OracleHome)bc;
                if (oh.getHomeType().equals("crs")) {
                    if (!DBCommandUtils.isGIMarkedForSkip()) {
                        isGIOrSIHAAvailable = true;
                    }
                } else if (oh.getHomeType().equals("siha") && !DBCommandUtils.isSIHAMarkedForSkip()) {
                    isGIOrSIHAAvailable = true;
                }
            }
            if (bc instanceof RACDatabase && (racDB = (RACDatabase)bc).getVersion() != null && racDB.getProperty(SkipTargetCookie.class) == null && !this.formattedVersion(rootVersion).equals(this.formattedVersion(racDB.getVersion()))) {
                setOfOldDBVersion.add(racDB.getVersion());
            }
            if (!(bc instanceof SIDatabase) || (sidb = (SIDatabase)bc).getVersion() == null || sidb.getProperty(SkipTargetCookie.class) != null || this.formattedVersion(rootVersion).equals(this.formattedVersion(sidb.getVersion()))) continue;
            setOfOldDBVersion.add(sidb.getVersion());
        }
        if (!isGIOrSIHAAvailable) {
            if (setOfOldDBVersion.size() > 1) {
                if (patchVersion == null) {
                    this.logger.severe("Unable to determine the Patch version. Please execute individual home compatible to the patch version");
                    throw new OPlanException("Unable to determine the Patch version. Please execute individual home compatible to the patch version");
                }
                oldDBVersion = this.getDBVersionMatchingPatchVersion(patchVersion, setOfOldDBVersion);
            } else if (setOfOldDBVersion.size() == 1) {
                oldDBVersion = (String)setOfOldDBVersion.toArray()[0];
            }
        }
        return oldDBVersion;
    }

    private String getDBVersionMatchingPatchVersion(String patchVersion, Set setOfDBVersion) {
        String version = null;
        String[] listOfVersion = new String[setOfDBVersion.size()];
        setOfDBVersion.toArray(listOfVersion);
        for (String ver : listOfVersion) {
            if (!this.formattedVersion(patchVersion).equals(this.formattedVersion(ver))) continue;
            version = ver;
        }
        return version;
    }

    private boolean handleOracleHome(ConfigGraph g, AbstractBaseTarget abt, String version) {
        AbstractBaseTarget siha;
        boolean includeTarget = true;
        OracleHome oh = (OracleHome)abt;
        if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString().equals(oh.getHomeType())) {
            AbstractBaseTarget crs = g.getRootVertex();
            if (crs != null && !this.formattedVersion(version).equals(this.formattedVersion(crs.getVersion()))) {
                this.updateSkipppedTargetMap(CRSCluster.class, crs);
                includeTarget = false;
            }
        } else if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString().equals(oh.getHomeType())) {
            List racInst = g.getConnectedTargets((AbstractBaseTarget)oh, RACDBInstance.class);
            if (racInst != null && racInst.size() > 0 && !this.formattedVersion(version).equals(this.formattedVersion(((RACDBInstance)racInst.get(0)).getVersion()))) {
                this.updateSkipppedTargetMap(RACDatabase.class, (AbstractBaseTarget)((RACDBInstance)racInst.get(0)).getDbRAC());
                includeTarget = false;
            }
        } else if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.sidb.toString().equals(oh.getHomeType())) {
            List sidb = g.getConnectedTargets((AbstractBaseTarget)oh, SIDatabase.class);
            if (sidb != null && sidb.size() != 0 && !this.formattedVersion(version).equals(this.formattedVersion(((SIDatabase)sidb.get(0)).getVersion()))) {
                this.updateSkipppedTargetMap(SIDatabase.class, (AbstractBaseTarget)sidb.get(0));
                includeTarget = false;
            }
        } else if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.siha.toString().equals(oh.getHomeType()) && (siha = g.getRootVertex()) != null && !this.formattedVersion(version).equals(this.formattedVersion(siha.getVersion()))) {
            this.updateSkipppedTargetMap(HAS.class, siha);
            includeTarget = false;
        }
        return includeTarget;
    }

    private void updateSkipppedTargetMap(Class cls, AbstractBaseTarget abt) {
        if (OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(cls) == null) {
            OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().put(cls, new ArrayList());
        }
        if (!((List)OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(cls)).contains(abt.getName())) {
            ((List)OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(cls)).add(abt.getName());
        }
    }

    private String formattedVersion(String version) {
        int index = version.lastIndexOf(".");
        return version.substring(0, index);
    }

    protected boolean decideBasedOnWhilePatchingTargetAttribute(Command command, ConfigGraph g, AbstractBaseTarget abt) {
        Class type = SystemModelUtils.getClassForType((String)command.getAutomationAction().getWhilePatching());
        if (abt instanceof OracleHome) {
            OracleHome oh = (OracleHome)abt;
            if ((CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.name().equals(oh.getHomeType()) || CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.sidb.name().equals(oh.getHomeType())) && HAS.class.isAssignableFrom(type)) {
                this.logger.log(Level.FINER, "DBInstance OH is skipped:" + oh + " so checking if HAS instance is being patched, if so then this DBInstance OH need to be included for this step: " + command.getAutomationAction());
                return this.shouldIncludeDBInstanceCosHASIsPatched(command, g, oh);
            }
            if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.name().equals(oh.getHomeType()) && RACDatabase.class.isAssignableFrom(type)) {
                this.logger.log(Level.FINER, "CRS OH is skipped:" + oh + " so checking if RAC Database is being patched, if so then this CRS OH need to be included for this step: " + command.getAutomationAction());
                return this.shouldIncludeCRSCosRACIsPatched(command, g, oh);
            }
            this.logger.log(Level.FINER, "SkipTargetCookie is set on OracleHome target :" + abt + " and while-patching condition(" + command.getAutomationAction().getWhilePatching() + ") is set for step: " + command.getAutomationAction() + " . Going to check all the targets running from OracleHome: " + oh.getInstalledSWComponents());
            for (AbstractBaseTarget dep : oh.getInstalledSWComponents()) {
                if (!CommandUtils.shouldIncludeTargetCosDependantsNotSkipped((Command)command, (ConfigGraph)g, (AbstractBaseTarget)abt, (List)g.getConnectedTargets(dep, type))) continue;
                return true;
            }
            this.logger.log(Level.FINER, "All the targets running from this OracleHome is being skipped as well. Hence do not generate execution step for this target. ");
            return false;
        }
        if (abt instanceof RACDBInstance && HAS.class.isAssignableFrom(type)) {
            RACDBInstance racDBInst = (RACDBInstance)abt;
            return this.shouldIncludeDBInstanceCosHASIsPatched(command, g, racDBInst.getRuns_from());
        }
        return CommandUtils.shouldIncludeTargetCosDependantsNotSkipped((Command)command, (ConfigGraph)g, (AbstractBaseTarget)abt, (List)g.getConnectedTargets(abt, type));
    }

    private boolean shouldIncludeDBInstanceCosHASIsPatched(Command command, ConfigGraph g, OracleHome racInstanceOracleHome) {
        AbstractBaseTarget root = g.getRootVertex();
        if (root instanceof CRSCluster) {
            CRSCluster cluster = (CRSCluster)root;
            for (Host host : racInstanceOracleHome.getHosts()) {
                for (HAS has : cluster.getHAS()) {
                    if (!has.getHost().equals(host) || CommandUtils.isSkipTargetCookieSet((Command)command, (AbstractBaseTarget)has)) continue;
                    this.logger.log(Level.FINER, "HAS service " + has + " running on host: " + host + "is not being skipped, hence include this step.");
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldIncludeCRSCosRACIsPatched(Command command, ConfigGraph g, OracleHome crsOracleHome) {
        AbstractBaseTarget root = g.getRootVertex();
        if (root instanceof CRSCluster) {
            CRSCluster cluster = (CRSCluster)root;
            for (Host host : crsOracleHome.getHosts()) {
                for (RACDatabase rac : cluster.getDbRAC()) {
                    for (RACDBInstance raci : rac.getDbInstances()) {
                        if (!raci.getHost().equals(host) || CommandUtils.isSkipTargetCookieSet((Command)command, (AbstractBaseTarget)rac)) continue;
                        this.logger.log(Level.FINER, "RAC Database " + rac + " running on host: " + host + "is not being skipped, hence include this step.");
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

