/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.driver.sdk.productdriver;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import model.SystemInstance;
import model.common.Host;
import model.common.OracleHome;
import oracle.osysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.osysmodel.driver.sdk.util.OsysUtility;

public abstract class DummyProductDriver
extends ProductDriver {
    File dummyConfigFile;

    public void setDummyConfigFile(File file) {
        this.dummyConfigFile = file;
    }

    public SystemInstance buildSystemInstance() {
        try {
            SystemInstance systemInstance = new SystemInstance();
            systemInstance = systemInstance.readFile(this.dummyConfigFile);
            this.setTop(systemInstance);
            return systemInstance;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ProductDriverException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }

    public abstract void setTop(SystemInstance var1);

    public LocalInfo getLocalInfo() {
        Object object2;
        if (this.localInfo != null) {
            return this.localInfo;
        }
        this.localInfo = new LocalInfo();
        this.localInfo.setOracleHomes(new ArrayList<OracleHome>());
        for (Object object2 : this.ti.getEntities()) {
            if (!(object2 instanceof OracleHome)) continue;
            OracleHome oracleHome = (OracleHome)object2;
            this.localInfo.getOracleHomes().add(oracleHome);
        }
        ArrayList arrayList = new ArrayList();
        for (OracleHome oracleHome : this.ti.getEntities()) {
            if (!(oracleHome instanceof Host)) continue;
            Host host = (Host)oracleHome;
            arrayList.add(host);
        }
        Collections.sort(arrayList, new HostComparator());
        object2 = (Host)arrayList.get(0);
        this.localInfo.setLocalHostName(object2.getHostName());
        this.localInfo.setLocalHost((Host)object2);
        return this.localInfo;
    }

    public void setSystemInstance(SystemInstance systemInstance) {
        this.ti = systemInstance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HostComparator
    implements Comparator<Host> {
        @Override
        public int compare(Host host, Host host2) {
            String string = OsysUtility.getHostname();
            if (string.indexOf(".") != -1) {
                string = string.substring(0, string.indexOf("."));
            }
            if (host.getHostName().equals(string)) {
                return -1;
            }
            if (host2.getHostName().equals(string)) {
                return 1;
            }
            return host.getHostName().compareTo(host2.getHostName());
        }
    }
}

