/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.variables.impl;

import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.variables.VariableQuery;
import com.oracle.cie.gdr.variables.VariableQueryParam;
import com.oracle.cie.gdr.variables.VariableQueryParamType;
import com.oracle.cie.gdr.variables.VariableQueryRequest;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonVariableQuery
implements VariableQuery {
    @Override
    public Object query(VariableQueryRequest variableQueryRequest) throws GdrException {
        this.validateQueryRequest(variableQueryRequest);
        return this.executeQuery(variableQueryRequest);
    }

    protected abstract Object executeQuery(VariableQueryRequest var1) throws GdrException;

    protected void validateQueryRequest(VariableQueryRequest variableQueryRequest) throws GdrException {
        int querySize;
        List<VariableQueryParamType> paramTypes = this.getParamTypes();
        List<? extends VariableQueryParam> queryParams = variableQueryRequest.getVariableQueryParams();
        int paramSize = paramTypes != null ? paramTypes.size() : 0;
        int n = querySize = queryParams != null ? queryParams.size() : 0;
        if (paramSize != querySize) {
            throw new GdrException("The expected parameters do not match those provided.  Expected: " + paramTypes + " Provided:" + queryParams);
        }
        this.validateQueryRequestParamsValues(variableQueryRequest);
    }

    protected void validateQueryRequestParamsValues(VariableQueryRequest variableQueryRequest) throws GdrException {
        List<VariableQueryParamType> paramTypes = this.getParamTypes();
        for (int x = 0; x < paramTypes.size(); ++x) {
            VariableQueryParamType paramType = paramTypes.get(x);
            String paramValue = variableQueryRequest.getVariableQueryParams().get(x).getValue();
            if ((paramType.isOptional() || paramValue != null) && !paramValue.isEmpty()) continue;
            throw new GdrException("The parameter value provided was null or empty.");
        }
    }

    protected List<VariableQueryParamType> getParamTypes(Class<?> ... types) {
        ArrayList<VariableQueryParamType> paramTypes = new ArrayList<VariableQueryParamType>();
        if (types != null) {
            for (final Class<?> type : types) {
                paramTypes.add(new VariableQueryParamType(){

                    @Override
                    public Class<?> getType() {
                        return type;
                    }

                    @Override
                    public boolean isOptional() {
                        return false;
                    }
                });
            }
        }
        return paramTypes;
    }
}

