/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.util.Chmod;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.utils.RuntimeExecShutdownHook;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PatchScriptHandler {
    public static final String PATCH_SCRIPTS_DIR = "patch-scripts";
    public static final String PATCH_BACKUP_DIR = "bak";
    public static final String APPLY_SCRIPT_NAME = "apply-patch";
    public static final String REMOVE_SCRIPT_NAME = "remove-patch";
    public static final String SCRIPT_EXT_WINDOWS = ".cmd";
    public static final String SCRIPT_EXT_UNIX = ".sh";
    public static String SCRIPT_SLEEP_SECONDS = System.getProperty("oracle.installer.patch_script_sleep_seconds", "10");
    public boolean _isWindows = System.getProperty("PatchScriptHandler.os.name", System.getProperty("os.name")).toLowerCase().contains("windows");
    public String LS = this._isWindows ? "\r\n" : "\n";
    public String FS = this._isWindows ? "\\" : "/";
    private File _home;
    private String _patchId;
    private File _patchScriptDir;
    private File _applyScript;
    private File _removeScript;

    public PatchScriptHandler(File home, String patchId) {
        this._home = home;
        this._patchId = patchId;
        this.init();
    }

    private void init() {
        this._patchScriptDir = new File(this._home, "inventory" + File.separator + PATCH_SCRIPTS_DIR + File.separator + this._patchId);
        String ext = this._isWindows ? SCRIPT_EXT_WINDOWS : SCRIPT_EXT_UNIX;
        this._applyScript = new File(this._patchScriptDir, APPLY_SCRIPT_NAME + ext);
        this._removeScript = new File(this._patchScriptDir, REMOVE_SCRIPT_NAME + ext);
    }

    public File getPatchScriptDir() {
        return this._patchScriptDir;
    }

    public File getApplyScript() {
        return this._applyScript;
    }

    public File getRemoveScript() {
        return this._removeScript;
    }

    public void registerApplyScript() {
        this.registerScript(this.getApplyScript(), APPLY_SCRIPT_NAME);
    }

    public void registerRemoveScript() {
        this.registerScript(this.getRemoveScript(), REMOVE_SCRIPT_NAME);
    }

    private void registerScript(File patchScript, String scriptName) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(patchScript.getAbsolutePath() + " > " + this._patchScriptDir.getAbsolutePath() + File.separator + scriptName + ".log");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ORACLE_HOME", this._home.getAbsolutePath());
        RuntimeExecShutdownHook.addExec(commands, patchScript.getParentFile(), env, true);
    }

    public void generate(List<FileTarget> fileTargets) throws IOException {
        LinkedHashMap<String, String> targetMap = new LinkedHashMap<String, String>();
        for (FileTarget fileTarget : fileTargets) {
            String dest = fileTarget.getDest();
            String source = dest + "." + this._patchId;
            File sourceFile = new File(this._home, source);
            if (!sourceFile.exists()) continue;
            targetMap.put(source, dest);
        }
        this.generate(targetMap);
    }

    public void generate(Map<String, String> targetMap) throws IOException {
        LinkedHashMap<String, String> fixedTargetMap = new LinkedHashMap<String, String>();
        if (targetMap != null && !targetMap.isEmpty()) {
            for (Map.Entry<String, String> entry : targetMap.entrySet()) {
                fixedTargetMap.put(this.fixPath(entry.getKey()), this.fixPath(entry.getValue()));
            }
        }
        String backupDir = "inventory" + this.FS + PATCH_SCRIPTS_DIR + this.FS + this._patchId + this.FS + PATCH_BACKUP_DIR;
        StringBuilder applyScript = new StringBuilder(this.getScriptHeader());
        applyScript.append(this.getRestoreFiles(fixedTargetMap, backupDir)).append(this.LS);
        applyScript.append(this.getBackupFiles(fixedTargetMap, backupDir)).append(this.LS);
        applyScript.append(this.getApplyFiles(fixedTargetMap)).append(this.LS);
        StringBuilder removeScript = new StringBuilder(this.getScriptHeader());
        removeScript.append(this.getRemoveFiles(fixedTargetMap, backupDir));
        this.getPatchScriptDir().mkdirs();
        FileWriter fw = new FileWriter(this.getApplyScript());
        fw.write(applyScript.toString());
        fw.close();
        fw = new FileWriter(this.getRemoveScript());
        fw.write(removeScript.toString());
        fw.close();
        if (!this._isWindows) {
            Chmod.chmod((String)this.getApplyScript().getAbsolutePath(), (String)"755", (boolean)false);
            Chmod.chmod((String)this.getRemoveScript().getAbsolutePath(), (String)"755", (boolean)false);
        }
    }

    private String fixPath(String path) {
        if (path != null) {
            String sep;
            path = path.trim();
            if (this._isWindows) {
                sep = "\\";
                path = path.replace("/", sep);
            } else {
                sep = "/";
                path = path.replace("\\", sep);
            }
            while (path.startsWith(sep)) {
                path = path.substring(1);
            }
            while (path.endsWith(sep)) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    private String getScriptHeader() {
        if (this._isWindows) {
            return "@ECHO OFF" + this.LS + this.LS + "SETLOCAL" + this.LS + this.LS + "ECHO SLEEPING FOR " + SCRIPT_SLEEP_SECONDS + " SECONDS" + this.LS + "ping -n " + SCRIPT_SLEEP_SECONDS + " 127.0.0.1 > nul" + this.LS + this.LS + "SET SCRIPTPATH=%~dp0" + this.LS + "IF \"%ORACLE_HOME%\"==\"\" (" + this.LS + "  FOR %%i IN (\"%SCRIPTPATH%\\..\\..\\..\") DO SET ORACLE_HOME=%%~fsi" + this.LS + ")" + this.LS + this.LS + "IF EXIST \"%ORACLE_HOME%\\" + "inventory" + "\" (" + this.LS + "  ECHO USING ORACLE_HOME -- %ORACLE_HOME%" + this.LS + ") ELSE (" + this.LS + "  ECHO THE ORACLE_HOME IS INVALID -- %ORACLE_HOME%" + this.LS + "  GOTO :EOF" + this.LS + ")" + this.LS + this.LS;
        }
        return "#!/bin/sh" + this.LS + this.LS + "echo \"SLEEPING FOR " + SCRIPT_SLEEP_SECONDS + " SECONDS\"" + this.LS + "sleep " + SCRIPT_SLEEP_SECONDS + this.LS + this.LS + "mypwd=\"`pwd`\"" + this.LS + this.LS + "if [ \"${ORACLE_HOME}\" = \"\" ] ; then" + this.LS + "  SCRIPTNAME=$0" + this.LS + "  case ${SCRIPTNAME} in" + this.LS + "   /*)  SCRIPTPATH=`dirname \"${SCRIPTNAME}\"` ;;" + this.LS + "    *)  SCRIPTPATH=`dirname \"${mypwd}/${SCRIPTNAME}\"` ;;" + this.LS + "  esac" + this.LS + "  ORACLE_HOME=`cd ${SCRIPTPATH}/../../.. ; pwd`" + this.LS + "fi" + this.LS + this.LS + "if [ -d \"${ORACLE_HOME}/" + "inventory" + "\" ] ; then" + this.LS + "  echo \"USING ORACLE_HOME -- ${ORACLE_HOME}\"" + this.LS + "else" + this.LS + "  echo \"THE ORACLE_HOME IS INVALID -- ${ORACLE_HOME}\"" + this.LS + "  exit 1" + this.LS + "fi" + this.LS + this.LS;
    }

    private String getBackupFiles(Map<String, String> targetMap, String backupDir) {
        String backupFiles = "";
        backupFiles = this._isWindows ? backupFiles + ":BACKUP" + this.LS + this.LS + "ECHO BACKING UP FILES TO %ORACLE_HOME%\\" + backupDir + this.LS : backupFiles + "echo \"BACKING UP FILES TO ${ORACLE_HOME}/" + backupDir + "\"" + this.LS;
        if (targetMap != null && !targetMap.isEmpty()) {
            if (this._isWindows) {
                backupFiles = backupFiles + "SET RETURN_CODE=0" + this.LS;
            }
            for (Map.Entry<String, String> entry : targetMap.entrySet()) {
                String source = entry.getValue();
                String destDir = backupDir;
                String dest = destDir + this.FS + source;
                int index = source.replace("\\", "/").lastIndexOf("/");
                if (index != -1) {
                    destDir = destDir + this.FS + source.substring(0, index);
                }
                backupFiles = backupFiles + this.getBackupFile(source, destDir, dest);
            }
        }
        return backupFiles;
    }

    private String getBackupFile(String source, String destDir, String dest) {
        if (this._isWindows) {
            String copy = "COPY /Y \"%ORACLE_HOME%\\" + source + "\" \"%ORACLE_HOME%\\" + dest + "\"";
            return "IF EXIST \"%ORACLE_HOME%\\" + source + "\" (" + this.LS + "  IF NOT EXIST \"%ORACLE_HOME%\\" + destDir + "\" (" + this.LS + "    MKDIR \"%ORACLE_HOME%\\" + destDir + "\"" + this.LS + "  )" + this.LS + "  ECHO " + copy + this.LS + "  " + copy + this.LS + "  SET RETURN_CODE=%ERRORLEVEL%" + this.LS + ")" + this.LS + "IF NOT \"%RETURN_CODE%\"==\"0\" (" + this.LS + "  ECHO FAILED -- " + copy + this.LS + "  EXIT /B %RETURN_CODE%" + this.LS + ")" + this.LS;
        }
        String copy = "cp -f \"${ORACLE_HOME}/" + source + "\" \"${ORACLE_HOME}/" + dest + "\"";
        return "if [ -f  \"${ORACLE_HOME}/" + source + "\" ] ; then " + this.LS + "  if [ ! -d \"${ORACLE_HOME}/" + destDir + "\" ] ; then" + this.LS + "    mkdir -p \"${ORACLE_HOME}/" + destDir + "\"" + this.LS + "  fi" + this.LS + "  echo \"" + this.escapeQuotes(copy) + "\"" + this.LS + copy + this.LS + "  RETURN_CODE=$?" + this.LS + "  if [ \"${RETURN_CODE}\" -ne \"0\" ]; then" + this.LS + "    echo \"FAILED -- " + this.escapeQuotes(copy) + "\"" + this.LS + "    exit ${RETURN_CODE}" + this.LS + "  fi" + this.LS + "fi" + this.LS;
    }

    private String escapeQuotes(String s) {
        return s.replace("\"", "\\\"");
    }

    private String getApplyFiles(Map<String, String> targetMap) {
        String applyFiles = "";
        applyFiles = this._isWindows ? applyFiles + ":APPLY" + this.LS + this.LS + "ECHO APPLYING PATCHED FILES" + this.LS : applyFiles + "echo \"APPLYING PATCHED FILES\"" + this.LS;
        if (targetMap != null && !targetMap.isEmpty()) {
            for (Map.Entry<String, String> entry : targetMap.entrySet()) {
                applyFiles = applyFiles + this.getApplyFile(entry.getKey(), entry.getValue());
            }
        }
        if (this._isWindows) {
            applyFiles = applyFiles + this.LS + "ECHO APPLYING PATCHED FILES COMPLETED SUCCESSFULLY" + this.LS;
            applyFiles = applyFiles + "GOTO :EOF" + this.LS;
        } else {
            applyFiles = applyFiles + this.LS + "echo \"APPLYING PATCHED FILES COMPLETED SUCCESSFULLY\"" + this.LS;
            applyFiles = applyFiles + "exit 0" + this.LS;
        }
        return applyFiles;
    }

    private String getApplyFile(String source, String dest) {
        if (this._isWindows) {
            String copy = "COPY /Y \"%ORACLE_HOME%\\" + source + "\" \"%ORACLE_HOME%\\" + dest + "\"";
            return "ECHO " + copy + this.LS + copy + this.LS + "SET RETURN_CODE=%ERRORLEVEL%" + this.LS + "IF NOT \"%RETURN_CODE%\"==\"0\" (" + this.LS + "  ECHO FAILED -- " + copy + this.LS + "  GOTO :RESTORE" + this.LS + ")" + this.LS;
        }
        String copy = "cp -f \"${ORACLE_HOME}/" + source + "\" \"${ORACLE_HOME}/" + dest + "\"";
        return "echo \"" + this.escapeQuotes(copy) + "\"" + this.LS + copy + this.LS + "RETURN_CODE=$?" + this.LS + "if [ \"${RETURN_CODE}\" -ne \"0\" ]; then" + this.LS + "  echo \"FAILED -- " + this.escapeQuotes(copy) + "\"" + this.LS + "  restore" + this.LS + "  exit ${RETURN_CODE}" + this.LS + "fi" + this.LS;
    }

    private String getRestoreFiles(Map<String, String> targetMap, String backupDir) {
        String restoreFiles = "";
        restoreFiles = this._isWindows ? restoreFiles + "GOTO :BACKUP" + this.LS + this.LS + ":RESTORE" + this.LS + "ECHO PATCHING FAILED -- RESTORING ORIGINAL FILES" + this.LS : restoreFiles + "restore()" + this.LS + "{" + this.LS + "  echo \"PATCHING FAILED -- RESTORING ORIGINAL FILES\"" + this.LS;
        if (targetMap != null && !targetMap.isEmpty()) {
            for (Map.Entry<String, String> entry : targetMap.entrySet()) {
                restoreFiles = restoreFiles + this.getRestoreFile(backupDir + this.FS + entry.getValue(), entry.getValue());
            }
        }
        restoreFiles = this._isWindows ? restoreFiles + "EXIT /B %RETURN_CODE%" + this.LS : restoreFiles + "}" + this.LS;
        return restoreFiles;
    }

    private String getRestoreFile(String source, String dest) {
        if (this._isWindows) {
            String copy = "COPY /Y \"%ORACLE_HOME%\\" + source + "\" \"%ORACLE_HOME%\\" + dest + "\"";
            return "ECHO " + copy + this.LS + copy + this.LS;
        }
        String copy = "  cp -f \"${ORACLE_HOME}/" + source + "\" \"${ORACLE_HOME}/" + dest + "\"";
        return "  echo \"" + this.escapeQuotes(copy) + "\"" + this.LS + copy + this.LS;
    }

    private String getRemoveFiles(Map<String, String> targetMap, String backupDir) {
        String removeFiles = "";
        removeFiles = this._isWindows ? removeFiles + "SET GLOBAL_RETURN_CODE=0" + this.LS + this.LS + "ECHO REMOVING PATCHED FILES" + this.LS : removeFiles + "GLOBAL_RETURN_CODE=\"0\"" + this.LS + this.LS + "echo \"REMOVING PATCHED FILES\"" + this.LS;
        if (targetMap != null && !targetMap.isEmpty()) {
            if (this._isWindows) {
                removeFiles = removeFiles + "SET RETURN_CODE=0" + this.LS;
            }
            for (Map.Entry<String, String> entry : targetMap.entrySet()) {
                removeFiles = removeFiles + this.getRemoveFile(backupDir + this.FS + entry.getValue(), entry.getValue());
            }
        }
        removeFiles = this._isWindows ? removeFiles + this.LS + "IF NOT \"%GLOBAL_RETURN_CODE%\"==\"0\" (" + this.LS + "  ECHO REMOVING PATCHED FILES FAILED" + this.LS + "  EXIT /B %GLOBAL_RETURN_CODE%" + this.LS + ")" + this.LS + this.LS + "ECHO REMOVING PATCHED FILES COMPLETED SUCCESSFULLY" + this.LS : removeFiles + this.LS + "if [ \"${GLOBAL_RETURN_CODE}\" -ne \"0\" ]; then" + this.LS + "  echo \"REMOVING PATCHED FILES FAILED\"" + this.LS + "  exit ${GLOBAL_RETURN_CODE}" + this.LS + "fi" + this.LS + this.LS + "echo \"REMOVING PATCHED FILES COMPLETED SUCCESSFULLY\"" + this.LS;
        return removeFiles;
    }

    private String getRemoveFile(String source, String dest) {
        if (this._isWindows) {
            String copy = "COPY /Y \"%ORACLE_HOME%\\" + source + "\" \"%ORACLE_HOME%\\" + dest + "\"";
            return "IF EXIST \"%ORACLE_HOME%\\" + source + "\" (" + this.LS + "  ECHO " + copy + this.LS + "  " + copy + this.LS + "  SET RETURN_CODE=%ERRORLEVEL%" + this.LS + ")" + this.LS + "IF NOT \"%RETURN_CODE%\"==\"0\" (" + this.LS + "  ECHO FAILED -- " + copy + this.LS + "  SET GLOBAL_RETURN_CODE=%RETURN_CODE%" + this.LS + ")" + this.LS;
        }
        String copy = "cp -f \"${ORACLE_HOME}/" + source + "\" \"${ORACLE_HOME}/" + dest + "\"";
        return "if [ -f  \"${ORACLE_HOME}/" + source + "\" ] ; then " + this.LS + "  echo \"" + this.escapeQuotes(copy) + "\"" + this.LS + "  " + copy + this.LS + "  RETURN_CODE=$?" + this.LS + "  if [ \"${RETURN_CODE}\" -ne \"0\" ]; then" + this.LS + "    echo \"FAILED -- " + this.escapeQuotes(copy) + "\"" + this.LS + "    GLOBAL_RETURN_CODE=${RETURN_CODE}" + this.LS + "  fi" + this.LS + "fi" + this.LS;
    }

    public static void main(String[] args) {
        File home = new File(args[0]);
        String patchId = args[1];
        System.setProperty("PatchScriptHandler.os.name", "windows");
        PatchScriptHandler patchScriptHandler = new PatchScriptHandler(home, patchId);
        LinkedHashMap<String, String> targetMap = new LinkedHashMap<String, String>();
        int i = 2;
        while (args.length > i + 1) {
            targetMap.put(args[i], args[i + 1]);
            i += 2;
        }
        try {
            patchScriptHandler.generate(targetMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.setProperty("PatchScriptHandler.os.name", "linux");
        patchScriptHandler = new PatchScriptHandler(home, patchId);
        try {
            patchScriptHandler.generate(targetMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

