/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.libraries.LibraryType;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;

public class FeatureSetGenerationConfig {
    private static final String FEATURE_SET_KEY = "Feature-Set";
    private static final String FEATURE_SET_VERSION_KEY = "Version";
    private static final String DISPLAY_NAME_KEY = "Display-Name";
    private static final String DISPLAY_NAME_KEY_KEY = "Display-Name-Key";
    private static final String DESCRIPTION_KEY = "Description";
    private static final String LIBRARY_NAME_KEY = "Library-Name";
    private static final String LIBRARY_TYPE_KEY = "Library-Type";
    private static final String MULTI_VERSION_KEY = "Multi-Version";
    private static final String CONSUMPTION_TYPE_KEY = "Consumption-Type";
    private static final String THIRD_PARTY_KEY = "Third-Party";
    private static final String TYPE_KEY = "Type";
    private static final String SUB_TYPE_KEY = "Sub-Type";
    private static final String SINGLETON_KEY = "Singleton";
    private static final String POM_GEM_KEY = "Pom-Gen";
    private static final String Require_KEY = "Require";
    private static final String DESCRIPTION_KEY_KEY = "Description-Key";
    private Map<String, String> _configProperties = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    public static final String EMPTY_DEFAULT_VAL = "";
    public static final String FALSE_DEFAULT_VAL = Boolean.FALSE.toString();
    public static final String FEATURE_VERSION__DEFAULT_VAL = "1.0.0.0.0";

    public FeatureSetGenerationConfig(String jarName) {
        this._configProperties.put(FEATURE_SET_KEY, jarName + ".feature-set");
        this._configProperties.put(FEATURE_SET_VERSION_KEY, FEATURE_VERSION__DEFAULT_VAL);
        this._configProperties.put(DISPLAY_NAME_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(DISPLAY_NAME_KEY_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(DESCRIPTION_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(DESCRIPTION_KEY_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(MULTI_VERSION_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(CONSUMPTION_TYPE_KEY, "unrestricted");
        this._configProperties.put(TYPE_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(SUB_TYPE_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(THIRD_PARTY_KEY, FALSE_DEFAULT_VAL);
        this._configProperties.put(SINGLETON_KEY, FALSE_DEFAULT_VAL);
        this._configProperties.put(POM_GEM_KEY, FALSE_DEFAULT_VAL);
        this._configProperties.put(Require_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(LIBRARY_NAME_KEY, jarName + ".library");
        this._configProperties.put(LIBRARY_TYPE_KEY, LibraryType.manifest.name());
    }

    public boolean isMultiVersion() {
        return Boolean.valueOf(this._configProperties.get(MULTI_VERSION_KEY));
    }

    public boolean isPomGen() {
        return Boolean.valueOf(this._configProperties.get(POM_GEM_KEY));
    }

    public boolean isSingleton() {
        return Boolean.valueOf(this._configProperties.get(SINGLETON_KEY));
    }

    public boolean isThirdParty() {
        return Boolean.valueOf(this._configProperties.get(THIRD_PARTY_KEY));
    }

    public String getConsumptionType() {
        return this._configProperties.get(CONSUMPTION_TYPE_KEY);
    }

    public String getLibraryName() {
        return this._configProperties.get(LIBRARY_NAME_KEY);
    }

    public String getLibraryType() {
        return this._configProperties.get(LIBRARY_TYPE_KEY);
    }

    public String getFeatureName() {
        return this._configProperties.get(FEATURE_SET_KEY);
    }

    public String getVersion() {
        return this._configProperties.get(FEATURE_SET_VERSION_KEY);
    }

    public String getDisplayName() {
        return this._configProperties.get(DISPLAY_NAME_KEY);
    }

    public String getDisplayNameKey() {
        return this._configProperties.get(DISPLAY_NAME_KEY_KEY);
    }

    public String getDescription() {
        return this._configProperties.get(DESCRIPTION_KEY);
    }

    public String getDescriptionKey() {
        return this._configProperties.get(DESCRIPTION_KEY_KEY);
    }

    public String getType() {
        return this._configProperties.get(TYPE_KEY);
    }

    public String getSubType() {
        return this._configProperties.get(SUB_TYPE_KEY);
    }

    public Map<String, String> getRequires() {
        return this.createMapFromString(this._configProperties.get(Require_KEY), " ");
    }

    private Map<String, String> createMapFromString(String mapString, String delimiter) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (mapString != null && mapString.trim().length() > 0) {
            String[] keyValueString = mapString.split(delimiter);
            for (int i = 0; i < keyValueString.length - 1; i += 2) {
                map.put(keyValueString[i], keyValueString[i + 1]);
            }
        }
        return map;
    }

    public FeatureSetGenerationConfig(String jarName, Attributes featureAttributes) throws BuilderException {
        this(jarName);
        for (Map.Entry<Object, Object> attribute : featureAttributes.entrySet()) {
            String key = attribute.getKey().toString();
            if (this._configProperties.containsKey(key)) {
                String value = attribute.getValue().toString();
                if (value == null || value.trim().length() <= 0) continue;
                String propertyValue = this.validateProperty(key, value);
                if (key.compareToIgnoreCase(FEATURE_SET_KEY) == 0) {
                    String nameVerion = propertyValue;
                    if (nameVerion.trim().length() <= 0) continue;
                    String[] nameAndVersion = nameVerion.split(" ");
                    this._configProperties.put(FEATURE_SET_KEY, nameAndVersion[0]);
                    if (nameAndVersion.length <= 1) continue;
                    this._configProperties.put(FEATURE_SET_VERSION_KEY, nameAndVersion[1]);
                    continue;
                }
                this._configProperties.put(key, propertyValue);
                continue;
            }
            throw new BuilderException(key + " attribute is not valid for feature-set definition creation");
        }
    }

    private String validateProperty(String key, String value) throws BuilderException {
        String validValue = value.toLowerCase();
        String erroMessage = null;
        if (key.equalsIgnoreCase(MULTI_VERSION_KEY) || key.equalsIgnoreCase(POM_GEM_KEY) || key.equalsIgnoreCase(THIRD_PARTY_KEY) || key.equalsIgnoreCase(SINGLETON_KEY)) {
            if (!validValue.matches("true|false")) {
                erroMessage = "Invalid " + key + " attribute value, a boolean value is expected";
            }
        } else if (key.equalsIgnoreCase(CONSUMPTION_TYPE_KEY)) {
            if (!validValue.matches("restricted|unrestricted")) {
                erroMessage = "Invalid " + key + " attribute value. Expected values are: restricted or unrestricted.";
            }
        } else if (key.equalsIgnoreCase(LIBRARY_TYPE_KEY)) {
            if (!validValue.matches("manifest|runtime|interface|client|mergedjar")) {
                erroMessage = "Invalid " + key + " attribute value. Expected values are: manifest, runtime, interface, client or mergedjar.";
            }
            if (validValue.equalsIgnoreCase("mergedJar")) {
                validValue = "mergedJar";
            }
        } else {
            validValue = value;
        }
        if (erroMessage != null) {
            throw new BuilderException(erroMessage);
        }
        return validValue;
    }
}

