/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FeatureCompatibility;
import com.oracle.cie.gdr.common.NLS;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.Collection;
import java.util.Map;

public class DistributionCompatibilityException
extends GdrException {
    private DistributionTarget _currentDist;
    private Map<DistributionTarget, Collection<FeatureCompatibility>> _incompatible;
    private String _logMessage;

    public DistributionCompatibilityException(DistributionTarget currentDist, Map<DistributionTarget, Collection<FeatureCompatibility>> incompatible) {
        super(DistributionCompatibilityException.getIncompatibleMessage(currentDist, incompatible, true));
        this._logMessage = DistributionCompatibilityException.getIncompatibleMessage(currentDist, incompatible, false);
        this._currentDist = currentDist;
        this._incompatible = incompatible;
    }

    public DistributionTarget getDistributionTarget() {
        return this._currentDist;
    }

    public Map<DistributionTarget, Collection<FeatureCompatibility>> getIncompatibleDistributions() {
        return this._incompatible;
    }

    public String getLogMessage() {
        return this._logMessage;
    }

    public static String getIncompatibleMessage(DistributionTarget currentDist, Map<DistributionTarget, Collection<FeatureCompatibility>> incompatible, boolean includeDetails) {
        StringBuilder message = new StringBuilder();
        for (DistributionTarget target : incompatible.keySet()) {
            for (FeatureCompatibility fc : incompatible.get(target)) {
                message.append("\n").append(target.getDistribution().toString(includeDetails)).append(" [").append(fc.toString(includeDetails)).append("]");
            }
        }
        return NLS.getMsg("DistributionCompatibility.incompatible", currentDist.getDistribution().toString(includeDetails), message.toString());
    }
}

