/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.gdr.external.builder.BuilderException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;

public class ComponentGenerationConfig {
    private static final String COMPONENT_NAME_KEY = "Component";
    private static final String COMPONENT_VERSION_KEY = "Version";
    private static final String SYMBOL_KEY = "Symbol";
    private static final String BOOTSTRAP_KEY = "Bootstrap";
    private static final String SINGLETON_KEY = "Singleton";
    private static final String POM_GEM_KEY = "Pom-Gen";
    private static final String REPLICABLE_KEY = "Replicable";
    private static final String LIBRARY_NAME_KEY = "Library-Name";
    private static final String LIBRARY_TYPE_KEY = "Library-Type";
    private static final String DESCRIPTION_KEY = "Description";
    private static final String DESCRIPTION_KEY_KEY = "Description-Key";
    private static final String VARIABLES_KEY = "Variables";
    private static final String PLATFORMS_KEY = "Platforms";
    private static final String LOCALES_KEY = "Locales";
    private static final String EMPTY_DEFAULT_VAL = "";
    private static final String FALSE_DEFAULT_VAL = Boolean.FALSE.toString();
    private static final String COMPONENT_VERSION__DEFAULT_VAL = "1.0.0.0.0";
    private Map<String, String> _configProperties = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public ComponentGenerationConfig(String jarName) {
        this._configProperties.put(COMPONENT_NAME_KEY, jarName + ".component");
        this._configProperties.put(COMPONENT_VERSION_KEY, COMPONENT_VERSION__DEFAULT_VAL);
        this._configProperties.put(SYMBOL_KEY, jarName + ".symbol");
        this._configProperties.put(BOOTSTRAP_KEY, FALSE_DEFAULT_VAL);
        this._configProperties.put(SINGLETON_KEY, FALSE_DEFAULT_VAL);
        this._configProperties.put(POM_GEM_KEY, FALSE_DEFAULT_VAL);
        this._configProperties.put(REPLICABLE_KEY, FALSE_DEFAULT_VAL);
        this._configProperties.put(LIBRARY_NAME_KEY, jarName + ".library");
        this._configProperties.put(LIBRARY_TYPE_KEY, "none");
        this._configProperties.put(DESCRIPTION_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(DESCRIPTION_KEY_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(VARIABLES_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(PLATFORMS_KEY, EMPTY_DEFAULT_VAL);
        this._configProperties.put(LOCALES_KEY, EMPTY_DEFAULT_VAL);
    }

    public ComponentGenerationConfig(String jarName, Attributes componentAttributes) throws BuilderException {
        this(jarName);
        for (Map.Entry<Object, Object> attribute : componentAttributes.entrySet()) {
            String key = attribute.getKey().toString();
            if (this._configProperties.containsKey(key)) {
                String value = attribute.getValue().toString();
                if (value == null || value.trim().length() <= 0) continue;
                String propertyValue = ComponentGenerationConfig.validateProperty(key, value);
                if (key.compareToIgnoreCase(COMPONENT_NAME_KEY) == 0) {
                    String nameVerion = propertyValue;
                    if (nameVerion.trim().length() <= 0) continue;
                    String[] nameAndVersion = nameVerion.split(" ");
                    this._configProperties.put(COMPONENT_NAME_KEY, nameAndVersion[0]);
                    if (nameAndVersion.length <= 1) continue;
                    this._configProperties.put(COMPONENT_VERSION_KEY, nameAndVersion[1]);
                    continue;
                }
                this._configProperties.put(key, propertyValue);
                continue;
            }
            throw new BuilderException(key + " attribute is not valid for component definition creation");
        }
    }

    public boolean isBootstrap() {
        return Boolean.valueOf(this._configProperties.get(BOOTSTRAP_KEY));
    }

    public boolean isSingleton() {
        return Boolean.valueOf(this._configProperties.get(SINGLETON_KEY));
    }

    public boolean isPomGen() {
        return Boolean.valueOf(this._configProperties.get(POM_GEM_KEY));
    }

    public boolean isReplicable() {
        return Boolean.valueOf(this._configProperties.get(REPLICABLE_KEY));
    }

    public String getComponentName() {
        return this._configProperties.get(COMPONENT_NAME_KEY);
    }

    public String getVersion() {
        return this._configProperties.get(COMPONENT_VERSION_KEY);
    }

    public String getSymbol() {
        return this._configProperties.get(SYMBOL_KEY);
    }

    public String getLibraryName() {
        return this._configProperties.get(LIBRARY_NAME_KEY);
    }

    public String getLibraryType() {
        return this._configProperties.get(LIBRARY_TYPE_KEY);
    }

    public String getDescription() {
        return this._configProperties.get(DESCRIPTION_KEY);
    }

    public String getDescriptionKey() {
        return this._configProperties.get(DESCRIPTION_KEY_KEY);
    }

    public Set<String> getPlatforms() {
        return this.createSetFromString(this._configProperties.get(PLATFORMS_KEY), " ");
    }

    public Set<String> getLocales() {
        return this.createSetFromString(this._configProperties.get(LOCALES_KEY), " ");
    }

    public Map<String, String> getVariables() {
        return this.createMapFromString(this._configProperties.get(VARIABLES_KEY), " ");
    }

    private Map<String, String> createMapFromString(String mapString, String delimiter) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (mapString != null && mapString.trim().length() > 0) {
            String[] keyValueString = mapString.split(delimiter);
            for (int i = 0; i < keyValueString.length - 1; i += 2) {
                map.put(keyValueString[i], keyValueString[i + 1]);
            }
        }
        return map;
    }

    private Set<String> createSetFromString(String setString, String delimiter) {
        HashSet<String> set = new HashSet<String>();
        if (setString != null && setString.trim().length() > 0) {
            set = new HashSet<String>(Arrays.asList(setString.split(delimiter)));
        }
        return set;
    }

    private static String validateProperty(String key, String value) throws BuilderException {
        String validValue = value.toLowerCase();
        String erroMessage = null;
        if (key.equalsIgnoreCase(REPLICABLE_KEY) || key.equalsIgnoreCase(POM_GEM_KEY) || key.equalsIgnoreCase(BOOTSTRAP_KEY) || key.equalsIgnoreCase(SINGLETON_KEY)) {
            if (!validValue.matches("true|false")) {
                erroMessage = "Invalid " + key + " attribute value, a boolean value is expected";
            }
        } else if (key.equalsIgnoreCase(LIBRARY_TYPE_KEY)) {
            if (!validValue.matches("none|manifest|runtime|interface|client|mergedjar")) {
                erroMessage = "Invalid " + key + " attribute value. Expected values are: none, runtime, interface, client or mergedjar.";
            }
            if (validValue.equalsIgnoreCase("mergedJar")) {
                validValue = "mergedJar";
            }
        } else {
            validValue = value;
        }
        if (erroMessage != null) {
            throw new BuilderException(erroMessage);
        }
        return validValue;
    }
}

