/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.repository.RepositoryBOMException;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;

public class RepositoryBOM {
    public static final String SYSTEM_EXIT_PROPERTY = "RepositoryBOM.system.exit";
    private static final Logger _log = Logger.getLogger(RepositoryBOM.class.getName());

    public static void main(String[] args) {
        int retCode = 0;
        Throwable thrown = null;
        try {
            if (args.length == 0) {
                RepositoryBOM.printUsageOnErrorConsole();
            } else if (args.length == 1) {
                if (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-?")) {
                    RepositoryBOM.printUsageOnErrorConsole();
                    return;
                }
                if (args[0].equalsIgnoreCase("-props")) {
                    RepositoryBOM.printUsageOnErrorConsole();
                    RepositoryBOMException ex = new RepositoryBOMException("-props specified but no properties file followed");
                    _log.throwing(RepositoryBOM.class.getName(), "main", ex);
                    throw ex;
                }
            } else if (args[0].equalsIgnoreCase("-props")) {
                File f = new File(args[1]);
                if (f.exists()) {
                    com.oracle.cie.gdr.external.RepositoryBOM repoBOM = new com.oracle.cie.gdr.external.RepositoryBOM(RepoCommonConfig.loadProperties((File)f));
                    RepositoryBOM.printRmProd(repoBOM.getRMProducts());
                }
            } else {
                RepositoryBOM.printUsageOnErrorConsole();
            }
        }
        catch (Throwable th) {
            System.out.println("Dependency Generator FAILED");
            System.out.println("Exception thrown = " + th.getMessage());
            th.printStackTrace(System.out);
            thrown = th;
            retCode = 1;
        }
        if (retCode != 0) {
            if ("false".equalsIgnoreCase(System.getProperty(SYSTEM_EXIT_PROPERTY))) {
                throw new IllegalStateException(thrown);
            }
            System.exit(retCode);
        }
    }

    private static void printRmProd(List<FeatureSet> products) {
        System.out.println("Name \t Version");
        for (FeatureSet product : products) {
            System.out.println(product.getName() + " " + product.getVersion());
        }
    }

    private static void printUsageOnErrorConsole() {
        System.err.println("RepositoryBOM Entry Point\nReturn all the features with rm-prod attribute\n\nProperties\n----------\nFEATURES             - List of features with the version. Use name:version format.\n                        I.E. test.feature:12.1.2.0.0\nREPOSITORIES         - List of repositores separed by commas.\nCACHE_REPO           - Local repository path.\n");
    }
}

