/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.repository.RepositoryProcessor;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.common.NextGenHelper;
import com.oracle.cie.repository.common.NextGenHelperFactory;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.rest.FolderInfo;
import com.oracle.cie.rest.GavcSearchResult;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import com.oracle.cie.rest.RestHelper;
import com.oracle.cie.rest.impl.RepositoryImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.impl.PatchDeployArtifactImpl;

public class PatchDeployAnalyzer {
    private RestHandler _restHandler = RestFactory.getRestHandler();
    private NextGenHelper _nextGenHelper = NextGenHelperFactory.getNextGenHelper((RestHandler)this._restHandler);
    private RepoCommonConfig _repoCommonConfig;
    private static final Logger _log = Logger.getLogger(PatchDeployAnalyzer.class.getName());
    private RepositoryVersionResolver _versionResolver;
    private RepositoryProcessor _repositoryProcessor;
    private static final Map<String, Map<String, Artifact>> _gavcSearchCache = new HashMap<String, Map<String, Artifact>>();
    private Map<Artifact, PatchDeployArtifact> _patchDeploysMap = new HashMap<Artifact, PatchDeployArtifact>();
    private Collection<Artifact> _componentsWithoutPatchDeploy = new LinkedHashSet<Artifact>();
    private Collection<Artifact> _componentsWithInvalidPatchDeploys = new LinkedHashSet<Artifact>();

    public Map<Artifact, PatchDeployArtifact> getPatchDeploysMap() {
        return this._patchDeploysMap;
    }

    public PatchDeployAnalyzer(List<URL> urls, String username, String password, File localCacheRepo) throws RestException, RepositoryCommonException, IOException, DependencyManagementException {
        this.initialize(urls, username, password, localCacheRepo, null);
    }

    private void initialize(List<URL> urls, String username, String password, File localCacheRepo, Properties properties) throws RestException, RepositoryCommonException, IOException, DependencyManagementException {
        _log.info("Initializing patch deploy analyzer.");
        List<Repository> repositories = this.getRepositories(urls, username, password, localCacheRepo);
        this._repoCommonConfig = RepoCommonConfig.createRepoCommonConfig(repositories, (File)localCacheRepo, (Properties)properties, null);
        if (!this._repoCommonConfig.hasProperty("USE_LATEST")) {
            this._repoCommonConfig.setProperty("USE_LATEST", "false");
        }
        this._versionResolver = this._nextGenHelper.getConfiguredRepositoryVersionResolver(this._repoCommonConfig);
        this._repositoryProcessor = new RepositoryProcessor(this._restHandler, this._versionResolver, null, repositories, false);
    }

    public void scanComponents(String dependencyOverrideCoordinates) throws GdrException {
        block10: {
            _log.info("Scanning components in " + dependencyOverrideCoordinates);
            Collection<Artifact> componentArtifacts = null;
            try {
                componentArtifacts = this.getAllComponents(dependencyOverrideCoordinates);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                _log.info("There was an error while searching for components, continuing...");
            }
            try {
                if (componentArtifacts == null || componentArtifacts.isEmpty()) break block10;
                for (Artifact a : componentArtifacts) {
                    if (!this._restHandler.artifactExists(a, this._repoCommonConfig.getRemoteRepositories())) continue;
                    String entryPath = ComponentHelper.getInstance().getComponentArchiveCarbPath(a.getName(), a.getBaseVersion()) + "/" + "patchDeploy.xml";
                    _log.info("Retrieving patch deploy from artifact : " + a);
                    byte[] patchDeployBytes = null;
                    try {
                        patchDeployBytes = this._restHandler.getArchiveEntryContents(a, entryPath, this._repoCommonConfig.getRemoteRepositories());
                    }
                    catch (RestException e1) {
                        _log.log(Level.WARNING, "Component " + a + " does not have patch deploy.", e1);
                        this._componentsWithoutPatchDeploy.add(a);
                    }
                    if (patchDeployBytes != null) {
                        PatchDeployArtifactImpl patchDeploy = null;
                        try {
                            patchDeploy = new PatchDeployArtifactImpl(this.createPatchDeploy(new String(patchDeployBytes)).getAbsolutePath());
                        }
                        catch (GdrException | PatchMetadataLoadingException e) {
                            e.printStackTrace();
                            _log.log(Level.WARNING, "Component " + a + " has an invalid patch deploy.", e);
                            this._componentsWithInvalidPatchDeploys.add(a);
                        }
                        if (patchDeploy == null) continue;
                        this._patchDeploysMap.put(a, (PatchDeployArtifact)patchDeploy);
                        continue;
                    }
                    this._componentsWithoutPatchDeploy.add(a);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                _log.info("There was an error while searching for patch deploys, continuing...");
            }
        }
    }

    public File createPatchDeploy(String patchDeployContent) throws GdrException {
        File patchDeploy = null;
        OutputStreamWriter writer = null;
        try {
            patchDeploy = File.createTempFile("patchDeploy", ".xml");
            patchDeploy.deleteOnExit();
            writer = new FileWriter(patchDeploy);
            writer.write(patchDeployContent);
        }
        catch (IOException e) {
            throw new GdrException((Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new GdrException((Throwable)e);
                }
            }
        }
        return patchDeploy;
    }

    private Collection<Artifact> getAllComponents(String dependencyOverrideCoordinates) throws RestException, IOException, DependencyManagementException {
        String[] coordinates;
        LinkedHashSet<Artifact> components = new LinkedHashSet<Artifact>();
        RestHelper restHelper = RestFactory.getRestHelper((RestHandler)this._restHandler);
        for (String coordinate : coordinates = dependencyOverrideCoordinates.split(",")) {
            Collection dependencies = restHelper.findDependencies(DependencyManagementFactory.getArtifact((String)coordinate), this._repoCommonConfig.getRemoteRepositories(), "com.oracle.cie.gdr.carb", null, null, "carb", null, null);
            for (Dependency dependency : dependencies) {
                components.add(dependency.getArtifactCopy());
            }
        }
        return components;
    }

    public void printReport() {
        if (!this._componentsWithoutPatchDeploy.isEmpty()) {
            System.out.println("The following components do not have patchDeploy.xml.");
        } else {
            System.out.println("No components without patchDeploy.xml were found.");
        }
        for (Artifact artifact : this._componentsWithoutPatchDeploy) {
            System.out.println(artifact);
        }
        if (!this._componentsWithInvalidPatchDeploys.isEmpty()) {
            System.out.println("The following components have invalid patchDeploy.xml.");
        } else {
            System.out.println("No components with invalid patchDeploy.xml were found.");
        }
        for (Artifact artifact : this._componentsWithInvalidPatchDeploys) {
            System.out.println(artifact);
        }
        if (!this._patchDeploysMap.isEmpty()) {
            System.out.println("The following components have patchDeploy.xml.");
        } else {
            System.out.println("No components with patchDeploy.xml were found.");
        }
        for (Map.Entry entry : this._patchDeploysMap.entrySet()) {
            System.out.println(entry.getKey());
        }
    }

    private Map<String, Artifact> getUniqueArtifactsMap(String groupId, String type, String baseVersion) throws RestException {
        Map<String, Artifact> uniqueArtifacts = new HashMap<String, Artifact>();
        for (Repository repository : this._repoCommonConfig.getRepositories()) {
            if (_gavcSearchCache.containsKey(groupId + "_" + repository)) {
                uniqueArtifacts = _gavcSearchCache.get(groupId + "_" + repository);
                continue;
            }
            GavcSearchResult gavcSearchResult = this._restHandler.gavcSearch(groupId, null, baseVersion, null, repository, true);
            if (gavcSearchResult != null && gavcSearchResult.getArtifactMap() != null) {
                for (Map.Entry entry : gavcSearchResult.getArtifactMap().entrySet()) {
                    Artifact artifact;
                    String uniqueKey = ((Artifact)entry.getKey()).getName() + "_" + ((Artifact)entry.getKey()).getBaseVersion();
                    if (uniqueArtifacts.containsKey(uniqueKey) || !this._restHandler.artifactExists(artifact = DependencyManagementFactory.getInstance().getArtifact(groupId, ((Artifact)entry.getKey()).getName(), ((Artifact)entry.getKey()).getVersion(), type), repository)) continue;
                    uniqueArtifacts.put(uniqueKey, (Artifact)entry.getKey());
                }
            }
            _gavcSearchCache.put(groupId + "_" + repository, uniqueArtifacts);
        }
        return uniqueArtifacts;
    }

    private Collection<Artifact> searchArtifacts(String groupId, String version) throws RestException, IOException {
        ArrayList<String> componentNames = new ArrayList<String>();
        ArrayList<Artifact> components = new ArrayList<Artifact>();
        for (Repository repository : this._repoCommonConfig.getRepositories()) {
            List folders;
            FolderInfo folderInfo = this._restHandler.getFolderInfo(repository, groupId.replace(".", "/"));
            List list = folders = folderInfo != null ? folderInfo.getFolders() : null;
            if (folders == null) continue;
            for (String folder : folders) {
                componentNames.add(folder);
            }
        }
        for (String component : componentNames) {
            String componentName = component;
            Version latestComponentVersion = this._restHandler.latestVersionSearch(groupId, componentName, version, this._repoCommonConfig.getRemoteRepositories());
            if (latestComponentVersion == null) continue;
            Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(groupId, componentName, latestComponentVersion.toString(), "carb");
            components.add(artifact);
        }
        return components;
    }

    private List<Repository> getRepositories(List<URL> urls, String username, String password, File localCacheRepo) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (URL url : urls) {
            repositories.add((Repository)new RepositoryImpl(null, RepositoryType.REMOTE, url.toString(), null, username, password));
        }
        return repositories;
    }

    public Collection<Artifact> getComponentsWithoutPatchDeploy() {
        return this._componentsWithoutPatchDeploy;
    }

    public Collection<Artifact> getComponentsWithInvalidPatchDeploys() {
        return this._componentsWithInvalidPatchDeploys;
    }

    public Collection<Artifact> getComponentsWithPatchDeploy() {
        if (this._patchDeploysMap != null) {
            return this._patchDeploysMap.keySet();
        }
        return null;
    }
}

