/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.ZipHelper;
import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.BuilderFactory;
import com.oracle.cie.gdr.external.builder.ComponentBuilder;
import com.oracle.cie.gdr.external.builder.DirectoryBuilder;
import com.oracle.cie.gdr.external.builder.FeatureSetBuilder;
import com.oracle.cie.gdr.external.builder.FeatureSetGroupBuilder;
import com.oracle.cie.gdr.external.builder.FeatureSetReferenceBuilder;
import com.oracle.cie.gdr.external.builder.FileBuilder;
import com.oracle.cie.gdr.external.builder.FileMapBuilder;
import com.oracle.cie.gdr.external.builder.SectionBuilder;
import com.oracle.cie.gdr.external.builder.impl.DistributionBuilderImpl;
import com.oracle.cie.gdr.external.builder.impl.DistributionInfoBuilderImpl;
import com.oracle.cie.gdr.external.builder.impl.FeatureLibraryBuilderImpl;
import com.oracle.cie.gdr.external.builder.impl.StringsubsBuilderImpl;
import com.oracle.cie.gdr.external.builder.impl.StringsubsGroupBuilderImpl;
import com.oracle.cie.gdr.generation.ComponentGenerationConfig;
import com.oracle.cie.gdr.generation.DistributionGenerationConfig;
import com.oracle.cie.gdr.generation.DistributionInfoGenerationConfig;
import com.oracle.cie.gdr.generation.FeatureSetGenerationConfig;
import com.oracle.cie.gdr.generation.GenerationConfig;
import com.oracle.cie.gdr.generation.MetadataGenerationConfig;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.repository.common.CommonCommandLine;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NextGenMetadataGenerator
extends CommonCommandLine {
    private static final Logger _log = Logger.getLogger(NextGenMetadataGenerator.class.getName());
    private File _sourceFile;
    private File _sourceDirectory;
    private File _gdrRoot;
    private File _propertiesFile;
    private MetadataGenerationConfig _config;
    private String _defualtName;
    private static final String _propertiesFileName = "nextGenGenerator.properties";

    public static void main(String[] args) {
        int retVal = 0;
        try {
            LinkedHashMap<String, String> additionalArgs = new LinkedHashMap<String, String>();
            additionalArgs.put("gdrRoot", "</path.to/gdr/root/dir>");
            additionalArgs.put("source", "<The source file to generate the Metadata>");
            additionalArgs.put("propsGeneration", "<The properties file to generate the Metadata>");
            additionalArgs.put("destinationUnzippedDirectory", "<The destination for unzip the inputFile>");
            NextGenMetadataGenerator.getRepoCommonConfig((String[])args, additionalArgs, (String)"stdout");
            Map additionalArgValues = NextGenMetadataGenerator.getAdditionalArgumentValues();
            String gdrRoot = (String)additionalArgValues.get("gdrRoot");
            if (StringUtil.isNullOrEmpty((String)gdrRoot)) {
                throw new BuilderException("The \"-gdrRoot\" argument is required.");
            }
            String sourceFileString = (String)additionalArgValues.get("source");
            if (StringUtil.isNullOrEmpty((String)sourceFileString)) {
                throw new BuilderException("The \"-source\" argument is required.");
            }
            File sourceFile = new File(sourceFileString);
            File destinationUnzippedDirectory = null;
            if (ZipHelper.isZipFile((File)sourceFile)) {
                String destinationUnzippedDirectoryString = (String)additionalArgValues.get("destinationUnzippedDirectory");
                if (StringUtil.isNullOrEmpty((String)destinationUnzippedDirectoryString)) {
                    throw new BuilderException("The \"-destinationUnzippedDirectory\" argument is required due to \"-source\" is a zip file .");
                }
                destinationUnzippedDirectory = new File(destinationUnzippedDirectoryString);
            }
            File propertiesFile = null;
            String propertiesString = (String)additionalArgValues.get("propsGeneration");
            if (!StringUtil.isNullOrEmpty((String)propertiesString)) {
                propertiesFile = new File(propertiesString);
            }
            NextGenMetadataGenerator generator = destinationUnzippedDirectory != null ? new NextGenMetadataGenerator(sourceFile, new File(gdrRoot), propertiesFile, destinationUnzippedDirectory) : new NextGenMetadataGenerator(sourceFile, new File(gdrRoot), propertiesFile);
            generator.generateMetadata();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Metadata generation failed.", e);
            e.printStackTrace();
            retVal = -1;
        }
        System.exit(retVal);
    }

    public NextGenMetadataGenerator(File sourceZipFile, File gdrRoot, File propertiesFile, File destinationUnzippedDirectory) throws BuilderException {
        this._defualtName = FileUtils.removeExtension(sourceZipFile);
        this._propertiesFile = this.retrievePropertiesFile(sourceZipFile, destinationUnzippedDirectory);
        if (propertiesFile != null) {
            this._propertiesFile = propertiesFile;
        }
        this._sourceDirectory = destinationUnzippedDirectory;
        this._sourceFile = sourceZipFile;
        this._gdrRoot = gdrRoot;
    }

    public NextGenMetadataGenerator(File sourceDirectory, File gdrRoot, File propertiesFile) throws BuilderException {
        this._defualtName = FileUtils.removeExtension(sourceDirectory);
        this._gdrRoot = gdrRoot;
        this._propertiesFile = propertiesFile;
        this._sourceFile = sourceDirectory;
        this._sourceDirectory = sourceDirectory;
    }

    private File retrievePropertiesFile(File sourceFile, File destinationUnzippedDirectory) throws BuilderException {
        try {
            File propetiesFile = null;
            if (ZipHelper.isZipFile((File)sourceFile)) {
                ZipHelper.unzip((File)sourceFile, (File)destinationUnzippedDirectory);
                File[] propertiesFiles = destinationUnzippedDirectory.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File arg0) {
                        return arg0.getName().equals(NextGenMetadataGenerator._propertiesFileName);
                    }
                });
                if (propertiesFiles != null && propertiesFiles.length > 0) {
                    propetiesFile = propertiesFiles[0];
                }
            }
            return propetiesFile;
        }
        catch (FileNotFoundException e) {
            throw new BuilderException(e);
        }
        catch (IOException e) {
            throw new BuilderException(e);
        }
    }

    public void createDistributionDefinition(File destinationDirectory) throws BuilderException {
        DistributionGenerationConfig distributionConfig = this._config.getDistributionGenerationConfig();
        DistributionBuilderImpl distributionBuilder = new DistributionBuilderImpl(distributionConfig.getName(), distributionConfig.getVersion());
        distributionBuilder.setDescriptionKey(distributionConfig.getDesciptionKey());
        distributionBuilder.setExternalName(distributionConfig.getExternalName());
        distributionBuilder.setExternalNameKey(distributionConfig.getExternalNameKey());
        distributionBuilder.setExternalShortName(distributionConfig.getExternalShortName());
        distributionBuilder.setExternalShortNameKey(distributionConfig.getExternalShortNameKey());
        distributionBuilder.setExternalVersion(distributionConfig.getExternalVersion());
        Map<String, List<FeatureSetReferenceBuilder>> featuresetGroupsMap = distributionConfig.getFeatureSetGroups();
        for (Map.Entry<String, List<FeatureSetReferenceBuilder>> entry : featuresetGroupsMap.entrySet()) {
            String[] nameDisplayName = entry.getKey().split(":");
            FeatureSetGroupBuilder fsetGrupBuilder = distributionBuilder.addFeatureSetGroup(nameDisplayName[0], nameDisplayName[1]);
            fsetGrupBuilder.setFeatusetRefeneces(entry.getValue());
        }
        for (Map.Entry<String, Collection<Object>> entry : distributionConfig.getDirectorySymbols().entrySet()) {
            distributionBuilder.addMapping(entry.getKey(), new ArrayList<Object>(entry.getValue()));
        }
        if (distributionConfig.getRootMappingSymbols() != null && !distributionConfig.getRootMappingSymbols().isEmpty()) {
            distributionBuilder.setRootMapping(distributionConfig.getRootMappingSymbols());
        }
        distributionBuilder.save(destinationDirectory);
    }

    public void createDistributionInfoDefinition(File destinationDirectory) throws BuilderException {
        DistributionInfoGenerationConfig distConfig = this._config.getDistributionInfoGenerationConfig();
        DistributionInfoBuilderImpl distributionInfo = new DistributionInfoBuilderImpl(this._config.getDistributionGenerationConfig().getName(), this._config.getDistributionGenerationConfig().getVersion());
        distributionInfo.setProductFamilies(distConfig.getProductFamilies());
        distributionInfo.setPlatforms(distConfig.getPlatforms(), distConfig.getGenerateDefaultOraparam());
        List<SectionBuilder> sections = distConfig.getSections();
        for (SectionBuilder section : sections) {
            distributionInfo.addSection(section);
        }
        Map<String, List<String>> properties = distConfig.getShiphomeProperties();
        if (properties != null) {
            for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
                distributionInfo.addShiphomeProperty(entry.getKey(), entry.getValue().toArray(new String[entry.getValue().size()]));
            }
        }
        distributionInfo.save(destinationDirectory);
    }

    public File getSourceDirectory() {
        return this._sourceDirectory;
    }

    public void generateMetadata() throws BuilderException {
        this._config = new MetadataGenerationConfig(this._defualtName, this._propertiesFile, this._sourceDirectory);
        this.createDistributionDefinition(this._gdrRoot);
        this.createDistributionInfoDefinition(this._gdrRoot);
        for (Map.Entry<String, GenerationConfig> featuresetConfig : this._config.getFeatureSetGenerationConfigs().entrySet()) {
            this.createFeatureSetDefinition(featuresetConfig.getValue(), this._gdrRoot);
        }
        for (Map.Entry<String, GenerationConfig> componentConfig : this._config.getComponentGenerationConfigs().entrySet()) {
            this.createComponentDefinition(componentConfig.getValue(), this._gdrRoot);
        }
    }

    private void createFeatureSetDefinition(GenerationConfig config, File destinationDirectory) throws BuilderException {
        FeatureSetGenerationConfig featureSetConfig = (FeatureSetGenerationConfig)config;
        FeatureSetBuilder feature = BuilderFactory.getFeatureSetBuilder(featureSetConfig.getName(), featureSetConfig.getVersion());
        feature.setDescriptionKey(featureSetConfig.getDescriptionKey());
        feature.setDescription(featureSetConfig.getDescription());
        feature.setDisplayName(featureSetConfig.getDisplayName());
        feature.setDisplayNameKey(featureSetConfig.getDisplayNameKey());
        feature.setType(featureSetConfig.getType());
        feature.setSubType(featureSetConfig.getSubType());
        feature.setConsumptionType(featureSetConfig.getConsumptionType());
        feature.setSingleton(featureSetConfig.getSingleton());
        feature.setPomGen(featureSetConfig.getPomGen());
        feature.setMultiVersion(featureSetConfig.getMultiVersion());
        feature.setThirdParty(featureSetConfig.getThirdParty());
        feature.addComponents(featureSetConfig.getComponents());
        if (featureSetConfig.getLibraryName() != null) {
            FeatureLibraryBuilderImpl featureLibrary = new FeatureLibraryBuilderImpl(featureSetConfig.getLibraryName(), featureSetConfig.getLibraryType());
            featureLibrary.setVisibility(featureSetConfig.getLibraryVisibility());
            featureLibrary.setIgnoreVersion(featureSetConfig.getLibraryIgnoreVersion());
            featureLibrary.setLocation(featureSetConfig.getLibraryLocation());
            featureLibrary.setSuppressPrefix(featureSetConfig.getLibrarySuppressPrefix());
            featureLibrary.setIncludes(featureSetConfig.getLibraryIncludes());
            featureLibrary.setSuppressVersion(featureSetConfig.getLibrarySuppressVersion());
            feature.addLibrary(featureLibrary);
        }
        feature.addAndDependencies(featureSetConfig.getDependencies());
        feature.save(destinationDirectory);
        _log.info("Featureset definition created successfully:" + new File(new File(destinationDirectory, FeatureSetHelper.getInstance().getPath()), FeatureSetHelper.getInstance().getFeatureSetFileName(feature.getName(), feature.getVersion())));
    }

    private void createComponentDefinition(GenerationConfig config, File destinationDirectory) throws BuilderException {
        ComponentGenerationConfig componentConfig = (ComponentGenerationConfig)config;
        ComponentBuilder component = BuilderFactory.getComponentBuilder(componentConfig.getName(), componentConfig.getVersion());
        component.setDescriptionKey(componentConfig.getDescriptionKey());
        component.setDescription(componentConfig.getDescription());
        component.setReplicable(componentConfig.getReplicable());
        component.setSingleton(componentConfig.getSingleton());
        component.setPomGen(componentConfig.getPomGen());
        component.setVariables(componentConfig.getVariables());
        if (componentConfig.getLibraryName() != null) {
            component.addLibrary(componentConfig.getLibraryName(), componentConfig.getLibraryType(), componentConfig.getLibraryEntries());
        }
        FileMapBuilder fileMap = component.addFileMap(componentConfig.getSymbol());
        fileMap.setBootstrap(componentConfig.getBootstrap());
        Set<String> payloadSet = componentConfig.getPayload();
        if (payloadSet == null || payloadSet.isEmpty()) {
            if (this._sourceFile.isDirectory()) {
                fileMap.addDirectory(this._sourceFile.getAbsolutePath(), "");
            } else {
                fileMap.addFile(this._sourceFile.getAbsolutePath(), this._sourceFile.getAbsolutePath());
            }
        } else {
            List<FileBuilder> files;
            List<DirectoryBuilder> directories = componentConfig.getDirectories();
            if (directories != null && !directories.isEmpty()) {
                for (DirectoryBuilder directoryBuilder : directories) {
                    fileMap.addDirectory(directoryBuilder);
                }
            }
            if ((files = componentConfig.getFiles()) != null && !files.isEmpty()) {
                for (FileBuilder file : files) {
                    fileMap.addFile(file);
                }
            }
        }
        List<String> stringsubsFiles = componentConfig.getStringsubsFiles();
        List<String> stringsubsFilesChangePairs = componentConfig.getStringsubsChangePairs();
        if (!stringsubsFiles.isEmpty()) {
            StringsubsBuilderImpl stringsubsBuilderImpl = new StringsubsBuilderImpl();
            StringsubsGroupBuilderImpl stringsubsGroupBuilder = new StringsubsGroupBuilderImpl(this._defualtName);
            if (!stringsubsFilesChangePairs.isEmpty()) {
                for (String stringsubsFilesChangePair : stringsubsFilesChangePairs) {
                    String[] idBeforeAfter = stringsubsFilesChangePair.split(":");
                    stringsubsBuilderImpl.addStringsubsChangePair(idBeforeAfter[0], idBeforeAfter[1], idBeforeAfter[2]);
                }
            }
            stringsubsGroupBuilder.setFileEntry(stringsubsFiles);
            stringsubsGroupBuilder.setStringsubsChangePairRefs(stringsubsBuilderImpl.getStringsubsChangePairIds());
            stringsubsBuilderImpl.addStringsubsGroup(stringsubsGroupBuilder);
            component.setStringsubs(stringsubsBuilderImpl);
        }
        fileMap.setPlatforms(componentConfig.getPlatforms());
        fileMap.setLocales(componentConfig.getLocales());
        component.save(destinationDirectory);
        _log.info("Component definition created successfully:" + new File(ComponentHelper.getInstance().getComponentArchiveDir(destinationDirectory, component.getName(), component.getVersion()), ComponentHelper.getComponentDefFileName()));
    }
}

