/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.inv.ComponentGroupReference;
import com.oracle.cie.gdr.dao.inv.ComponentReference;
import com.oracle.cie.gdr.dao.inv.DistributionGroupReference;
import com.oracle.cie.gdr.dao.inv.DistributionReference;
import com.oracle.cie.gdr.dao.inv.FeatureSetGroupReference;
import com.oracle.cie.gdr.dao.inv.FeatureSetReference;
import com.oracle.cie.gdr.dao.inv.OracleHomeReference;
import com.oracle.cie.gdr.dao.inv.PatchGroupReference;
import com.oracle.cie.gdr.dao.inv.PatchReference;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.InventoryFactory;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import com.oracle.cie.gdr.external.Patch;
import com.oracle.cie.gdr.helpers.InventoryCompareHelper;
import com.oracle.cie.gdr.helpers.InventoryHelper;
import com.oracle.cie.gdr.services.CompatibilityService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InventoryCompare {
    private static final String OH_INDENT = " ";
    private static final String DIST_INDENT = "   ";
    private static final String FTR_INDENT = "     ";
    private static final String COMP_INDENT = "       ";
    private static final String PATCH_INDENT = "         ";
    private static final String FIRST_ORACLE_HOME_ARG = "-oracle_home1";
    private static final String SECOND_ORACLE_HOME_ARG = "-oracle_home2";
    private static final String OUTPUT_FILE_ARG = "-output_file";
    private static final String OUTPUT_TYPE_ARG = "-output_type";
    private static final String INPUT_TYPE_1_ARG = "-input_type1";
    private static final String INPUT_TYPE_2_ARG = "-input_type2";
    private static final String EXTENDED_ARG = "-extended";
    private static final String JRE_LOC = "-jreLoc";
    private static final String HELP = "-help";
    public static final String EXTENDED = "-extended";
    private static final String CSV = "csv";
    private static final String XML = "xml";
    private static final String DIR = "dir";
    private static final String REPORT = "report";
    public static final String OH1 = "oh1";
    public static final String OH2 = "oh2";
    public static final String BOTH = "both";
    private File _outputFile;
    private File _firstOracleHome;
    private File _secondOracleHome;
    private String _outputType;
    private String _inputType1;
    private String _inputType2;
    private boolean _isExtended;
    private boolean _help;
    private com.oracle.cie.gdr.dao.icm.InventoryCompare _inventoryCompare;

    public InventoryCompare() {
    }

    public InventoryCompare(File firstOracleHome, File secondOracleHome) {
        this._firstOracleHome = firstOracleHome;
        this._secondOracleHome = secondOracleHome;
    }

    public InventoryCompare(File outputFile) throws IOException, DataHandlerException {
        this._outputFile = outputFile;
        this._inventoryCompare = (com.oracle.cie.gdr.dao.icm.InventoryCompare)InventoryCompareHelper.getInstance().getRootWrapper(outputFile);
    }

    public com.oracle.cie.gdr.dao.icm.InventoryCompare compare() throws Exception {
        if (this.getFirstOracleHome() == null || this.getSecondOracleHome() == null) {
            throw new InventoryException("The 2 oracle homes are needed to compare.");
        }
        List<DistributionReference> distributionsList = this.compareDistributions(this.getDistributionGroupReference(this.getFirstOracleHome(), this._inputType1), this.getDistributionGroupReference(this.getSecondOracleHome(), this._inputType2));
        com.oracle.cie.gdr.dao.icm.InventoryCompare inventoryCompare = new com.oracle.cie.gdr.dao.icm.InventoryCompare();
        OracleHomeReference home = new OracleHomeReference(new DistributionGroupReference(distributionsList));
        File oracleHome1 = this.getFirstOracleHome();
        File oracleHome2 = this.getSecondOracleHome();
        if (oracleHome1.isFile() && oracleHome1.getAbsolutePath().endsWith(".xml")) {
            OracleHomeReference oracleHomeRef = (OracleHomeReference)InventoryHelper.getInstance().getRootWrapper(oracleHome1);
            oracleHome1 = new File(oracleHomeRef.getDirectory());
        } else if (oracleHome2.isFile() && oracleHome2.getAbsolutePath().endsWith(".xml")) {
            OracleHomeReference oracleHomeRef = (OracleHomeReference)InventoryHelper.getInstance().getRootWrapper(oracleHome2);
            oracleHome2 = new File(oracleHomeRef.getDirectory());
        }
        home.setNextGenVersion(CompatibilityService.getInstance().getLatestVersion(oracleHome1, oracleHome2));
        inventoryCompare.setOracleHome(home);
        inventoryCompare.setOracleHome1(this.getFirstOracleHome().getAbsolutePath());
        inventoryCompare.setOracleHome2(this.getSecondOracleHome().getAbsolutePath());
        this._inventoryCompare = inventoryCompare;
        return inventoryCompare;
    }

    private Collection<DistributionReference> getDistributionGroupReference(File file, String inputType) throws Exception {
        if (StringUtil.isNullOrEmpty((String)inputType)) {
            if (file.isDirectory()) {
                OracleHomeInventory ohInv1 = InventoryFactory.getOracleHomeInventory(file);
                return this.convertDistributionGroupReference(ohInv1.getInstalledDistributions(), file);
            }
            if (file.getAbsolutePath().endsWith(XML)) {
                try {
                    return ((OracleHomeReference)InventoryHelper.getInstance().getRootWrapper(file)).getDistributionGroup().getDistributions();
                }
                catch (Exception exception) {
                    throw new Exception(exception);
                }
            }
        } else {
            if (inputType.equals(DIR) && file.isDirectory()) {
                OracleHomeInventory ohInv1 = InventoryFactory.getOracleHomeInventory(file);
                return this.convertDistributionGroupReference(ohInv1.getInstalledDistributions(), file);
            }
            if (inputType.equals(XML)) {
                if (!file.getAbsolutePath().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
                try {
                    return ((OracleHomeReference)InventoryHelper.getInstance().getRootWrapper(file)).getDistributionGroup().getDistributions();
                }
                catch (Exception exception) {
                    throw new InventoryException(exception);
                }
            }
            if (inputType.equals(DIR) && !file.isDirectory()) {
                throw new Exception("Input type is dir but oracle home " + file.getAbsolutePath() + " is not a valid directory.");
            }
        }
        return null;
    }

    private Collection<DistributionReference> convertDistributionGroupReference(Collection<Distribution> distributions, File file) throws InventoryException {
        OracleHomeInventory ohInv = InventoryFactory.getOracleHomeInventory(file);
        ArrayList<DistributionReference> distributionsReferences = new ArrayList<DistributionReference>();
        DistributionReference distributionReference = null;
        for (Distribution distribution : distributions) {
            if (!ohInv.isDistributionInstalled(distribution.getName(), distribution.getVersion())) continue;
            distributionReference = new DistributionReference(distribution.getName(), distribution.getVersion(), new FeatureSetGroupReference(new ArrayList<FeatureSetReference>(this.convertFeatures(distribution.getFeatureSets(), file))));
            distributionsReferences.add(distributionReference);
        }
        return distributionsReferences;
    }

    private Collection<FeatureSetReference> convertFeatures(Collection<FeatureSet> features, File file) throws InventoryException {
        OracleHomeInventory ohInv = InventoryFactory.getOracleHomeInventory(file);
        ArrayList<FeatureSetReference> featuresReferences = new ArrayList<FeatureSetReference>();
        FeatureSetReference featureReference = null;
        for (FeatureSet feature : features) {
            if (!ohInv.isFeatureSetinstalled(feature.getName(), feature.getVersion())) continue;
            featureReference = new FeatureSetReference(feature.getName(), feature.getVersion(), new ComponentGroupReference(new ArrayList<ComponentReference>(this.convertComponents(feature.getComponents(), file))), feature.getType(), feature.getSubType());
            featuresReferences.add(featureReference);
        }
        return featuresReferences;
    }

    private Collection<ComponentReference> convertComponents(Collection<Component> components, File file) throws InventoryException {
        OracleHomeInventory ohInv = InventoryFactory.getOracleHomeInventory(file);
        ArrayList<ComponentReference> componentsReferences = new ArrayList<ComponentReference>();
        ComponentReference componentReference = null;
        for (Component component : components) {
            if (!ohInv.isComponentInstalled(component.getName(), component.getVersion())) continue;
            componentReference = new ComponentReference(component.getName(), component.getVersion(), new PatchGroupReference(new ArrayList<PatchReference>(this.convertPatches(component.getPatches(), file))));
            componentsReferences.add(componentReference);
        }
        return componentsReferences;
    }

    private Collection<PatchReference> convertPatches(Collection<Patch> patches, File file) throws InventoryException {
        ArrayList<PatchReference> patchesReferences = new ArrayList<PatchReference>();
        PatchReference patchReference = null;
        OracleHomeInventory ohInv = InventoryFactory.getOracleHomeInventory(file);
        for (Patch patch : patches) {
            if (!ohInv.isPatchInstalled(patch.getPatchId())) continue;
            patchReference = new PatchReference(patch.getPatchId(), patch.getUniquePatchId());
            patchesReferences.add(patchReference);
        }
        return patchesReferences;
    }

    private List<DistributionReference> compareDistributions(Collection<DistributionReference> distributionsReferences1, Collection<DistributionReference> distributionsReferences2) {
        LinkedHashMap<DistributionReference, DistributionReference> distsDiffs = new LinkedHashMap<DistributionReference, DistributionReference>();
        if (distributionsReferences1.size() >= distributionsReferences2.size()) {
            for (DistributionReference distRef : distributionsReferences1) {
                distRef.setOracleHomeDiff(OH1);
                distsDiffs.put(distRef, distRef);
            }
            for (DistributionReference distRef : distributionsReferences2) {
                if (distsDiffs.containsKey((Object)distRef)) {
                    ((DistributionReference)((Object)distsDiffs.get((Object)distRef))).setOracleHomeDiff(BOTH);
                    distRef.setOracleHomeDiff(BOTH);
                    if (((DistributionReference)((Object)distsDiffs.get((Object)distRef))).getFeatureSetGroup() != null && ((DistributionReference)((Object)distsDiffs.get((Object)distRef))).getFeatureSetGroup().getFeatureSets() != null && distRef.getFeatureSetGroup() != null && distRef.getFeatureSetGroup().getFeatureSets() != null) {
                        this.compareFeatures(((DistributionReference)((Object)distsDiffs.get((Object)distRef))).getFeatureSetGroup().getFeatureSets(), distRef.getFeatureSetGroup().getFeatureSets());
                        continue;
                    }
                    if (((DistributionReference)((Object)distsDiffs.get((Object)distRef))).getFeatureSetGroup() != null && ((DistributionReference)((Object)distsDiffs.get((Object)distRef))).getFeatureSetGroup().getFeatureSets() != null) {
                        this.markAsDiff(OH1, (DistributionReference)((Object)distsDiffs.get((Object)distRef)));
                        continue;
                    }
                    if (distRef.getFeatureSetGroup() == null || distRef.getFeatureSetGroup().getFeatureSets() == null) continue;
                    this.markAsDiff(OH2, distRef);
                    continue;
                }
                distRef.setOracleHomeDiff(OH2);
                this.markAsDiff(OH2, distRef);
                distsDiffs.put(distRef, distRef);
            }
            for (DistributionReference distRef : distsDiffs.values()) {
                if (!distRef.getOracleHomeDiff().equals(OH1) && !distRef.getOracleHomeDiff().equals(OH2)) continue;
                this.markAsDiff(distRef.getOracleHomeDiff(), distRef);
            }
        }
        return new LinkedList<DistributionReference>(distsDiffs.values());
    }

    private void compareFeatures(Collection<FeatureSetReference> featuresReferences1, Collection<FeatureSetReference> featuresReferences2) {
        LinkedHashMap<FeatureSetReference, FeatureSetReference> featuresDiffs = new LinkedHashMap<FeatureSetReference, FeatureSetReference>();
        if (featuresReferences1.size() >= featuresReferences2.size()) {
            for (FeatureSetReference featureRef : featuresReferences1) {
                featureRef.setOracleHomeDiff(OH1);
                featuresDiffs.put(featureRef, featureRef);
            }
            for (FeatureSetReference featureRef : featuresReferences2) {
                if (featuresDiffs.containsKey((Object)featureRef)) {
                    ((FeatureSetReference)((Object)featuresDiffs.get((Object)featureRef))).setOracleHomeDiff(BOTH);
                    featureRef.setOracleHomeDiff(BOTH);
                    if (((FeatureSetReference)((Object)featuresDiffs.get((Object)featureRef))).getComponentGroup() != null && ((FeatureSetReference)((Object)featuresDiffs.get((Object)featureRef))).getComponentGroup().getComponents() != null && featureRef.getComponentGroup() != null && featureRef.getComponentGroup().getComponents() != null) {
                        this.compareComponents(((FeatureSetReference)((Object)featuresDiffs.get((Object)featureRef))).getComponentGroup().getComponents(), featureRef.getComponentGroup().getComponents());
                        continue;
                    }
                    if (((FeatureSetReference)((Object)featuresDiffs.get((Object)featureRef))).getComponentGroup() != null && ((FeatureSetReference)((Object)featuresDiffs.get((Object)featureRef))).getComponentGroup().getComponents() != null) {
                        this.markAsDiff(OH1, (FeatureSetReference)((Object)featuresDiffs.get((Object)featureRef)));
                        continue;
                    }
                    if (featureRef.getComponentGroup() == null || featureRef.getComponentGroup().getComponents() == null) continue;
                    this.markAsDiff(OH2, featureRef);
                    continue;
                }
                featureRef.setOracleHomeDiff(OH2);
                this.markAsDiff(OH2, featureRef);
            }
            for (FeatureSetReference featureRef : featuresDiffs.values()) {
                if (!featureRef.getOracleHomeDiff().equals(OH1) && !featureRef.getOracleHomeDiff().equals(OH2)) continue;
                this.markAsDiff(featureRef.getOracleHomeDiff(), featureRef);
            }
        }
    }

    private void compareComponents(Collection<ComponentReference> componentsReferences1, Collection<ComponentReference> componentsReferences2) {
        LinkedHashMap<ComponentReference, ComponentReference> componentsDiffs = new LinkedHashMap<ComponentReference, ComponentReference>();
        if (componentsReferences1.size() >= componentsReferences2.size()) {
            for (ComponentReference componentRef : componentsReferences1) {
                componentRef.setOracleHomeDiff(OH1);
                componentsDiffs.put(componentRef, componentRef);
            }
            for (ComponentReference componentRef : componentsReferences2) {
                if (componentsDiffs.containsKey((Object)componentRef)) {
                    ((ComponentReference)((Object)componentsDiffs.get((Object)componentRef))).setOracleHomeDiff(BOTH);
                    componentRef.setOracleHomeDiff(BOTH);
                    if (((ComponentReference)((Object)componentsDiffs.get((Object)componentRef))).getPatchGroup() != null && ((ComponentReference)((Object)componentsDiffs.get((Object)componentRef))).getPatchGroup().getPatches() != null && componentRef.getPatchGroup() != null && componentRef.getPatchGroup().getPatches() != null) {
                        this.comparePatches(((ComponentReference)((Object)componentsDiffs.get((Object)componentRef))).getPatchGroup().getPatches(), componentRef.getPatchGroup().getPatches());
                        continue;
                    }
                    if (((ComponentReference)((Object)componentsDiffs.get((Object)componentRef))).getPatchGroup() != null && ((ComponentReference)((Object)componentsDiffs.get((Object)componentRef))).getPatchGroup().getPatches() != null) {
                        this.markAsDiff(OH1, (ComponentReference)((Object)componentsDiffs.get((Object)componentRef)));
                        continue;
                    }
                    if (componentRef.getPatchGroup() == null || componentRef.getPatchGroup().getPatches() == null) continue;
                    this.markAsDiff(OH2, componentRef);
                    continue;
                }
                componentRef.setOracleHomeDiff(OH2);
                this.markAsDiff(OH2, componentRef);
            }
            for (ComponentReference componentRef : componentsDiffs.values()) {
                if (!componentRef.getOracleHomeDiff().equals(OH1) && !componentRef.getOracleHomeDiff().equals(OH2)) continue;
                this.markAsDiff(componentRef.getOracleHomeDiff(), componentRef);
            }
        }
    }

    private void comparePatches(Collection<PatchReference> patchesReferences1, Collection<PatchReference> patchesReferences2) {
        LinkedHashMap<PatchReference, PatchReference> patchesDiffs = new LinkedHashMap<PatchReference, PatchReference>();
        if (patchesReferences1.size() >= patchesReferences2.size()) {
            for (PatchReference patchRef : patchesReferences1) {
                patchRef.setOracleHomeDiff(OH1);
                patchesDiffs.put(patchRef, patchRef);
            }
            for (PatchReference patchRef : patchesReferences2) {
                if (patchesDiffs.containsKey((Object)patchRef)) {
                    ((PatchReference)((Object)patchesDiffs.get((Object)patchRef))).setOracleHomeDiff(BOTH);
                    patchRef.setOracleHomeDiff(BOTH);
                    continue;
                }
                patchRef.setOracleHomeDiff(OH2);
                this.markAsDiff(OH2, patchRef);
            }
            for (PatchReference patchRef : patchesDiffs.values()) {
                if (!patchRef.getOracleHomeDiff().equals(OH1) && !patchRef.getOracleHomeDiff().equals(OH2)) continue;
                this.markAsDiff(patchRef.getOracleHomeDiff(), patchRef);
            }
        }
    }

    private void markAsDiff(String diff, DistributionReference distRef) {
        if (distRef.getFeatureSetGroup() != null && distRef.getFeatureSetGroup().getFeatureSets() != null) {
            for (FeatureSetReference featureRef : distRef.getFeatureSetGroup().getFeatureSets()) {
                this.markAsDiff(diff, featureRef);
            }
        }
    }

    private void markAsDiff(String diff, FeatureSetReference featureRef) {
        featureRef.setOracleHomeDiff(diff);
        if (featureRef.getComponentGroup() != null && featureRef.getComponentGroup().getComponents() != null) {
            for (ComponentReference compRef : featureRef.getComponentGroup().getComponents()) {
                this.markAsDiff(diff, compRef);
            }
        }
    }

    private void markAsDiff(String diff, ComponentReference compRef) {
        compRef.setOracleHomeDiff(diff);
        if (compRef.getPatchGroup() != null && compRef.getPatchGroup().getPatches() != null) {
            for (PatchReference patchRef : compRef.getPatchGroup().getPatches()) {
                this.markAsDiff(diff, patchRef);
            }
        }
    }

    private void markAsDiff(String diff, PatchReference patchRef) {
        patchRef.setOracleHomeDiff(diff);
    }

    public void exportToCSV(File file) throws IOException {
        this._outputFile = file;
        try (FileOutputStream out = null;){
            out = new FileOutputStream(this._outputFile);
            out.write(("Oracle Home1," + this._inventoryCompare.getOracleHome1() + System.getProperty("line.separator")).getBytes());
            out.write(("Oracle Home2," + this._inventoryCompare.getOracleHome2() + System.getProperty("line.separator")).getBytes());
            this.writeHomeReferenceToCSV(this._inventoryCompare.getOracleHome(), out);
            out.flush();
        }
    }

    private void writeHomeReferenceToCSV(OracleHomeReference homeRef, FileOutputStream out) throws IOException {
        if (homeRef.getDistributionGroup() != null) {
            List<DistributionReference> distributionsRefs = homeRef.getDistributionGroup().getDistributions();
            for (DistributionReference distRef : distributionsRefs) {
                out.write(("Distribution," + distRef.getName() + "," + distRef.getVersion() + (distRef.getOracleHomeDiff().equals(BOTH) ? "" : "," + distRef.getOracleHomeDiff()) + System.getProperty("line.separator")).getBytes());
                if (distRef.getFeatureSetGroup() == null) continue;
                List<FeatureSetReference> featuresRefs = distRef.getFeatureSetGroup().getFeatureSets();
                for (FeatureSetReference featureRef : featuresRefs) {
                    if (this._isExtended && !StringUtil.isNullOrEmpty((String)featureRef.getType()) && !StringUtil.isNullOrEmpty((String)featureRef.getSubType())) {
                        out.write(("FeatureSet," + featureRef.getName() + "," + featureRef.getVersion() + "," + featureRef.getType() + "," + featureRef.getSubType() + (featureRef.getOracleHomeDiff().equals(BOTH) ? "" : "," + featureRef.getOracleHomeDiff()) + System.getProperty("line.separator")).getBytes());
                    } else {
                        out.write(("FeatureSet," + featureRef.getName() + "," + featureRef.getVersion() + (featureRef.getOracleHomeDiff().equals(BOTH) ? "" : "," + featureRef.getOracleHomeDiff()) + System.getProperty("line.separator")).getBytes());
                    }
                    if (featureRef.getComponentGroup() == null) continue;
                    List<ComponentReference> componentsRefs = featureRef.getComponentGroup().getComponents();
                    for (ComponentReference compRef : componentsRefs) {
                        out.write(("Component," + compRef.getName() + "," + compRef.getVersion() + (compRef.getOracleHomeDiff().equals(BOTH) ? "" : "," + compRef.getOracleHomeDiff()) + System.getProperty("line.separator")).getBytes());
                        if (compRef.getPatchGroup() == null) continue;
                        List<PatchReference> patchesRefs = compRef.getPatchGroup().getPatches();
                        for (PatchReference patchRef : patchesRefs) {
                            out.write(("Patch,ID: " + patchRef.getPatchId() + ",UID: " + patchRef.getUniquePatchId() + (patchRef.getOracleHomeDiff().equals(BOTH) ? "" : "," + patchRef.getOracleHomeDiff()) + System.getProperty("line.separator")).getBytes());
                        }
                    }
                }
            }
        }
    }

    public void exportToXML(File file) throws DataHandlerException {
        InventoryCompareHelper.getInstance().save((IDataHandlerWrapper)this._inventoryCompare, file);
    }

    public void print() throws InventoryException {
        System.out.println(" Oracle Home1: " + this._inventoryCompare.getOracleHome1());
        System.out.println(" Oracle Home2: " + this._inventoryCompare.getOracleHome2());
        this.printHomeReference(this._inventoryCompare.getOracleHome());
        System.out.println();
    }

    private void printHomeReference(OracleHomeReference homeRefDiffs) throws InventoryException {
        if (homeRefDiffs.getDistributionGroup() != null) {
            List<DistributionReference> distsRefs = homeRefDiffs.getDistributionGroup().getDistributions();
            for (DistributionReference distRef : distsRefs) {
                System.out.println("   Distribution: " + distRef.getName() + OH_INDENT + distRef.getVersion() + (distRef.getOracleHomeDiff().equals(BOTH) ? "" : "," + distRef.getOracleHomeDiff()));
                if (distRef.getFeatureSetGroup() == null) continue;
                List<FeatureSetReference> featuresRefs = distRef.getFeatureSetGroup().getFeatureSets();
                for (FeatureSetReference featureRef : featuresRefs) {
                    if (this.isExtended()) {
                        System.out.println("     FeatureSet: " + featureRef.getName() + OH_INDENT + featureRef.getVersion() + "type: " + featureRef.getType() + "subtype: " + featureRef.getSubType() + OH_INDENT + (featureRef.getOracleHomeDiff().equals(BOTH) ? "" : "," + featureRef.getOracleHomeDiff()));
                    } else {
                        System.out.println("     FeatureSet: " + featureRef.getName() + OH_INDENT + featureRef.getVersion() + (featureRef.getOracleHomeDiff().equals(BOTH) ? "" : "," + featureRef.getOracleHomeDiff()));
                    }
                    if (featureRef.getComponentGroup() == null) continue;
                    List<ComponentReference> compsRefs = featureRef.getComponentGroup().getComponents();
                    for (ComponentReference compRef : compsRefs) {
                        System.out.println("       Component: " + compRef.getName() + OH_INDENT + compRef.getVersion() + (compRef.getOracleHomeDiff().equals(BOTH) ? "" : "," + compRef.getOracleHomeDiff()));
                        if (compRef.getPatchGroup() == null) continue;
                        List<PatchReference> patchesRefs = compRef.getPatchGroup().getPatches();
                        for (PatchReference patchRef : patchesRefs) {
                            System.out.println("         Patch:  ID:" + patchRef.getPatchId() + " UID:" + patchRef.getUniquePatchId() + (patchRef.getOracleHomeDiff().equals(BOTH) ? "" : "," + patchRef.getOracleHomeDiff()));
                        }
                    }
                }
            }
        }
    }

    public File getOutputFile() {
        return this._outputFile;
    }

    public void setOutputFile(File _outputFile) throws Exception {
        if (_outputFile == null || !_outputFile.getAbsolutePath().endsWith(".xml") && !_outputFile.getAbsolutePath().endsWith(".csv")) {
            throw new Exception("The output file is not valid.");
        }
        this._outputFile = _outputFile;
    }

    public File getFirstOracleHome() {
        return this._firstOracleHome;
    }

    public void setFirstOracleHome(File _firstOracleHome) throws Exception {
        if (_firstOracleHome == null || !_firstOracleHome.exists()) {
            throw new Exception("The Oracle Home " + _firstOracleHome + " does not exist.");
        }
        if (!_firstOracleHome.isDirectory() && !_firstOracleHome.getAbsolutePath().endsWith(XML)) {
            throw new Exception("The first Oracle Home must be a directory or an inventory compare xml file");
        }
        this._firstOracleHome = _firstOracleHome;
    }

    public File getSecondOracleHome() {
        return this._secondOracleHome;
    }

    public void setSecondOracleHome(File _secondOracleHome) throws Exception {
        if (_secondOracleHome == null || !_secondOracleHome.exists()) {
            throw new Exception("The Oracle Home " + _secondOracleHome + " does not exist.");
        }
        if (!_secondOracleHome.isDirectory() && !_secondOracleHome.getAbsolutePath().endsWith(XML)) {
            throw new Exception("The second Oracle Home must be a directory or an inventory compare xml file");
        }
        this._secondOracleHome = _secondOracleHome;
    }

    public String getOutputType() {
        return this._outputType;
    }

    public void setOutputType(String outputType) throws Exception {
        if (!(outputType.equals(XML) || outputType.equals(CSV) || outputType.equals(REPORT))) {
            throw new Exception("The output type value of " + outputType + " is not valid and must be one of " + XML + "," + CSV + " or " + REPORT);
        }
        this._outputType = outputType;
    }

    public String getInputType1() {
        return this._inputType1;
    }

    public void setInputType1(String inputType) throws Exception {
        if (!inputType.equals(XML) && !inputType.equals(DIR)) {
            throw new Exception("The input type value of " + inputType + " is not valid and must be one of " + XML + " and " + DIR);
        }
        this._inputType1 = inputType;
    }

    public String getInputType2() {
        return this._inputType2;
    }

    public void setInputType2(String inputType) throws Exception {
        if (!inputType.equals(XML) && !inputType.equals(DIR)) {
            throw new Exception("The input type value of " + inputType + " is not valid and must be one of " + XML + " and " + DIR);
        }
        this._inputType2 = inputType;
    }

    public boolean isExtended() {
        return this._isExtended;
    }

    public void setExtended(String extended) {
        this._isExtended = Boolean.valueOf(extended);
    }

    public com.oracle.cie.gdr.dao.icm.InventoryCompare getInventoryCompare() {
        return this._inventoryCompare;
    }

    public void setInventoryCompare(com.oracle.cie.gdr.dao.icm.InventoryCompare _inventoryCompare) {
        this._inventoryCompare = _inventoryCompare;
    }

    void setArguments(Map<String, String> args) throws Exception {
        if (null != args.get(FIRST_ORACLE_HOME_ARG)) {
            this.setFirstOracleHome(new File(args.get(FIRST_ORACLE_HOME_ARG)));
        }
        if (null != args.get(SECOND_ORACLE_HOME_ARG)) {
            this.setSecondOracleHome(new File(args.get(SECOND_ORACLE_HOME_ARG)));
        }
        if (null != args.get(OUTPUT_TYPE_ARG)) {
            this.setOutputType(args.get(OUTPUT_TYPE_ARG));
        }
        if (null != args.get(OUTPUT_FILE_ARG)) {
            this.setOutputFile(new File(args.get(OUTPUT_FILE_ARG)));
        }
        if (null != args.get(INPUT_TYPE_1_ARG)) {
            this.setInputType1(args.get(INPUT_TYPE_1_ARG));
        }
        if (null != args.get(INPUT_TYPE_2_ARG)) {
            this.setInputType2(args.get(INPUT_TYPE_2_ARG));
        }
        if (null != args.get("-extended")) {
            this.setExtended(args.get("-extended"));
        }
        this._help = args.containsKey("help") && Boolean.valueOf(args.get("help")) != false;
    }

    public static void main(String[] args) {
        try {
            InventoryCompareValidator validator = InventoryCompareValidator.getInstance();
            validator.process(args);
            validator.validate();
            Map<String, String> arguments = validator.getArguments();
            if (Boolean.valueOf(arguments.get(HELP)).booleanValue()) {
                InventoryCompare.printUsageInstructions();
                return;
            }
            Object latestInventoryCompare = InventoryCompare.getLatestInventoryCompare(new File(arguments.get(SECOND_ORACLE_HOME_ARG)), new File(arguments.get(FIRST_ORACLE_HOME_ARG)));
            ClassLoader classLoader = latestInventoryCompare.getClass().getClassLoader();
            InventoryCompare.process("com.oracle.cie.gdr.tools.InventoryCompare", latestInventoryCompare, "setArguments", new Class[]{Map.class}, new Object[]{arguments}, classLoader);
            if (!((Boolean)InventoryCompare.process("com.oracle.cie.gdr.tools.InventoryCompare", latestInventoryCompare, "isHelpEnabled", null, null, classLoader)).booleanValue()) {
                InventoryCompare.process("com.oracle.cie.gdr.tools.InventoryCompare", latestInventoryCompare, "compare", null, null, classLoader);
                InventoryCompare.process("com.oracle.cie.gdr.tools.InventoryCompare", latestInventoryCompare, "export", null, null, classLoader);
                System.out.println("The inventory compare finished execution succesfully.");
            } else {
                InventoryCompare.process("com.oracle.cie.gdr.tools.InventoryCompare", latestInventoryCompare, "printUsageInstructions", null, null, classLoader);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchMethodException || e instanceof ClassNotFoundException || e instanceof SecurityException || e instanceof IllegalAccessException || e instanceof IllegalArgumentException) {
                System.out.println("The inventory compare failed due an incompatibility problem.");
            }
            System.out.println("The inventory compare failed with the following error:");
            e.printStackTrace();
        }
    }

    private static Object process(String className, Object object, String methodName, Class[] argTypes, Object[] args, ClassLoader classloader) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (classloader == null) {
            classloader = CompatibilityService.class.getClassLoader();
        }
        Class<?> classZ = object != null ? object.getClass() : Class.forName(className, true, classloader);
        Method m = classZ.getDeclaredMethod(methodName, argTypes);
        m.setAccessible(true);
        return m.invoke(object, args);
    }

    private static Object getLatestInventoryCompare(File oracleHome1, File oracleHome2) throws Exception {
        OracleHomeReference oracleHomeRef;
        CompatibilityService compatibilityService = CompatibilityService.getInstance();
        String latestVersion = null;
        if (oracleHome1.isFile() && oracleHome1.getAbsolutePath().endsWith(".xml")) {
            oracleHomeRef = (OracleHomeReference)InventoryHelper.getInstance().getRootWrapper(oracleHome1);
            oracleHome1 = new File(oracleHomeRef.getDirectory());
        }
        if (oracleHome2.isFile() && oracleHome2.getAbsolutePath().endsWith(".xml")) {
            oracleHomeRef = (OracleHomeReference)InventoryHelper.getInstance().getRootWrapper(oracleHome2);
            oracleHome2 = new File(oracleHomeRef.getDirectory());
        }
        OracleHomeInventory ohInv1 = InventoryFactory.getOracleHomeInventory(oracleHome1);
        OracleHomeInventory ohInv2 = InventoryFactory.getOracleHomeInventory(oracleHome2);
        latestVersion = compatibilityService.getLatestVersion(oracleHome1, oracleHome2);
        String version1 = compatibilityService.getNextGenVersion(oracleHome1);
        String version2 = compatibilityService.getNextGenVersion(oracleHome2);
        Object inventoryCompare = null;
        if (version1.equals(latestVersion)) {
            inventoryCompare = compatibilityService.getIsolatedInstance(oracleHome1, "com.oracle.cie.gdr.tools.InventoryCompare");
        } else if (version2.equals(latestVersion)) {
            inventoryCompare = compatibilityService.getIsolatedInstance(oracleHome2, "com.oracle.cie.gdr.tools.InventoryCompare");
        }
        return inventoryCompare;
    }

    public void export() throws InventoryException {
        try {
            if (this._outputFile == null) {
                this.print();
            } else if (this._outputFile.getAbsolutePath().endsWith(CSV)) {
                this.exportToCSV(this._outputFile);
            } else if (this._outputFile.getAbsolutePath().endsWith(XML)) {
                this.exportToXML(this._outputFile);
            }
        }
        catch (Exception exception) {
            throw new InventoryException(exception);
        }
    }

    protected static void printUsageInstructions() {
        System.out.println("Usage: run compareInventory.cmd or compareInventory.sh with the following parameters:" + System.getProperty("line.separator"));
        System.out.println("-oracle_home1=<full path to the first oracle home directory or xml dump file>");
        System.out.println("-oracle_home2=<full path to the second oracle home directory or xml dump file>");
        System.out.println("-input_type1=<dir or xml> used to specify the source for the first oracle home.");
        System.out.println("-input_type2=<dir or xml> used to specify the source for the second oracle home.");
        System.out.println("-output_file:<full path of the file to output the compare results> if not present output will be redirected to the console.");
        System.out.println("-help: Prints usage instructions" + System.getProperty("line.separator"));
        System.out.println("Notes:");
        System.out.println("*Inventory Compare automatically detects if the given oracle home is an xml file or a directory.");
        System.out.println("*It also automatically detects if the output file needs to be a csv file or xml file.");
    }

    public boolean isHelpEnabled() {
        return this._help;
    }

    private static class InventoryCompareValidator {
        private static InventoryCompareValidator _instance = new InventoryCompareValidator();
        private Map<String, String> _arguments;

        private InventoryCompareValidator() {
        }

        public static InventoryCompareValidator getInstance() {
            return _instance;
        }

        public void process(String[] args) throws Exception {
            String parameter = null;
            String value = null;
            this._arguments = new HashMap<String, String>();
            for (int i = 0; i < args.length; ++i) {
                parameter = args[i];
                if (i + 1 < args.length) {
                    value = args[i + 1];
                }
                if (parameter.equalsIgnoreCase(InventoryCompare.FIRST_ORACLE_HOME_ARG)) {
                    if (StringUtil.isNullOrEmpty((String)value)) {
                        throw new Exception("The -oracle_home1 hasn't been specified or is empty");
                    }
                    this._arguments.put(InventoryCompare.FIRST_ORACLE_HOME_ARG, value);
                    ++i;
                    continue;
                }
                if (parameter.equalsIgnoreCase(InventoryCompare.SECOND_ORACLE_HOME_ARG)) {
                    if (StringUtil.isNullOrEmpty((String)value)) {
                        throw new Exception("The -oracle_home2 hasn't been specified or is empty");
                    }
                    this._arguments.put(InventoryCompare.SECOND_ORACLE_HOME_ARG, value);
                    ++i;
                    continue;
                }
                if (parameter.equalsIgnoreCase(InventoryCompare.OUTPUT_FILE_ARG)) {
                    if (StringUtil.isNullOrEmpty((String)value)) {
                        throw new Exception("The -output_file hasn't been specified or is empty");
                    }
                    this._arguments.put(InventoryCompare.OUTPUT_FILE_ARG, value);
                    ++i;
                    continue;
                }
                if (parameter.equalsIgnoreCase(InventoryCompare.INPUT_TYPE_1_ARG)) {
                    if (StringUtil.isNullOrEmpty((String)value)) {
                        throw new Exception("The -input_type1 hasn't been specified or is empty");
                    }
                    this._arguments.put(InventoryCompare.INPUT_TYPE_1_ARG, value);
                    ++i;
                    continue;
                }
                if (parameter.equalsIgnoreCase(InventoryCompare.INPUT_TYPE_2_ARG)) {
                    if (StringUtil.isNullOrEmpty((String)value)) {
                        throw new Exception("The -input_type2 hasn't been specified or is empty");
                    }
                    this._arguments.put(InventoryCompare.INPUT_TYPE_2_ARG, value);
                    ++i;
                    continue;
                }
                if (parameter.equalsIgnoreCase(InventoryCompare.OUTPUT_TYPE_ARG)) {
                    if (StringUtil.isNullOrEmpty((String)value)) {
                        throw new Exception("The -output_type hasn't been specified or is empty");
                    }
                    this._arguments.put(InventoryCompare.OUTPUT_TYPE_ARG, value);
                    ++i;
                    continue;
                }
                if (parameter.equalsIgnoreCase(InventoryCompare.JRE_LOC)) {
                    ++i;
                    continue;
                }
                if (parameter.toUpperCase().startsWith("-extended".toUpperCase())) {
                    this._arguments.put("-extended", "true");
                    continue;
                }
                if (parameter.toUpperCase().startsWith(InventoryCompare.HELP.toUpperCase())) {
                    this._arguments.put(InventoryCompare.HELP, "true");
                    continue;
                }
                throw new Exception("Invalid input parameter: " + parameter);
            }
            if (this._arguments.isEmpty()) {
                this._arguments.put(InventoryCompare.HELP, "true");
            }
        }

        public void validate() throws Exception {
            String oh1 = this._arguments.get(InventoryCompare.FIRST_ORACLE_HOME_ARG);
            String oh2 = this._arguments.get(InventoryCompare.SECOND_ORACLE_HOME_ARG);
            String it1 = this._arguments.get(InventoryCompare.INPUT_TYPE_1_ARG);
            String it2 = this._arguments.get(InventoryCompare.INPUT_TYPE_2_ARG);
            String outputType = this._arguments.get(InventoryCompare.OUTPUT_TYPE_ARG);
            String help = this._arguments.get(InventoryCompare.HELP);
            String outputFile = this._arguments.get(InventoryCompare.OUTPUT_FILE_ARG);
            if (StringUtil.isNullOrEmpty((String)help) || !StringUtil.isNullOrEmpty((String)help) && !Boolean.valueOf(help).booleanValue()) {
                File oracleHomeInput;
                if (StringUtil.isNullOrEmpty((String)oh1) || StringUtil.isNullOrEmpty((String)oh2)) {
                    throw new Exception("The Inventory compare requires both oracle homes.");
                }
                if (!StringUtil.isNullOrEmpty((String)it1) && it1.equals(InventoryCompare.DIR) && !new File(oh1).isDirectory()) {
                    throw new Exception("The oracle_home1 must be a directory.");
                }
                if (!StringUtil.isNullOrEmpty((String)it2) && it2.equals(InventoryCompare.DIR) && !new File(oh2).isDirectory()) {
                    throw new Exception("The oracle_home2 must be a directory.");
                }
                if (!StringUtil.isNullOrEmpty((String)it1) && it1.equals(InventoryCompare.XML)) {
                    if (!oh1.endsWith(".xml")) {
                        oh1 = oh1 + ".xml";
                        this._arguments.put(InventoryCompare.FIRST_ORACLE_HOME_ARG, oh1);
                    }
                    if (!(oracleHomeInput = new File(oh1)).exists() || !oracleHomeInput.isFile()) {
                        throw new Exception("The oracle_home1 does not exist or is not a xml file.");
                    }
                }
                if (!StringUtil.isNullOrEmpty((String)it2) && it2.equals(InventoryCompare.XML)) {
                    if (!oh2.endsWith(".xml")) {
                        oh2 = oh2 + ".xml";
                        this._arguments.put(InventoryCompare.SECOND_ORACLE_HOME_ARG, oh2);
                    }
                    if (!(oracleHomeInput = new File(oh2)).exists() || !oracleHomeInput.isFile()) {
                        throw new Exception("The oracle_home2 does not exist or is not a xml file.");
                    }
                }
            }
            if (!StringUtil.isNullOrEmpty((String)outputType)) {
                if (outputType.equals(InventoryCompare.REPORT) && !StringUtil.isNullOrEmpty((String)outputFile)) {
                    this._arguments.remove(InventoryCompare.OUTPUT_FILE_ARG);
                }
                if ((outputType.equals(InventoryCompare.XML) || outputType.equals(InventoryCompare.CSV)) && StringUtil.isNullOrEmpty((String)outputFile)) {
                    throw new Exception("The output_file argument must be specified");
                }
                if (outputType.equals(InventoryCompare.XML) && !StringUtil.isNullOrEmpty((String)outputFile) && !outputFile.endsWith(".xml")) {
                    outputFile = outputFile + ".xml";
                    this._arguments.put(InventoryCompare.OUTPUT_FILE_ARG, outputFile);
                }
                if (outputType.equals(InventoryCompare.CSV) && !StringUtil.isNullOrEmpty((String)outputFile) && !outputFile.endsWith(".csv")) {
                    outputFile = outputFile + ".csv";
                    this._arguments.put(InventoryCompare.OUTPUT_FILE_ARG, outputFile);
                }
            }
        }

        public Map<String, String> getArguments() {
            return this._arguments;
        }
    }
}

