/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionLoaderFactory;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureSetDependencyAnalyzer {
    private MetaDataHome _metaDataHome;
    private DistributionLoader _distributionLoader;
    private Map<FeatureSet, List<FeatureSet>> _featureDependencies;

    public static void main(String[] args) {
        if (args.length != 3 && args.length != 5) {
            System.out.println("Usage: java " + FeatureSetDependencyAnalyzer.class.getName() + " <meta-data-home> <distribution-name> <distribution-version> <feature-set-name> <feature-set-version>");
            System.exit(-1);
        }
        File metaDataHome = new File(args[0]);
        String distributionName = args[1];
        String distributionVersion = args[2];
        String featureName = null;
        String featureVersion = null;
        if (args.length > 3) {
            featureName = args[3];
            featureVersion = args[4];
        }
        try {
            FeatureSetDependencyAnalyzer analyzer = new FeatureSetDependencyAnalyzer(metaDataHome, distributionName, distributionVersion);
            FeatureSet feature = null;
            if (featureName != null && featureVersion != null) {
                feature = analyzer.getFeatureSet(featureName, featureVersion);
            }
            if (feature != null) {
                System.out.println("Feature Dependencies:");
                System.out.println(FeatureSetDependencyAnalyzer.getDependencyString(analyzer.getFeatureSetDependencies(feature), feature));
                System.out.println();
                System.out.println("Feature Dependants:");
                List<FeatureSet> dependants = analyzer.getFeatureSetDependants(feature);
                for (FeatureSet dependant : dependants) {
                    System.out.println(FeatureSetDependencyAnalyzer.getDependencyString(analyzer.getFeatureSetDependencies(dependant), feature));
                    System.out.println();
                }
            } else {
                System.out.println("Feature Dependencies:");
                for (FeatureSet featureSet : analyzer.getFeatures()) {
                    System.out.println(FeatureSetDependencyAnalyzer.getDependencyString(analyzer.getFeatureSetDependencies(featureSet), null));
                    System.out.println();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static String getDependencyString(List<FeatureSet> dependencies, FeatureSet highLightFeature) {
        StringBuilder depString = new StringBuilder();
        for (int x = 0; x < dependencies.size(); ++x) {
            FeatureSet dependency = dependencies.get(x);
            boolean highlight = dependency.equals(highLightFeature);
            if (x != 0) {
                depString.append("->");
            }
            if (highlight) {
                depString.append("*");
            }
            depString.append(dependency.getName()).append("_").append(dependency.getVersion());
            if (!highlight) continue;
            depString.append("*");
        }
        return depString.toString();
    }

    public FeatureSetDependencyAnalyzer(File metaDataHome, String distributionName, String distributionVersion) throws IOException, GdrException, DataHandlerException, DependencyException {
        this(ComponentHelper.getInstance().findMetaDataHome(metaDataHome, false), distributionName, distributionVersion);
    }

    public FeatureSetDependencyAnalyzer(MetaDataHome metaDataHome, String distributionName, String distributionVersion) throws IOException, DataHandlerException, GdrException, DependencyException {
        this._metaDataHome = metaDataHome;
        this.loadFeatures(distributionName, distributionVersion);
    }

    public MetaDataHome getMetaDataHome() {
        return this._metaDataHome;
    }

    public DistributionLoader getDistributionLoader() {
        return this._distributionLoader;
    }

    public Map<FeatureSet, List<FeatureSet>> getFeatureDependencies() {
        return this._featureDependencies;
    }

    public Set<FeatureSet> getFeatures() {
        return new HashSet<FeatureSet>(this._featureDependencies.keySet());
    }

    public FeatureSet getFeatureSet(String featureName, String featureVersion) throws GdrException {
        FeatureSet feature = this.getDistributionLoader().getFeatureLoader().getFeatureSet(featureName, featureVersion);
        if (feature == null) {
            throw new GdrException("The feature set specified did not exist " + featureName + " " + featureVersion);
        }
        return feature;
    }

    public List<FeatureSet> getFeatureSetDependencies(String featureName, String featureVersion) throws GdrException {
        FeatureSet feature = this.getFeatureSet(featureName, featureVersion);
        return this.getFeatureSetDependencies(feature);
    }

    public List<FeatureSet> getFeatureSetDependencies(FeatureSet feature) {
        return feature != null ? this._featureDependencies.get(feature) : new ArrayList<FeatureSet>();
    }

    public List<FeatureSet> getFeatureSetDependants(String featureName, String featureVersion) throws GdrException {
        FeatureSet feature = this.getFeatureSet(featureName, featureVersion);
        return this.getFeatureSetDependants(feature);
    }

    public List<FeatureSet> getFeatureSetDependants(FeatureSet feature) {
        ArrayList<FeatureSet> dependants = new ArrayList<FeatureSet>();
        for (FeatureSet featureSet : this._featureDependencies.keySet()) {
            List<FeatureSet> dependencies;
            if (featureSet.equals(feature) || !(dependencies = this._featureDependencies.get(featureSet)).contains(feature)) continue;
            dependants.add(featureSet);
        }
        return dependants;
    }

    private void loadFeatures(String distributionName, String distributionVersion) throws IOException, DataHandlerException, GdrException, DependencyException {
        this._featureDependencies = new HashMap<FeatureSet, List<FeatureSet>>();
        this._distributionLoader = DistributionLoaderFactory.getDistributionLoader(this.getMetaDataHome(), distributionName, distributionVersion);
        HashSet<FeatureSet> featureSets = new HashSet<FeatureSet>();
        featureSets.addAll(this._distributionLoader.getFeatureSets());
        featureSets.addAll(this.getDistributionLoader().getDistributionTarget().getDummyExternalFeatureSets());
        FeatureSelectionTarget selectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(featureSets, null);
        for (FeatureSet feature : this._distributionLoader.getFeatureSets()) {
            this._featureDependencies.put(feature, FeatureSetHelper.getInstance().getResolvedFeatureDependencies(selectionTarget, feature));
        }
    }
}

