/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionLoaderFactory;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.ftr.FeatureSetDependencies;
import com.oracle.cie.gdr.dao.ftr.FeatureSetDependency;
import com.oracle.cie.gdr.dependency.FeatureDependencyManager;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class FeatureSetDependenciesBuilder {
    private static final Logger _log = Logger.getLogger(FeatureSetDependenciesBuilder.class.getName());
    private File _metaDataHome;
    private File _outputDir;
    private String _distributionName;
    private String _distributionVersion;

    public FeatureSetDependenciesBuilder(File metaDataHome, File outputDir) {
        this(metaDataHome, outputDir, null, null);
    }

    public FeatureSetDependenciesBuilder(File metaDataHome, File outputDir, String distributionName, String distributionVersion) {
        this._metaDataHome = metaDataHome;
        this._outputDir = outputDir;
        this._distributionName = distributionName;
        this._distributionVersion = distributionVersion;
    }

    public void build() throws GdrException {
        boolean distributionSpecific;
        if (this._metaDataHome == null) {
            throw new GdrException("The meta-data home provided was null.");
        }
        if (!this._metaDataHome.isDirectory()) {
            throw new GdrException("The meta-data home provided did not exist or was not a directory.");
        }
        if (this._outputDir == null) {
            throw new GdrException("The output directory provided was null.");
        }
        boolean bl = distributionSpecific = !StringUtil.isNullOrEmpty((String)this._distributionName);
        if (distributionSpecific && StringUtil.isNullOrEmpty((String)this._distributionVersion) || !StringUtil.isNullOrEmpty((String)this._distributionVersion) && !distributionSpecific) {
            throw new GdrException("When providing a specific distribution both distribution name and version are required. Specified name=\"" + this._distributionName + "\" and version=\"" + this._distributionVersion + "\"");
        }
        MetaDataHome metaDataHome = new MetaDataHome(this._metaDataHome, false);
        ArrayList<DistributionLoader> distributions = new ArrayList<DistributionLoader>();
        if (distributionSpecific) {
            try {
                Distribution distribution = DistributionHelper.getInstance().getDistribution(this._metaDataHome, this._distributionName, this._distributionVersion);
                distributions.add(DistributionLoaderFactory.getDistributionLoader(metaDataHome, distribution, false));
            }
            catch (Exception e) {
                throw new GdrException("Failed to parse or load distribution " + DistributionHelper.getInstance().getDistributionFileName(this._distributionName, this._distributionVersion), (Throwable)e);
            }
        } else {
            List<File> files = DistributionHelper.getInstance().getDistributionFiles(metaDataHome);
            for (File file : files) {
                try {
                    Distribution distribution = DistributionHelper.getInstance().getDistribution(file);
                    distributions.add(DistributionLoaderFactory.getDistributionLoader(metaDataHome, distribution, false));
                }
                catch (Exception e) {
                    throw new GdrException("Failed to parse or load distribution " + file, (Throwable)e);
                }
            }
        }
        for (DistributionLoader distribution : distributions) {
            ArrayList<FeatureSetDependency> dependencies = new ArrayList<FeatureSetDependency>();
            Set<FeatureSet> featureSets = distribution.getFeatureLoader().getFeatureSets();
            for (FeatureSet featureSet : featureSets) {
                if (!featureSet.hasFeatureDependency()) continue;
                dependencies.add(featureSet.getFeatureSetDependency());
            }
            if (!dependencies.isEmpty()) {
                FeatureSetDependencies featureSetDependencies = new FeatureSetDependencies(distribution.getDistributionName(), distribution.getDistributionVersion());
                featureSetDependencies.setFeatureSetDependencies(dependencies);
                try {
                    _log.info("Creating feature set dependencies file for distribution \"" + distribution + "\" under output directory " + this._outputDir);
                    new FeatureDependencyManager().saveFeatureDependencies(featureSetDependencies, this._outputDir);
                    continue;
                }
                catch (DataHandlerException e) {
                    throw new GdrException("Failed to save feature set dependencies " + (Object)((Object)featureSetDependencies) + " to output directory " + this._outputDir, (Throwable)e);
                }
            }
            if (distributionSpecific) {
                throw new GdrException("The feature sets in the distribution specified \"" + distribution + "\" did not have any corresponding feature set dependency files.");
            }
            _log.info("Skipping distribution \"" + distribution + "\" since its feature sets did not have any corresponding feature set dependency files.");
        }
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 4) {
            System.out.println("Usage: java " + FeatureSetDependenciesBuilder.class.getName() + " <meta-data-home> <output-dir> <distribution-name> <distribution-version>");
            System.exit(-1);
        }
        File metaDataHome = new File(args[0]);
        File outputDir = new File(args[1]);
        String distributionName = null;
        String distributionVersion = null;
        if (args.length > 2) {
            distributionName = args[2];
            distributionVersion = args[3];
        }
        try {
            FeatureSetDependenciesBuilder builder = new FeatureSetDependenciesBuilder(metaDataHome, outputDir, distributionName, distributionVersion);
            builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

