/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.util.ManifestInfo;
import com.oracle.cie.gdr.dao.cpd.Rule;
import com.oracle.cie.gdr.services.VariableResolverService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuleEvaluationService {
    private static final Logger _log = Logger.getLogger(RuleEvaluationService.class.getName());
    private String _namespace;
    public static final String[] JAR_VERSION_EVALS = new String[]{"jarVersionIsEqual", "jarVersionIsNotEqual", "jarVersionIsLater", "jarVersionIsEarlier"};

    public static RuleEvaluationService getRuleEvaluationService() {
        return RuleEvaluationService.getRuleEvaluationService(null);
    }

    public static RuleEvaluationService getRuleEvaluationService(String namespace) {
        return new RuleEvaluationService(namespace);
    }

    private RuleEvaluationService(String namespace) {
        this._namespace = namespace;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public static boolean isJarVersionEval(String eval) {
        for (String fce : JAR_VERSION_EVALS) {
            if (!fce.equals(eval)) continue;
            return true;
        }
        return false;
    }

    public boolean evaluateRule(Rule rule) throws IllegalArgumentException {
        boolean result;
        String eval = rule.getEval();
        String arg1 = this.substitute(rule.getArg1());
        String arg2 = rule.getArg2();
        String arg3 = rule.getArg3();
        String arg4 = rule.getArg4();
        int argCount = 1;
        if (arg2 != null) {
            arg2 = this.substitute(arg2);
            ++argCount;
        }
        if (arg3 != null) {
            arg3 = this.substitute(arg3);
            ++argCount;
        }
        if (arg4 != null) {
            arg4 = this.substitute(arg4);
            ++argCount;
        }
        try {
            Object[] arguments = new Object[argCount];
            Class[] argTypes = new Class[argCount];
            arguments[0] = arg1;
            argTypes[0] = String.class;
            if (arg2 != null) {
                arguments[1] = arg2;
                argTypes[1] = String.class;
            }
            if (arg3 != null) {
                arguments[2] = arg3;
                argTypes[2] = String.class;
            }
            if (arg4 != null) {
                arguments[3] = arg4;
                argTypes[3] = String.class;
            }
            Method method = RuleEvaluationService.class.getMethod(eval, argTypes);
            result = (Boolean)method.invoke((Object)this, arguments);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The evaluation specified did not exist:" + eval);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("IllegalAccessException executing eval:" + eval);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("InvocationTargetException executing eval:" + eval);
        }
        return result;
    }

    public boolean evaluateRules(List<Rule> rules, Mode mode) throws IllegalArgumentException {
        for (Rule rule : rules) {
            if ((mode != Mode.BUILD || !rule.isBuildEval() || this.evaluateRule(rule)) && (mode != Mode.RUNTIME || !rule.isRuntimeEval() || this.evaluateRule(rule))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(String key, String value) {
        return key.equals(value);
    }

    public boolean equalsIgnoreCase(String key, String value) {
        return key.equalsIgnoreCase(value);
    }

    public boolean notEquals(String key, String value) {
        return !this.equals(key, value);
    }

    public boolean contains(String key, String value) {
        return key.contains(value);
    }

    public boolean notContains(String key, String value) {
        return !this.contains(key, value);
    }

    public boolean jarVersionIsEqual(String key1, String key2) {
        if (key1 != null && key2 != null) {
            Version v2;
            Version v1 = RuleEvaluationService.getJarVersion(new File(key1));
            return v1.compareTo(v2 = new Version(key2)) == 0;
        }
        return false;
    }

    public boolean jarVersionIsNotEqual(String key1, String key2) {
        return !this.jarVersionIsEqual(key1, key2);
    }

    public boolean jarVersionIsLater(String key1, String key2) {
        if (key1 != null && key2 != null) {
            Version v2;
            Version v1 = RuleEvaluationService.getJarVersion(new File(key1));
            return v1.compareTo(v2 = new Version(key2)) > 0;
        }
        return false;
    }

    public boolean jarVersionIsEarlier(String key1, String key2) {
        if (key1 != null && key2 != null) {
            Version v2;
            Version v1 = RuleEvaluationService.getJarVersion(new File(key1));
            return v1.compareTo(v2 = new Version(key2)) < 0;
        }
        return true;
    }

    public static Version getJarVersion(File f) {
        return RuleEvaluationService.getJarVersion(f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getJarVersion(File f, boolean dummyVersion) {
        if (f != null && f.exists()) {
            JarFile jar = null;
            try {
                jar = new JarFile(f);
                String verStr = ManifestInfo.getAttributeValue((JarFile)jar, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
                if (verStr != null) {
                    int index = verStr.indexOf(45);
                    if (index > -1) {
                        verStr = verStr.substring(0, index);
                    }
                    Version version = new Version(verStr);
                    return version;
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Unable to retrieve version of jar:" + f, e);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return dummyVersion ? new Version("0.0.0.0") : null;
    }

    private String substitute(String var) {
        return VariableResolverService.getVariableResolverService().substitute(this.getNamespace(), var);
    }

    public static enum Mode {
        BUILD,
        RUNTIME,
        BOTH;

    }
}

