/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ComponentGroupIdService {
    private static final String GROUPID_PROPERTIES_PATH = "/resources/component_groupId.properties";
    private static final String LEGALESE_PROPERTIES_PATH = "/resources/product_legalese.properties";
    private static Properties _mainProperties;
    private static Properties _legaleseProperties;
    private static final ComponentGroupIdService _instance;

    private ComponentGroupIdService() {
    }

    public static ComponentGroupIdService getInstance() {
        return _instance;
    }

    private static Properties loadProperties(Properties properties, String resource) throws GdrException, IOException {
        if (properties == null) {
            properties = new Properties();
            InputStream is = ComponentGroupIdService.class.getResourceAsStream(resource);
            if (is == null) {
                throw new GdrException("Unable to locate default component group id properties.");
            }
            properties.load(is);
        }
        return properties;
    }

    public String getGroupId(String compName) throws GdrException, IOException {
        _mainProperties = ComponentGroupIdService.loadProperties(_mainProperties, GROUPID_PROPERTIES_PATH);
        Set<Map.Entry<Object, Object>> groupIdComponentsMapSet = _mainProperties.entrySet();
        for (Map.Entry<Object, Object> groupIdComponentMap : groupIdComponentsMapSet) {
            String[] comps;
            for (String name : comps = ((String)groupIdComponentMap.getValue()).split(",")) {
                if (!name.equals(compName)) continue;
                return (String)groupIdComponentMap.getKey();
            }
        }
        return null;
    }

    public Map<String, String> getLegaleseInformation(String groupId) throws GdrException, IOException {
        _legaleseProperties = ComponentGroupIdService.loadProperties(_legaleseProperties, LEGALESE_PROPERTIES_PATH);
        Set<Map.Entry<Object, Object>> infoMapSet = _legaleseProperties.entrySet();
        HashMap<String, String> groupIdInfoMap = new HashMap<String, String>();
        groupIdInfoMap.put("description", "");
        groupIdInfoMap.put("url", "");
        groupIdInfoMap.put("inception-year", "");
        for (Map.Entry<Object, Object> infoMap : infoMapSet) {
            if (!infoMap.getKey().equals(groupId)) continue;
            String[] infoValues = ((String)infoMap.getValue()).trim().split(",");
            groupIdInfoMap.put("description", infoValues[0]);
            groupIdInfoMap.put("url", infoValues[1]);
            groupIdInfoMap.put("inception-year", infoValues[2]);
            break;
        }
        return groupIdInfoMap;
    }

    static {
        _instance = new ComponentGroupIdService();
    }
}

