/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.repository;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.gdr.dao.rvd.ReleaseVersion;
import com.oracle.cie.gdr.helpers.ReleaseVersionHelper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RepositoryReleaseVersionResolver {
    private RepoCommonConfig _repoCommon;
    private List<ReleaseVersion> releaseVersions;
    private RestHandler _restHandler = RestFactory.getRestHandler();
    private String _release;
    private static RepositoryReleaseVersionResolver _instance = new RepositoryReleaseVersionResolver();
    private boolean _isConfigured = false;
    private String _version;

    private RepositoryReleaseVersionResolver() {
    }

    public void configure(String releaseVersion, String localRepo, String remoteRepo) throws RestException, RepositoryCommonException {
        this.configure(releaseVersion, RepoCommonConfig.createRepoCommonConfig(RepositoryReleaseVersionResolver.createRemoteRepositories(remoteRepo), (String)localRepo, null, null));
    }

    public void configure(String releaseVersion, RepoCommonConfig repoCommonConfig) {
        this._release = releaseVersion;
        this._repoCommon = repoCommonConfig;
        this._isConfigured = true;
        this._version = this.getOverrideVersion(releaseVersion);
    }

    private String getOverrideVersion(String releaseVersion) {
        String version = null;
        String[] values = releaseVersion.split(":");
        if (values.length == 2) {
            version = values[1];
        }
        return version;
    }

    public static RepositoryReleaseVersionResolver getInstance() {
        if (_instance == null) {
            _instance = new RepositoryReleaseVersionResolver();
        }
        return _instance;
    }

    private static List<Repository> createRemoteRepositories(String repos) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (!StringUtil.isNullOrEmpty((String)repos, (boolean)true)) {
            String[] locations;
            for (String location : locations = repos.split(",")) {
                repositories.add(RestFactory.getRepository(null, (String)location, null, null));
            }
        }
        return repositories;
    }

    private void load() throws GdrException {
        try {
            if (this.releaseVersions == null) {
                Artifact releaseVersionDefs = this.retrieveLatestArtifact("com.oracle.cie.gdr.version", "release-version-def", this._release, "xml");
                if (releaseVersionDefs == null) {
                    throw new GdrException("There are no release-version-definitions to process for release: " + this._release);
                }
                File file = releaseVersionDefs.getLocalLocation(this._repoCommon.getCacheRepository().getCacheLocation());
                if (!file.exists() && !(file = this._restHandler.retrieveArtifact(releaseVersionDefs, this._repoCommon.getRemoteRepositories(), this._repoCommon.getCacheRepository(), true)).exists()) {
                    throw new GdrException("Unable to locate artifact: " + releaseVersionDefs.toString());
                }
                this.releaseVersions = ReleaseVersionHelper.getInstance().getReleaseVersion(file).getReleaseVersions().getReleaseVersions();
            }
        }
        catch (Exception e) {
            throw new GdrException("Failed to load release versions for " + this._release, (Throwable)e);
        }
    }

    protected Artifact retrieveLatestArtifact(String groupId, String artifactId, String version, String type) throws RestException {
        List<Repository> repositories = Arrays.asList(this._repoCommon.getRepositories());
        Version latestVersion = this._restHandler.latestVersionSearch(groupId, artifactId, version + "-*", repositories);
        return DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.version", "release-version-def", latestVersion, "xml");
    }

    public String getTokenValue(String token) throws GdrException {
        if (this._version != null) {
            return this._version;
        }
        this.load();
        token = token.substring(1);
        for (ReleaseVersion releaseVersion : this.releaseVersions) {
            if (!releaseVersion.getToken().equals(token)) continue;
            return releaseVersion.getValue();
        }
        return null;
    }

    public String replaceVersionToken(String version) throws GdrException {
        if (!StringUtil.isNullOrEmpty((String)version) && this.isConfigured() && version.startsWith("$")) {
            try {
                version = this.getTokenValue(version);
            }
            catch (Exception e) {
                throw new GdrException((Throwable)e);
            }
        }
        return version;
    }

    public boolean isConfigured() {
        return this._isConfigured;
    }
}

